#include "Battleship.h"

// do nothing in the constructor and destructor

Battleship::Battleship()
{
    
}

Battleship::~Battleship()
{
    
}

int Battleshipp[4][6] = {
    {0,0,1,1,0,0},
    {0,0,1,1,0,0},
    {1,1,1,1,1,1},
    {1,1,1,1,1,1},  
};

void Battleship::init(int x,int height, int width)
{
     _x = WIDTH/2;  // x value on screen is fixed
     _y = HEIGHT/2 - height/2;  // y depends on height of screen and height of Battleship
     _height = height;
     _width = width;
     _speed = 1;  // default speed
     _score = 0;  // start score from zero
     _life = 3;   // set the life 
}
 
void Battleship::draw(N5110 &lcd)
 {
     // draw a battleship in screen buffer. 
     lcd.drawSprite(_x,_y,_width,_height,(int*)Battleshipp);
}
     
void Battleship::update(Direction d,float mag) 
{
     _speed = int(mag*10.0f);  // scale is arbitrary, could be changed in future
     
     // update x and y values depending on direction of movement
     // West is decrement as origin is at the top-left so decreasing moves up
     
     if (d == W) {
         _x-=_speed;
     }
     if (d == E) {
         _x+=_speed;
     }
     // North is decrement as origin is at the top-left so decreasing moves up
     
     if (d == N) {
         _y-=_speed;
     }
     else if (d == S) {
         _y+=_speed;
     }
    
     // check the x and y origin to ensure that the paddle doesn't go off screen
     if (_x < 1) {
         _x = 1;
     }
     if (_x > WIDTH - _width - 1) {
         _x = WIDTH - _width - 1;
     }
         
     if (_y < 1) {
         _y = 1; 
     }
     if (_y > HEIGHT - _height - 1) {
         _y = HEIGHT - _height - 1;
     }
}
     
void Battleship::add_score()    
{
     _score = _score + 1;
}     
     
int Battleship::get_score()    
{
     return _score;
}     
     
Vector2D Battleship::get_pos() {
    Vector2D p = {_x,_y};
    return p;    
}
     
void Battleship::minus_life()
{
     _life = _life - 1;
}    

int Battleship::get_life()
{
     return _life;
} 