#include "mbed.h"
#include "mbed_events.h"
#include "MAX30101.h"

#define FIFO_DATA_MAX 288

DigitalOut pwr1v8(PTA29);
DigitalOut pwr3v3b(PTC13);
DigitalOut pwr15v(PTB12);
I2C i2c0(PTB1, PTB0);
InterruptIn maximInterrupt(PTB18);
Serial pc(USBTX, USBRX);

EventQueue evqueue(32 * EVENTS_EVENT_SIZE);
Thread t;

MAX30101 hr(i2c0);

int mask_ppg = 0;
uint32_t count = 0;
void interruptHandlerQueued() {
    
    MAX30101::InterruptBitField_u interruptStatus;
    hr.getInterruptStatus(interruptStatus);
    printf("Interrupt Status: 0x%02x\r\n", interruptStatus.all);
    
    if (interruptStatus.bits.pwr_rdy == 0x1) {
        printf("Powered on\r\n");
        
//        // Soft reset
//        MAX30101::ModeConfiguration_u modeConf;
//        modeConf.all = 0;
//        modeConf.bits.reset = 1;
//        hr.setModeConfiguration(modeConf);
//        wait(0.01);
//        
//        // Configure FIFO
//        MAX30101::FIFO_Configuration_u fifoConf;
//        hr.getFIFOConfiguration(fifoConf);
//        pc.printf("FIFO Configuration: 0x%02x\r\n", fifoConf.all);
//          
//        // Set LED power
//        hr.setLEDPulseAmplitude(MAX30101::LED1_PA, 0x0C);
//        hr.setLEDPulseAmplitude(MAX30101::ProxModeLED_PA, 0x19);
//        pc.printf("LED set\r\n");
//        
//        MAX30101::SpO2Configuration_u spo2Conf;
//        hr.getSpO2Configuration(spo2Conf);
//        spo2Conf.bits.led_pw = MAX30101::PW_1;
//        spo2Conf.bits.spo2_sr = MAX30101::SR_100_Hz;
//        hr.setSpO2Configuration(spo2Conf);
//        hr.getSpO2Configuration(spo2Conf);
//        pc.printf("SpO2 Configuration: 0x%02x\r\n", spo2Conf.all);
//        
//        // Proximity settings
//        hr.setProxIntThreshold(0x14);
//        
//        // Enable HR mode
//        modeConf.all = 0;
//        modeConf.bits.mode = MAX30101::HeartRateMode;
//        hr.setModeConfiguration(modeConf);
//        printf("Mode set\r\n");
    }
    
//    if (interruptStatus.bits.prox_int == 0x1) {
//        printf("Proximity Triggered, entered HR Mode.");
//    }
//    
//    if (interruptStatus.bits.ppg_rdy == 0x1) {
//        printf("PPG Ready.\r\n");
//        mask_ppg = 1;
//    }
//    
//    if (interruptStatus.bits.a_full == 0x1) {
//        printf("FIFO Almost Full.\r\n");
//        uint8_t data[FIFO_DATA_MAX];
//        uint16_t readBytes = 0;
//        hr.readFIFO(MAX30101::OneLedChannel, data, readBytes);
//        
//        for (uint16_t i = 0; i < readBytes; i += 3) {
//            uint8_t sample[4] = {0};
//            sample[0] = data[i + 2];
//            sample[1] = data[i + 1];
//            sample[2] = data[i];
//            
//            printf("%u\r\n", *(uint32_t *) sample);
//        }
//    }
//    
//    interruptStatus.all = 0xFF;
//    if (mask_ppg == 1) {
//        interruptStatus.bits.ppg_rdy = 0;
//    }
//    hr.enableInterrupts(interruptStatus);
}

void interruptHandler() {
    evqueue.call(interruptHandlerQueued);
}

// main() runs in its own thread in the OS
int main() {
    printf("Hello world.\r\n");
    
    t.start(callback(&evqueue, &EventQueue::dispatch_forever));
     
    pwr1v8 = 1;
    pwr3v3b = 1;
    pwr15v = 0;
    
    maximInterrupt.fall(interruptHandler);
    maximInterrupt.enable_irq();
    
    MAX30101::InterruptBitField_u interruptStatus;
    interruptStatus.all = 0xFF;
    hr.enableInterrupts(interruptStatus);
    
    return 0;
}

