
#include "mbed.h"
#include "ESP8266.h"
 
Serial pc(USBTX,USBRX);

//POT sensor 
AnalogIn pot(A0); 

//wifi UART port and baud rate
ESP8266 wifi(D8, D2, 9600); 

//buffers for wifi library
char snd[255],resp[1000];
char http_cmd[300], comm[300];

int timeout = 8000; //timeout for wifi commands

//SSID and password for connection
#define SSID "Hahaha" //"AmeyaHotspot"//"IoTServer" //"AmeyaHotspot" //"Xperia S_f19d" 
#define PASS "hehehehe"  //"12345678" //"iotserver"  //"12345678" //"profpappu" 

//Remote IP
#define IP "184.106.153.149"
//#define IP "https://api.thingspeak.com"
//#define IP "192.168.0.25"
//waterlevelue global variable
float waterlevel = 0; 

//Public and private keys for phant

char* Update_Key = "025P4LTWTLVPM64E";
//char* Private_Key = "GPoWnRM60yidrB0e1pXD";
 
//Wifi init function
void wifi_initialize(void){
    
    pc.printf("******** Resetting wifi module ********\r\n");
    wifi.Reset();
    
    //wait for 5 seconds for response, else display no response receiveed
    if (wifi.RcvReply(resp, 5000))    
        pc.printf("%s",resp);    
    else
        pc.printf("No response");
    
    pc.printf("******** Setting Station mode of wifi with AP ********\r\n");
    wifi.SetMode(1);    // set transparent  mode
    if (wifi.RcvReply(resp, timeout))    //receive a response from ESP
        pc.printf("%s",resp);    //Print the response onscreen
    else
        pc.printf("No response while setting mode. \r\n");
    
    pc.printf("******** Joining network with SSID and PASS ********\r\n");
    wifi.Join(SSID, PASS);     
    if (wifi.RcvReply(resp, timeout))    
        pc.printf("%s",resp);   
    else
        pc.printf("No response while connecting to network \r\n");
        
    pc.printf("******** Getting IP and MAC of module ********\r\n");
    wifi.GetIP(resp);     
    if (wifi.RcvReply(resp, timeout))    
        pc.printf("%s",resp);    
    else
        pc.printf("No response while getting IP \r\n");
    
    pc.printf("******** Setting WIFI UART passthrough ********\r\n");
    wifi.setTransparent();          
    if (wifi.RcvReply(resp, timeout))    
        pc.printf("%s",resp);    
    else
        pc.printf("No response while setting wifi passthrough. \r\n");
    wait(1);    
    
    pc.printf("******** Setting single connection mode ********\r\n");
    wifi.SetSingle();             
    wifi.RcvReply(resp, timeout);
    if (wifi.RcvReply(resp, timeout))    
        pc.printf("%s",resp);    
    else
        pc.printf("No response while setting single connection \r\n");
    wait(1);
}

void wifi_send(void){
    
    pc.printf("******** Starting TCP connection on IP and port ********\r\n");
    wifi.startTCPConn(IP,80);    //cipstart
    wifi.RcvReply(resp, timeout);
    if (wifi.RcvReply(resp, timeout))    
        pc.printf("%s",resp);    
    else
        pc.printf("No response while starting TCP connection \r\n");
    wait(1);
    
    //create link 
    sprintf(http_cmd,"/update?api_key=%s&field1=%f",Update_Key,waterlevel); 
    pc.printf(http_cmd);
    
    pc.printf("******** Sending URL to wifi ********\r\n");
    wifi.sendURL(http_cmd, comm);   //cipsend and get command
    if (wifi.RcvReply(resp, timeout))    
        pc.printf("%s",resp);    
 
    pc.printf("No response while sending URL \r\n");
    
    //wifi.SendCMD("AT+CIPCLOSE"); //Close the connection to server
    //wifi.RcvReply(resp, timeout);
    //pc.printf("%s", resp);
}

int main () {
    
    
    wifi_initialize();
    
    while (1) {
        //waterlevel = 255*pot.read();
        waterlevel = 255;
        pc.printf("Current waterlevel is = %.3f \r\n", waterlevel);
        
        wifi_send();
        //wait(5);
    }
}