#ifndef ST7789V_H
#define ST7789V_H

#define ROW  240  
#define COL  240

#define  FONT_W  16
#define  FONT_H  21

#define RED    0xF800     
#define GREEN  0x07E0
#define BLUE   0x001F
#define WHITE  0xFFFF
#define BLACK  0x0000

#define PIC_WIDTH    48     //预备向LCD显示区域填充的图片的大小
#define PIC_HEIGHT   37

void ST7789V_Init(void);
void ST7789V_writeCommand(unsigned char command);
void ST7789V_writeOneDot(unsigned int color);
void ST7789V_writeData(unsigned char data);
void ST7789V_writeDataStream(unsigned char * pData, int numBytes);
unsigned char ST7789V_readData();
void ST7789V_readDataStream(unsigned char *data,int numItems);

unsigned char ToOrd(unsigned char ch); 
void WriteOneDot(unsigned int color);
void DispOneChar(unsigned char ord,unsigned int Xstart,unsigned int Ystart,unsigned int TextColor,unsigned int BackColor);   // ord:0~95
void DispStr(unsigned char *str,unsigned int Xstart,unsigned int Ystart,unsigned int TextColor,unsigned int BackColor);
void DispInt(unsigned int i,unsigned int Xstart,unsigned int Ystart,unsigned int TextColor,unsigned int BackColor);
void BlockWrite(unsigned int Xstart,unsigned int Xend,unsigned int Ystart,unsigned int Yend);

void DispColor(unsigned int color);
void DispBand(void);
void DispPic(unsigned int *picture);

void LCD_block_test(void);

static unsigned char ascii[]=
{
//宋体16,点阵为：宽x高=16x21 
/*--  文字:  0  --*/  
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1F,0x00,0x31,0x80,0x31,0x80,0x60,0xC0,
0x60,0xC0,0x60,0xC0,0x60,0xC0,0x60,0xC0,0x60,0xC0,0x60,0xC0,0x60,0xC0,0x31,0x80,
0x31,0x80,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  文字:  1  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x06,0x00,0x1E,0x00,0x06,0x00,0x06,0x00,
0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,
0x06,0x00,0x1F,0x80,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  文字:  2  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0x00,0x61,0x80,0x60,0xC0,0x60,0xC0,
0x60,0xC0,0x01,0x80,0x01,0x80,0x03,0x00,0x06,0x00,0x0C,0x00,0x18,0x00,0x30,0xC0,
0x60,0xC0,0x7F,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  文字:  3  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3E,0x00,0x63,0x00,0x61,0x80,0x61,0x80,
0x01,0x80,0x03,0x00,0x0F,0x00,0x01,0x80,0x00,0xC0,0x00,0xC0,0x60,0xC0,0x60,0xC0,
0x61,0x80,0x3F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  文字:  4  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x80,0x03,0x80,0x07,0x80,0x07,0x80,0x0F,0x80,
0x1B,0x80,0x1B,0x80,0x33,0x80,0x63,0x80,0x63,0x80,0x3F,0xC0,0x03,0x80,0x03,0x80,
0x03,0x80,0x0F,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  文字:  5  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0xC0,0x30,0x00,0x30,0x00,0x30,0x00,
0x30,0x00,0x3F,0x00,0x39,0x80,0x30,0xC0,0x00,0xC0,0x00,0xC0,0x60,0xC0,0x60,0xC0,
0x61,0x80,0x3F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  文字:  6  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0x80,0x18,0xC0,0x30,0xC0,0x30,0x00,
0x60,0x00,0x7F,0x00,0x71,0x80,0x60,0xC0,0x60,0xC0,0x60,0xC0,0x60,0xC0,0x30,0xC0,
0x31,0x80,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  文字:  7  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0xC0,0x61,0x80,0x63,0x00,0x03,0x00,
0x06,0x00,0x06,0x00,0x0C,0x00,0x0C,0x00,0x18,0x00,0x18,0x00,0x18,0x00,0x18,0x00,
0x18,0x00,0x18,0x00,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  文字:  8  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1F,0x00,0x31,0x80,0x60,0xC0,0x60,0xC0,
0x60,0xC0,0x31,0x80,0x1F,0x00,0x31,0x80,0x60,0xC0,0x60,0xC0,0x60,0xC0,0x60,0xC0,
0x31,0x80,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  文字:  9  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1F,0x00,0x31,0x80,0x61,0x80,0x60,0xC0,
0x60,0xC0,0x60,0xC0,0x60,0xC0,0x31,0xC0,0x1F,0xC0,0x00,0xC0,0x01,0x80,0x61,0x80,
0x63,0x00,0x3E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  文字:  A  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x06,0x00,0x0E,0x00,0x0E,0x00,0x0F,0x00,
0x1B,0x00,0x1B,0x00,0x1B,0x00,0x31,0x80,0x3F,0x80,0x31,0x80,0x31,0x80,0x60,0xC0,
0x60,0xC0,0xF1,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  文字:  B  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0x00,0x31,0x80,0x30,0xC0,0x30,0xC0,
0x30,0xC0,0x31,0x80,0x3F,0x00,0x31,0xC0,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,
0x30,0xC0,0x7F,0x80,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  文字:  C  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0xE0,0x18,0xE0,0x30,0x60,0x30,0x60,
0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x60,0x30,0x60,
0x38,0xC0,0x0F,0x80,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  文字:  D  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0x00,0x31,0x80,0x30,0xC0,0x30,0xC0,
0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0xC0,0x30,0xC0,
0x31,0x80,0x7F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  文字:  E  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0xC0,0x30,0xC0,0x30,0x60,0x30,0x00,
0x31,0x80,0x31,0x80,0x3F,0x80,0x31,0x80,0x31,0x80,0x30,0x00,0x30,0x00,0x30,0x60,
0x30,0xC0,0x7F,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  文字:  F  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0xC0,0x30,0xC0,0x30,0x60,0x30,0x00,
0x31,0x80,0x31,0x80,0x3F,0x80,0x31,0x80,0x31,0x80,0x30,0x00,0x30,0x00,0x30,0x00,
0x30,0x00,0x78,0x00,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  文字:  G  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0xC0,0x19,0xC0,0x30,0xC0,0x30,0xC0,
0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x61,0xE0,0x60,0xC0,0x30,0xC0,0x30,0xC0,
0x18,0xC0,0x0F,0x80,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  文字:  H  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x79,0xE0,0x30,0xC0,0x30,0xC0,0x30,0xC0,
0x30,0xC0,0x30,0xC0,0x3F,0xC0,0x30,0xC0,0x30,0xC0,0x30,0xC0,0x30,0xC0,0x30,0xC0,
0x30,0xC0,0x79,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  文字:  I  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0xC0,0x06,0x00,0x06,0x00,0x06,0x00,
0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,
0x06,0x00,0x3F,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  文字:  J  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0xF0,0x01,0x80,0x01,0x80,0x01,0x80,
0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,
0x01,0x80,0x61,0x80,0x63,0x00,0x3E,0x00,0x00,0x00,

/*--  文字:  K  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7B,0xE0,0x30,0xC0,0x31,0x80,0x33,0x00,
0x36,0x00,0x3C,0x00,0x3E,0x00,0x36,0x00,0x33,0x00,0x33,0x00,0x31,0x80,0x31,0x80,
0x30,0xC0,0x79,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  文字:  L  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x78,0x00,0x30,0x00,0x30,0x00,0x30,0x00,
0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x60,
0x30,0xC0,0x7F,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  文字:  M  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0xF0,0x70,0xE0,0x70,0xE0,0x70,0xE0,
0x79,0xE0,0x79,0xE0,0x79,0xE0,0x7B,0x60,0x6F,0x60,0x6F,0x60,0x6F,0x60,0x66,0x60,
0x66,0x60,0xF6,0xF0,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  文字:  N  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x79,0xE0,0x38,0xC0,0x3C,0xC0,0x3C,0xC0,
0x3C,0xC0,0x36,0xC0,0x36,0xC0,0x36,0xC0,0x33,0xC0,0x33,0xC0,0x31,0xC0,0x31,0xC0,
0x31,0xC0,0x78,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  文字:  O  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0x00,0x19,0x80,0x30,0xC0,0x60,0x60,
0x60,0x60,0x60,0x60,0x60,0x60,0x60,0x60,0x60,0x60,0x60,0x60,0x60,0x60,0x30,0xC0,
0x19,0x80,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  文字:  P  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0x80,0x30,0xC0,0x30,0x60,0x30,0x60,
0x30,0x60,0x30,0xC0,0x3F,0x80,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,
0x30,0x00,0x78,0x00,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  文字:  Q  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0x00,0x19,0x80,0x30,0xC0,0x60,0x60,
0x60,0x60,0x60,0x60,0x60,0x60,0x60,0x60,0x60,0x60,0x60,0x60,0x6E,0x60,0x3B,0xC0,
0x3B,0xC0,0x0F,0x80,0x01,0xE0,0x01,0xC0,0x00,0x00,

/*--  文字:  R  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0x00,0x31,0x80,0x30,0xC0,0x30,0xC0,
0x30,0xC0,0x31,0x80,0x3F,0x00,0x36,0x00,0x33,0x00,0x33,0x00,0x31,0x80,0x31,0x80,
0x30,0xC0,0x78,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  文字:  S  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1F,0xC0,0x31,0xC0,0x60,0xC0,0x60,0xC0,
0x60,0x00,0x30,0x00,0x1C,0x00,0x07,0x00,0x01,0x80,0x00,0xC0,0x60,0xC0,0x60,0xC0,
0x71,0x80,0x7F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  文字:  T  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0xC0,0x66,0x60,0x66,0x60,0x06,0x00,
0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,
0x06,0x00,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  文字:  U  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x79,0xE0,0x30,0xC0,0x30,0xC0,0x30,0xC0,
0x30,0xC0,0x30,0xC0,0x30,0xC0,0x30,0xC0,0x30,0xC0,0x30,0xC0,0x30,0xC0,0x30,0xC0,
0x19,0x80,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  文字:  V  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF1,0xF0,0x60,0x60,0x30,0xC0,0x30,0xC0,
0x30,0xC0,0x19,0x80,0x19,0x80,0x19,0x80,0x19,0x80,0x0F,0x00,0x0F,0x00,0x0F,0x00,
0x06,0x00,0x06,0x00,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  文字:  W  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xF0,0x66,0x60,0x66,0x60,0x66,0x60,
0x66,0xC0,0x37,0xC0,0x3F,0xC0,0x3F,0xC0,0x3F,0xC0,0x3F,0xC0,0x3F,0xC0,0x19,0x80,
0x19,0x80,0x19,0x80,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  文字:  X  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x79,0xE0,0x30,0xC0,0x19,0x80,0x19,0x80,
0x0F,0x00,0x0F,0x00,0x06,0x00,0x06,0x00,0x0F,0x00,0x0F,0x00,0x19,0x80,0x19,0x80,
0x30,0xC0,0x79,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  文字:  Y  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x79,0xE0,0x30,0xC0,0x19,0x80,0x19,0x80,
0x1B,0x00,0x0F,0x00,0x0F,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,
0x06,0x00,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  文字:  Z  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0xE0,0x30,0xC0,0x60,0xC0,0x01,0x80,
0x03,0x00,0x03,0x00,0x06,0x00,0x06,0x00,0x0C,0x00,0x18,0x00,0x18,0x00,0x30,0x60,
0x30,0xC0,0x7F,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  文字:  [  --*/
0x00,0x00,0x00,0x00,0x0F,0xC0,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,
0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,
0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0F,0xC0,0x00,0x00,

/*--  文字:  \  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x30,0x00,0x30,0x00,0x18,0x00,0x18,0x00,0x18,0x00,
0x0C,0x00,0x0C,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x03,0x00,0x03,0x00,0x01,0x80,
0x01,0x80,0x01,0x80,0x00,0xC0,0x00,0xC0,0x00,0x00,

/*--  文字:  ]  --*/
0x00,0x00,0x00,0x00,0x7E,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,
0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,
0x06,0x00,0x06,0x00,0x06,0x00,0x7E,0x00,0x00,0x00,

/*--  文字:  ^  --*/
0x00,0x00,0x00,0x00,0x1E,0x00,0x1E,0x00,0x33,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  文字:  _  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xE0,

/*--  文字:  `  --*/
0x00,0x00,0x00,0x00,0x1C,0x00,0x06,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  文字:  a  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x1F,0x00,0x31,0x80,0x31,0x80,0x0F,0x80,0x39,0x80,0x61,0x80,0x61,0x80,
0x63,0xE0,0x3F,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  文字:  b  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x70,0x00,0x30,0x00,0x30,0x00,0x30,0x00,
0x30,0x00,0x3F,0x80,0x38,0xC0,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,
0x38,0xC0,0x3F,0x80,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  文字:  c  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x1F,0x00,0x31,0x80,0x61,0x80,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0xC0,
0x31,0x80,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  文字:  d  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0xC0,0x00,0xC0,0x00,0xC0,0x00,0xC0,
0x00,0xC0,0x1F,0xC0,0x31,0xC0,0x60,0xC0,0x60,0xC0,0x60,0xC0,0x60,0xC0,0x60,0xC0,
0x31,0xE0,0x1F,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  文字:  e  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x1F,0x00,0x31,0x80,0x60,0xC0,0x7F,0xC0,0x60,0x00,0x60,0x00,0x60,0xC0,
0x31,0x80,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  文字:  f  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0xC0,0x06,0x60,0x0C,0x00,0x0C,0x00,
0x0C,0x00,0x7F,0x80,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,
0x0C,0x00,0x3F,0x80,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  文字:  g  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x1F,0xF0,0x30,0xF0,0x30,0xC0,0x30,0xC0,0x30,0xC0,0x1F,0x80,0x30,0x00,
0x3F,0x80,0x30,0xE0,0x60,0x60,0x70,0x60,0x3F,0xC0,

/*--  文字:  h  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x70,0x00,0x30,0x00,0x30,0x00,0x30,0x00,
0x30,0x00,0x3F,0x80,0x38,0xC0,0x30,0xC0,0x30,0xC0,0x30,0xC0,0x30,0xC0,0x30,0xC0,
0x30,0xC0,0x79,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  文字:  i  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0E,0x00,0x0E,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x1E,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,
0x06,0x00,0x1F,0x80,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  文字:  j  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x80,0x03,0x80,0x00,0x00,0x00,0x00,
0x00,0x00,0x07,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,
0x01,0x80,0x01,0x80,0x01,0x80,0x33,0x00,0x3E,0x00,

/*--  文字:  k  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x70,0x00,0x30,0x00,0x30,0x00,0x30,0x00,
0x30,0x00,0x33,0xC0,0x33,0x00,0x36,0x00,0x3C,0x00,0x3E,0x00,0x33,0x00,0x31,0x80,
0x30,0xC0,0x79,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  文字:  l  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3E,0x00,0x06,0x00,0x06,0x00,0x06,0x00,
0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,
0x06,0x00,0x3F,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  文字:  m  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0xFF,0xE0,0x77,0x60,0x66,0x60,0x66,0x60,0x66,0x60,0x66,0x60,0x66,0x60,
0x66,0x60,0xFF,0xF0,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  文字:  n  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x7F,0x80,0x38,0xC0,0x30,0xC0,0x30,0xC0,0x30,0xC0,0x30,0xC0,0x30,0xC0,
0x30,0xC0,0x79,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  文字:  o  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x1F,0x00,0x31,0x80,0x60,0xC0,0x60,0xC0,0x60,0xC0,0x60,0xC0,0x60,0xC0,
0x31,0x80,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  文字:  p  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x7F,0x80,0x38,0xC0,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,
0x38,0xC0,0x3F,0x80,0x30,0x00,0x30,0x00,0x78,0x00,

/*--  文字:  q  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x1F,0xC0,0x31,0xC0,0x60,0xC0,0x60,0xC0,0x60,0xC0,0x60,0xC0,0x60,0xC0,
0x31,0xC0,0x1F,0xC0,0x00,0xC0,0x00,0xC0,0x01,0xE0,

/*--  文字:  r  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x7B,0xE0,0x1E,0x60,0x1C,0x00,0x18,0x00,0x18,0x00,0x18,0x00,0x18,0x00,
0x18,0x00,0x7F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  文字:  s  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x1F,0xC0,0x31,0xC0,0x30,0xC0,0x38,0x00,0x0F,0x00,0x01,0xC0,0x30,0xC0,
0x38,0xC0,0x3F,0x80,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  文字:  t  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0C,0x00,0x0C,0x00,
0x0C,0x00,0x3F,0x80,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0xC0,
0x0C,0xC0,0x07,0x80,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  文字:  u  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x71,0xC0,0x30,0xC0,0x30,0xC0,0x30,0xC0,0x30,0xC0,0x30,0xC0,0x30,0xC0,
0x31,0xE0,0x1F,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  文字:  v  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x79,0xE0,0x30,0xC0,0x19,0x80,0x19,0x80,0x19,0x80,0x0F,0x00,0x0F,0x00,
0x06,0x00,0x06,0x00,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  文字:  w  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0xFF,0xF0,0x66,0x60,0x66,0xE0,0x3F,0xC0,0x3F,0xC0,0x3F,0xC0,0x3F,0xC0,
0x19,0x80,0x19,0x80,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  文字:  x  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x79,0xE0,0x30,0xC0,0x19,0x80,0x0F,0x00,0x06,0x00,0x0F,0x00,0x19,0x80,
0x30,0xC0,0x79,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  文字:  y  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x7B,0xE0,0x30,0xC0,0x19,0x80,0x19,0x80,0x0F,0x00,0x0F,0x00,0x06,0x00,
0x06,0x00,0x06,0x00,0x0C,0x00,0x3C,0x00,0x38,0x00,

/*--  文字:  z  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x7F,0x80,0x63,0x00,0x66,0x00,0x06,0x00,0x0C,0x00,0x18,0x00,0x30,0xC0,
0x61,0x80,0x7F,0x80,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  文字:  {  --*/
0x00,0x00,0x00,0x00,0x01,0xC0,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,
0x03,0x00,0x07,0x00,0x0C,0x00,0x07,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,
0x03,0x00,0x03,0x00,0x03,0x00,0x01,0xC0,0x00,0x00,

/*--  文字:  |  --*/
0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,
0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,
0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,

/*--  文字:  }  --*/
0x00,0x00,0x00,0x00,0x38,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,
0x0C,0x00,0x0E,0x00,0x03,0x00,0x0E,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,
0x0C,0x00,0x0C,0x00,0x0C,0x00,0x38,0x00,0x00,0x00,

/*--  文字:  ~  --*/
0x3C,0x00,0x76,0x30,0x63,0x70,0x01,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  文字:     --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  文字:  !  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x0E,0x00,0x0E,0x00,0x0E,0x00,0x0E,0x00,0x0E,0x00,
0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x00,0x00,0x00,0x00,
0x0E,0x00,0x0E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  文字:  "  --*/
0x00,0x00,0x00,0x00,0x1F,0x80,0x1F,0x80,0x3F,0x00,0x36,0x00,0x6C,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  文字:  #  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x18,0xC0,0x18,0xC0,0x18,0xC0,0x7F,0xE0,
0x18,0xC0,0x18,0xC0,0x18,0xC0,0x31,0x80,0x31,0x80,0x7F,0xE0,0x31,0x80,0x31,0x80,
0x31,0x80,0x31,0x80,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  文字:  $  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x06,0x00,0x0F,0x80,0x1E,0xC0,0x36,0xC0,0x37,0xC0,
0x36,0x00,0x1E,0x00,0x0E,0x00,0x07,0x00,0x07,0x80,0x06,0xC0,0x3E,0xC0,0x36,0xC0,
0x37,0x80,0x1F,0x00,0x06,0x00,0x06,0x00,0x00,0x00,

/*--  文字:  %  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x38,0xC0,0x6D,0x80,0x6D,0x80,0x6F,0x00,
0x6F,0x00,0x6F,0x00,0x3E,0x00,0x07,0xC0,0x0F,0x60,0x0F,0x60,0x1B,0x60,0x1B,0x60,
0x1B,0x60,0x31,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  文字:  &  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1E,0x00,0x33,0x00,0x33,0x00,0x33,0x00,
0x36,0x00,0x3F,0xC0,0x39,0x80,0x79,0x80,0xCF,0x00,0xCF,0x00,0xC7,0x00,0xC6,0x00,
0x67,0x60,0x3D,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  文字:  '  --*/
0x00,0x00,0x00,0x00,0x78,0x00,0x78,0x00,0x18,0x00,0x30,0x00,0xE0,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  文字:  (  --*/
0x00,0x00,0x00,0x00,0x00,0x60,0x00,0xC0,0x01,0x80,0x03,0x00,0x03,0x00,0x03,0x00,
0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x03,0x00,0x03,0x00,
0x03,0x00,0x01,0x80,0x00,0xC0,0x00,0x60,0x00,0x00,

/*--  文字:  )  --*/
0x00,0x00,0x00,0x00,0x60,0x00,0x30,0x00,0x18,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,
0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x0C,0x00,0x0C,0x00,
0x0C,0x00,0x18,0x00,0x30,0x00,0x60,0x00,0x00,0x00,

/*--  文字:  *  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x06,0x00,0x06,0x00,0x66,0x60,
0x7F,0xE0,0x1F,0x80,0x06,0x00,0x1F,0x80,0x7F,0xE0,0x66,0x60,0x06,0x00,0x06,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  文字:  +  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x06,0x00,0x06,0x00,0x06,0x00,
0x06,0x00,0x06,0x00,0x7F,0xE0,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  文字:  ,  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x78,0x00,0x78,0x00,0x18,0x00,0x30,0x00,0xE0,0x00,

/*--  文字:  -  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x7F,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  文字:  .  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x70,0x00,0x70,0x00,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  文字:  /  --*/
0x00,0x00,0x00,0x00,0x00,0x60,0x00,0xC0,0x00,0xC0,0x01,0xC0,0x01,0x80,0x01,0x80,
0x03,0x00,0x03,0x00,0x06,0x00,0x06,0x00,0x0C,0x00,0x0C,0x00,0x18,0x00,0x18,0x00,
0x38,0x00,0x30,0x00,0x30,0x00,0x60,0x00,0x00,0x00,

/*--  文字:  :  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x0E,0x00,0x0E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x0E,0x00,0x0E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  文字:  ;  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x0C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,

/*--  文字:  <  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0x01,0x80,0x03,0x00,0x06,0x00,0x0C,0x00,
0x18,0x00,0x30,0x00,0x60,0x00,0x30,0x00,0x18,0x00,0x0C,0x00,0x06,0x00,0x03,0x00,
0x01,0x80,0x00,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  文字:  =  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x7F,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  文字:  >  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x60,0x00,0x30,0x00,0x18,0x00,0x0C,0x00,0x06,0x00,
0x03,0x00,0x01,0x80,0x00,0xC0,0x01,0x80,0x03,0x00,0x06,0x00,0x0C,0x00,0x18,0x00,
0x30,0x00,0x60,0x00,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  文字:  ?  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x1F,0x00,0x31,0x80,0x60,0xC0,0x70,0xC0,0x70,0xC0,
0x00,0xC0,0x00,0xC0,0x01,0x80,0x03,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x00,0x00,
0x0E,0x00,0x0E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,

/*--  文字:  @  --*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0x80,0x19,0xC0,0x30,0xC0,0x37,0xE0,
0x6F,0xE0,0x6D,0xE0,0x79,0xE0,0x7B,0x60,0x7B,0x60,0x7B,0xC0,0x6F,0xC0,0x30,0x60,
0x18,0xC0,0x0F,0x80,0x00,0x00,0x00,0x00,0x00,0x00,

//ord:95
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,

};

#endif
