#include "mbed.h"
#include "stm32f103c8t6.h"
#include "string.h"
#include "main.h"
#include "stdio.h"
#include "stdlib.h"

DigitalOut led1(PC_13);

//Serial pc(PB_10,PB_11);

UARTSerial *_serial;

UARTSerial debug_uart(PB_10, PB_11, 115200);
UARTSerial wifi_uart(PA_2, PA_3, 115200);

//Serial wifi_uart(PA_2, PA_3, 115200);
//Serial debug_uart(PB_10, PB_11, 115200);

char      rxBuf[32];
char      wifi_rxBuf[32];  //receive msg from xiaomi cloud
short     g_isCloud = 0;   //flag for connected xiaomi cloud

//char      set_property[] = {"down set_properties "}
//char      get_property[] = {"down get_properties "}
int       i = 0;

ATCmdParser *_parser;
     
void led1_thread() {
    int length;
    char len[20];
    char l;
    int position = 0;
    int error = 0;
    
    while (true) 
    {
        wifi_uart.write("get_down\r", 9);
        if(wifi_uart.readable())
        {
            length = wifi_uart.read(wifi_rxBuf, sizeof(wifi_rxBuf));
            if(!(strncmp(wifi_rxBuf,"down none",9)))
            {
                //if return "down none"
                debug_uart.write("--- none",8);
            }
            else if(!(strncmp(wifi_rxBuf,"down set_properties ",20)))
            {
                //if return "down set_properties"
                debug_uart.write("--- set:", 8);
                debug_uart.write(wifi_rxBuf, length);
                
                //set properties
                if(wifi_rxBuf[22] == '7')
                {
                    //set target-position
                    position = atoi(&wifi_rxBuf[24]);
                    sprintf(len, "position:%d", position);
                    debug_uart.write(len, sizeof(len));
                }
                
                //report result to cloud
                wifi_uart.write("result 2 7 0\r", 13);
                if(wifi_uart.readable())
                {
                    length = wifi_uart.read(wifi_rxBuf, sizeof(wifi_rxBuf));
                    debug_uart.write(wifi_rxBuf, length);
                }
            }
            else if(!(strncmp(wifi_rxBuf,"down get_properties ",20)))
            {
                //if return "down get_properties"
                debug_uart.write("--- get:", 8);
                debug_uart.write(wifi_rxBuf, length);
                
                //report result to cloud
            }
            else if(!(strncmp(wifi_rxBuf,"down MIIO_net_change ",21)))
            {
                //if return "down MIIO_net_change"
                debug_uart.write(wifi_rxBuf, length);
                debug_uart.write("--- net:",8);
                if((!strncmp(&wifi_rxBuf[21], "offline", 7)))
                {
                    //连接中
                    debug_uart.write("offline\r", 8);
                }
                else if((!strncmp(&wifi_rxBuf[21], "local", 5)))
                {
                    //连上路由器但未连上服务器
                    debug_uart.write("local\r", 6);
                }
                else if((!strncmp(&wifi_rxBuf[21], "cloud", 5)))
                {
                    //连上小米云服务器
                    debug_uart.write("cloud\r", 6);
                    g_isCloud = 1;
                }
            }
            else
            {
                debug_uart.write(wifi_rxBuf, length);
            }
            
         }
        thread_sleep_for(400);
    }
}


void led0_thread() {
    int length;
    while (1) {
        if(debug_uart.readable())
        {
              length = debug_uart.read(rxBuf, sizeof(rxBuf)); 
              debug_uart.write(rxBuf, length); 
              wifi_uart.write(rxBuf, length);
              debug_uart.write("111\r",4);
        }
        if(wifi_uart.readable())
        {
            length = wifi_uart.read(rxBuf, sizeof(rxBuf));
            debug_uart.write(rxBuf, length); 
            debug_uart.write("222\r",4);
              
        }
        wait(0.5);
    }
}


int main() {
    int length;
    led1 = 1;
    
    wait(1);
    
    debug_uart.write("hello world",11);
    
    WIFI_PWREN = 1;   
 
    //Thread thread0(osPriorityNormal, 512, nullptr, nullptr);
    Thread thread1(osPriorityNormal, 512, nullptr, nullptr);
    //Thread thread2(osPriorityNormal, 512, nullptr, nullptr);
    
    //thread0.start(led0_thread);
    thread1.start(led1_thread);
    
    //wifi_serial.printf("model\r\n");
    //thread1.start(led1_thread);
    //thread2.start(led2_thread);
    while(1)
    {
        debug_uart.write("--main--\r\n",10);
        if(g_isCloud)
        {
            debug_uart.write("connect to xiaomi cloud\r\n",25);
        }
        wait(3);
    }

}