#include "mbed.h"
#include "BMP085.h"
#include "GPS.h"
#define pengurang 2.5
#define massa_jenis_udara 1.2

DigitalOut myled(LED1);
BMP085 bmp085(P0_27, P0_28);
Serial pc(USBTX, USBRX);
GPS gps(P4_28, P4_29);
AnalogIn Ain(P0_23);

float ADCdata;
float konversinya;
float hasilnya;
float sebelum;
float kecepatan;
char kirim[16];
char simpan;
 
int main() {
    pc.printf("main\n");
    float p, t, h;
 
    while(1) {
        myled = 1;
        bmp085.update();
        p = bmp085.get_pressure();
        t = bmp085.get_temperature();
        
        if ( t>30) {
            
            h = (0.07 * t* t) - (2.75 * t) + 45.5;
            }
            
            else if ( t>20){
                h = (1.1 * t) - 7;
                }

       
        
ADCdata = Ain.read();
//konversinya = map( ADCdata, 0, 1023,0,5);
konversinya = (ADCdata*5);
hasilnya = (konversinya) - (pengurang);
sebelum = (2*hasilnya)/ (massa_jenis_udara);
kecepatan = (sqrt(sebelum))- 1.25;

/*
 pc.printf("tekanan %6.2f Pa  suhu %6.2f deg C \n", p, t);
 myled = 0;
 pc.printf("humidity %f ", h);


//pc.printf (" data = %f \n",ADCdata);
//pc.printf ("konversi = %f \n", konversinya);
//pc.printf (" P = %f \n", hasilnya);
pc.printf ("v angin = %f \n", kecepatan);
//pc.printf ("latitude= -7.766091, longitude= 110.372009, altitude= 184.30 \n");
*/

if(gps.sample()) {
            pc.printf("I'm at longitude %f, latitude %f\n", gps.longitude, gps.latitude);
        } else {
            pc.printf("tunggu lock(\n");
        }  
pc.printf ("\n");


//pc.printf(" BALLON 184.30 %6.2f %6.2f %f %f utara 0 %f %f \n",p,t,h,kecepatan,gps.latitude,gps.longitude);


wait (1);
    }//while
}//main
