#include "mbed.h"
#include "et095g.h"

#include <vector>
#include <time.h>
#include <stdlib.h>

ET095G app;

int direction = 0;

void tick_handler() {}

// Left button, changes direction counterclockwisely
void pb1_handler() {
    if(direction < 3)
        direction++;
    else
        direction = 0;
}

// Right button, changes direction clockwisely
void pb0_handler() {
    if(direction > 0)
        direction--;
    else
        direction = 3;
}

struct Position {
    int x;
    int y;

    Position(int x = 0, int y = 0) {
        this->x = x;
        this->y = y;
    }
    
    bool equals(const Position &p) {
        return this->x == p.x && this->y == p.y;
    }
};

int main() {
    app.display.clearImmediate();

    size_t length = 3;
    Position food, snake(7, 0);
    bool foodExists = false;

    std::vector<Position> history;

    srand(time(NULL));

    app.display.locate(snake.x, snake.y);
    app.display.printf("O");
    app.display.update();

    

    while(1) {

        if(food.equals(snake))
        {
            length++;
            foodExists = false;
        }

        history.push_back(Position(snake.x, snake.y));

        if(history.size() > length-1) {
            app.display.locate(history.at(0).x, history.at(0).y);
            app.display.printf(" ");

            history.erase(history.begin());
        }
     
       if(foodExists == false) {       
            bool foodIsBody;
            
            do {
                food.x = rand() % 15;
                food.y = rand() % 15;
            
                foodIsBody = false;
            
                for(size_t i = 0; i < history.size(); i++) {
                    if(food.equals(history.at(i)))
                        foodIsBody = true;
                }
            
            } while(foodIsBody);
            
            app.display.locate(food.x, food.y);
            app.display.printf("#");
            
            foodExists = true;
            
        }

        switch(direction) {
        case 0: snake.y++; break;
        case 1: snake.x++; break;
        case 2: snake.y--; break;
        case 3: snake.x--; break;
        }
        
        app.display.locate(snake.x, snake.y);
        app.display.printf("@");
        app.display.update();

        if(snake.y > 15 || snake.x > 15 || snake.y < 0 || snake.x < 0)
            break;
            
        bool gameover = false;
        for(size_t i = 0; i < history.size()-1; i++) {
            if(snake.equals(history.at(i)))
                gameover = true;
        }

        if(gameover)
            break;
        
        if(length == 255) {
            app.display.locate(3, 7);
            app.display.printf("ULTIMATE");
            app.display.locate(6,8);
            app.display.printf("VICTORY");
            app.display.locate(3, 10);
            app.display.printf("Score: %i", length);
            app.display.update();
            
            wait(1);
            
            return 0;
        }

        wait(0.1);
    }

    app.display.locate(3, 7);
    app.display.printf("Game Over");
    app.display.locate(3, 9);
    app.display.printf("Score: %i", length);
    app.display.update();

    // Wait for the display to be updated before exiting
    wait(1);
}