#include "pid.hpp"
#include "mbed.h"
PID::PID(double kp,double ki,double kd,int id):Kp(kp),Ki(ki),Kd(kd),ID(id){
    e[0]=0.0;
    mv = 0.0;
    integral = 0.0;
}
void PID::Update(double Value,double Target,double dt,bool addmv){/*
    e[2]=Target-Value;
    P=(e[2]-e[1])/dt;
    I= e[2];
    D=(e[2]- 2*e[1] + e[0])/dt/dt;
    e[0] = e[1];
    e[1] = e[2];
    integral += ((Kp*P)+(Ki*I)+(Kd*D))*dt;
    mv += integral;*/
    e[2] = Target - Value;
    P = e[2];
    integral += (e[2]+e[1])*dt/2.0;
    I = integral;
    D = (e[2]-e[1])/dt;
    if(addmv) mv += ((Kp*P)+(Ki*I)+(Kd*D));
    else mv = ((Kp*P)+(Ki*I)+(Kd*D));
    e[1] = e[2];
    if(Target == 0.0) mv = 0.0;
    if(mv<Min) mv = Min;
    if(mv>Max) mv = Max;
    if(integral<Min) integral = Min;
    if(integral>Max) integral = Max;
}
double PID::getmv(){
    double rtn;
    if(mv<Min)rtn=Min;
    else rtn=mv;
    if(mv>Max)rtn=Max;
    else rtn=mv;
    return rtn;
}
void PID::setLimit(double max,double min){
  Max = max;
  Min = min;
}
PID::~PID(){}
