#include "NK_tuner.hpp"

Nk_tuner::Nk_tuner(double dt,double finish):dt(dt),finish(finish){}
Nk_tuner::~Nk_tuner(){}
double Nk_tuner::getK(double Value){
    n++;
    K = (K*(n-1) + Value)/n;
    return K;
}
void Nk_tuner::Update(double Value){
    static double mt = 0.0,mtt = 0.0,mtv = 0.0;
    static double old,timer;
    double tilt;
    timer += dt;
    tilt = (Value - old) / dt;
    if(mt < tilt) {
        mt = tilt;
        mtt = timer;
        mtv = Value;
    }
    if(Value <= 0.632*K) T = timer;
    old = Value;
    if(timer >= finish){
        L = mtt-(mtv/mt);
        T = T - L;
        old = 0.0;
        mt = 0.0;
        mtt = 0.0;
        mtv = 0.0;
    }
}