#ifndef take_encoder
#define take_encoder

#include "mbed.h"

#ifndef M_PI
#define M_PI 3.14159265358979
#endif
/*INFO
*coreを使わない場合idは何でもいいです
*タイヤの角度~角加加速度まで一応計測できます
*単位はrad~rad/s³
*/
class Encoder{
public:
    Encoder(PinName pinA,PinName pinB,int resolution,int mode,int id);
    ~Encoder();
    void Update(double dt);
    double get_Theta();
    double get_Omega();
    double get_Alpha();
    double get_Jerk();
    double get_ID();
    long long int pulse;
private:
    InterruptIn *pin_A;
    InterruptIn *pin_B;
    double theta[2];
    double omega[2];
    double alpha[2];
    double jerk;
    
    int resolution;
    int mode;
    
    void init();
    void riseA(void);
    void riseB(void);
    void fallA(void);
    void fallB(void);
    int ID;
};

#endif
