#include "encoder.hpp"

Encoder::Encoder(PinName pinA,PinName pinB,int resolution,int mode,int id):resolution(resolution),mode(mode),ID(id){
    pin_A = new InterruptIn(pinA,PullUp);
    pin_B = new InterruptIn(pinB,PullUp);
    pulse = 0;
    theta[0] = 0.0;
    theta[1] = 0.0;
    omega[0] = 0.0;
    omega[1] = 0.0;
    alpha[0] = 0.0;
    alpha[1] = 0.0;
    jerk = 0.0;
    init();
}
Encoder::~Encoder(){
    pin_B->disable_irq();
    pin_B->disable_irq();
    delete pin_A;
    delete pin_B;
}

void Encoder::Update(double dt){
    theta[1] = 2.0*M_PI * pulse / resolution / mode;
    omega[1] = (theta[1]-theta[0])/dt;
    alpha[1] = (omega[1]-omega[0])/dt;
    jerk     = (alpha[1]-alpha[0])/dt;
    theta[0] = theta[1];
    omega[0] = omega[1];
    alpha[0] = alpha[1];
}

double Encoder::get_Theta() {return theta[1];}
double Encoder::get_Omega() {return omega[1];}
double Encoder::get_Alpha() {return alpha[1];}
double Encoder::get_Jerk()  {return jerk;}
double Encoder::get_ID()    {return ID;}

void Encoder::init(){
    pulse = 0;
    if(mode <= 0 or 4 < mode) mode = 4;
    if(1 <= mode) pin_A->rise(callback(this,&Encoder::riseA));
    if(2 <= mode) pin_A->fall(callback(this,&Encoder::fallA));
    if(3 <= mode) pin_B->rise(callback(this,&Encoder::riseB));
    if(4 <= mode) pin_B->fall(callback(this,&Encoder::fallB));
}

void Encoder::riseA(void){pin_B->read() ? pulse-- : pulse++;}
void Encoder::riseB(void){pin_A->read() ? pulse++ : pulse--;}
void Encoder::fallA(void){pin_B->read() ? pulse++ : pulse--;}
void Encoder::fallB(void){pin_A->read() ? pulse-- : pulse++;}
