#include "motor.hpp"

Motor::Motor(PinName plus,PinName minus,int period,int id):ID(id){
    Plus = new PwmOut(plus);
    Minus = new PwmOut(minus);
    Plus->period_us(period);
    Minus->period_us(period);
}
Motor::~Motor(){}

void Motor::setLimit(double max,double min){
    Max = max;
    Min = min;
}

void Motor::setPWM(double pwm){
    if(pwm >= Max)      Pwm=Max;
    else if(pwm<=Min)   Pwm=Min;
    else                Pwm=pwm;
    if(Pwm<0.0){
        *Plus=0.0;
        *Minus=Pwm*-1;
    }
    else{
        *Minus=0.0;
        *Plus=Pwm;
    }
}

double Motor::get_ID() {return ID;}