#include "imc.hpp"
#include "mbed.h"
IMC::IMC(double K,double T,int id):K(K),T(T),ID(id){
    x = 0.0;
    mv = 0.0;
}
double IMC::simulate(double x,double u,double dt){
    this->x = x + (-x + K*u)/T*dt;
    return this->x;
}
void IMC::Update(double Value,double Target,double dt){
    mv = (Target - Value + simulate(x,mv,dt))*(1.0/K);
    
    if(Target == 0.0) mv = 0.0;
    if(mv<Min) mv = Min;
    if(mv>Max) mv = Max;
}
double IMC::getmv(){
    return mv;
}
double IMC::getx(){
    return x;
    }
void IMC::setLimit(double max,double min){
  Max = max;
  Min = min;
}
IMC::~IMC(){}
