#ifndef take_core
#define take_core

#include "scrp_slave.hpp"

#include <vector>
#include "mbed.h"
#include "motor.hpp"
#include "encoder.hpp"
#include "pid.hpp"
#include "imc.hpp"
#include "robot.hpp"
#include "position.hpp"

#define OMNI4 1
#define OMNI3 2
#define MECANUM 3

/*INFO
*Robot ROBOTNAME(四つ角のタイヤの半径(mm),計測輪の半径(mm),中心から角までの距離(mm),中心からフレームまでの距離(mm));
*Core rbt(&ROBOTNAME,一周期の時間(s);
*rbt.addMOT(正転ピン,逆転ピン,2048,最大値,最小値,ID(0~3));
*rbt.addENC(正転ピン,逆転ピン,分解能,モード(1~4),ID(0~7));
*rbt.addPID(Kp,Ki,Kd,最大値,最小値,ID(0~7));
*ROBOTNAME.setCWID(右前輪,右後輪,左後輪,左前輪のID);
*ROBOTNAME setSWID(前方,右方,後方,左方計測輪のID);
*IDは対応するもの同士で合わせてください
*addMOTやaddPIDのあとに->setLimit(max,min)をつけると値を制限できます
*rbt.START();ロボットの動作開始
*rbt.LOOP();一周期の時間固定のため、ループの最後に書いてください
*rbt.WAIT(時間(us));ループ内の時間がその時間になるまで待機します
*rbt.setVelocity(速度のx成分,y成分,角速度);
*rbt.getStatus();ロボットの速度と位置を取得します
*
*/

class Core{
public:
    Core(Robot* robot,int mode,double dt);
    Motor* addMOT(PinName plus,PinName minus,int period,int id);
    void addENC(PinName plus,PinName minus,int resolution,int mode,int id);
    PID* addPID(double Kp,double Ki,double Kd,int id);
    IMC* addIMC(double K,double T,int id);
    void setVelocity(double Vx,double Vy,double Vw);
    void setPWM(double pwm,int id);
    void START();
    bool LOOP();
    void WAIT(double wt);
    Position getStatus(bool onground = true);
    Timer timer;
    Robot* rbt;
    std::vector<Motor*>     Mots;
    std::vector<Encoder*>   Encs;
    std::vector<PID*>       PIDs;
    std::vector<IMC*>       IMCs;
    ScrpSlave* scrp;
    Core(Robot* robot,ScrpSlave* scrp,int mode,double dt);
    void sendPWM(double pwm,int id);
    void sendVelocity(double Vx,double Vy,double Vw);
    void setPosition(double x,double y,double theta);
private:
    int mode;
    double dt;
    unsigned long long t;
    Position pos,vel;
};

#endif