#include "core.hpp"

Core::Core(Robot* robot,int mode,double dt):rbt(robot),mode(mode),dt(dt),Mots(5),Encs(9),PIDs(6),IMCs(6){
    pos.x = 0.0;
    pos.y = 0.0;
    pos.theta = 0.0;
    vel.x = 0.0;
    vel.y = 0.0;
    vel.theta = 0.0;}
Motor* Core::addMOT(PinName plus,PinName minus,int period,int id){
    Mots.at(id) = new Motor(plus,minus,period,id);
    return Mots.at(id);
}
void Core::addENC(PinName plus,PinName minus,int resolution,int mode,int id){Encs.at(id) = new Encoder(plus,minus,resolution,mode,id);}
PID* Core::addPID(double Kp,double Ki,double Kd,int id){
    PIDs.at(id) = new PID(Kp,Ki,Kd,id);
    return PIDs.at(id);
}
IMC* Core::addIMC(double K,double T,int id){
    printf("%d\n",id);
    IMCs.at(id) = new IMC(K,T,id);
    return IMCs.at(id);
}
void Core::setPWM(double pwm,int id){Mots[id]->setPWM(pwm);}

void Core::START(){timer.start();}
bool Core::LOOP(){
    bool ret = true;
    long long int temp;
    while(temp <= dt*1000.0*1000.0){
        temp = timer.read_us()-t;
        if(temp < 0.0){
            ret = false;
            printf("WARN!:Out of cycle:%lld(us)\n",temp);
        }
    }
    t = timer.read_us();
    return ret;
}
void Core::WAIT(double wt){while(timer.read_us()-t <= wt*1000.0*1000.0);}
void Core::setPosition(double x,double y,double theta){
    pos.x = x;
    pos.y = y;
    pos.theta = theta;
}
void Core::setVelocity(double Vx,double Vy,double Vw){
    double w1,w2,w3,w4;
    double vx,vy;
    vx = cos(pos.theta-M_PI/4.0)*Vx + sin(pos.theta-M_PI/4.0)*Vy;
    vy = - sin(pos.theta-M_PI/4.0)*Vx + cos(pos.theta-M_PI/4.0)*Vy;
    switch(mode){
        case OMNI4:
            w1 = -vx + rbt->C2CD*Vw;
            w2 = vy + rbt->C2CD*Vw;
            w3 = vx + rbt->C2CD*Vw;
            w4 = -vy + rbt->C2CD*Vw;
            break;
        case OMNI3:
            w1 = 0.0;
            w2 = 0.0;
            w3 = 0.0;
            w4 = 0.0;
            break;
        case MECANUM:
            w1 = 0.0;
            w2 = 0.0;
            w3 = 0.0;
            w4 = 0.0;
            break;
    }/*
    Encs[rbt->RF]->Update(dt);
    Encs[rbt->RB]->Update(dt);
    Encs[rbt->LB]->Update(dt);
    Encs[rbt->LF]->Update(dt);*/
    PIDs[rbt->RF]->Update(Encs[rbt->RF]->get_Omega(),w1/rbt->CWR,dt);
    PIDs[rbt->RB]->Update(Encs[rbt->RB]->get_Omega(),w2/rbt->CWR,dt);
    PIDs[rbt->LB]->Update(Encs[rbt->LB]->get_Omega(),w3/rbt->CWR,dt);
    PIDs[rbt->LF]->Update(Encs[rbt->LF]->get_Omega(),w4/rbt->CWR,dt);
    
    setPWM(PIDs[rbt->RF]->getmv(),rbt->RF);
    setPWM(PIDs[rbt->RB]->getmv(),rbt->RB);
    setPWM(PIDs[rbt->LB]->getmv(),rbt->LB);
    setPWM(PIDs[rbt->LF]->getmv(),rbt->LF);
}
Position Core::getStatus(bool onground){
    double vx,vy,vw;
    double vX,vY;
    double Rw1,Rw2,Rw3,Rw4;
    Encs[rbt->F]->Update(dt);
    Encs[rbt->R]->Update(dt);
    Encs[rbt->B]->Update(dt);
    Encs[rbt->L]->Update(dt);
    Encs[rbt->RF]->Update(dt);
    Encs[rbt->RB]->Update(dt);
    Encs[rbt->LB]->Update(dt);
    Encs[rbt->LF]->Update(dt);
    if(onground){
        
        Rw1 = Encs[rbt->F]->get_Omega()*(rbt->SWR);
        Rw2 = Encs[rbt->R]->get_Omega()*(rbt->SWR);
        Rw3 = Encs[rbt->B]->get_Omega()*(rbt->SWR);
        Rw4 = Encs[rbt->L]->get_Omega()*(rbt->SWR);
    }
    else {
        
        Rw1 = Encs[rbt->RF]->get_Omega()*(rbt->SWR);
        Rw2 = Encs[rbt->RB]->get_Omega()*(rbt->SWR);
        Rw3 = Encs[rbt->LB]->get_Omega()*(rbt->SWR);
        Rw4 = Encs[rbt->LF]->get_Omega()*(rbt->SWR);
    }
    vx = (-1*Rw1 + Rw3)/2.0;
    vy = (Rw2 + -1*Rw4)/2.0;
    vw = (Rw1 + Rw2 + Rw3 + Rw4)/(rbt->C2SD)/4.0;
    if(onground){
        vX = cos(pos.theta)*vx - sin(pos.theta)*vy;
        vY = sin(pos.theta)*vx + cos(pos.theta)*vy;
    }
    else {
        vX = cos(pos.theta-M_PI/4.0)*vx - sin(pos.theta-M_PI/4.0)*vy;
        vY = sin(pos.theta-M_PI/4.0)*vx + cos(pos.theta-M_PI/4.0)*vy;
    }
    
    pos.x += (vel.x+vX)*dt/2.0;
    pos.y += (vel.y+vY)*dt/2.0;
    pos.theta += (vel.theta+vw)*dt/2.0;
    vel.x = vX;
    vel.y = vY;
    vel.theta = vw;
    return pos;
}
Core::Core(Robot* robot,ScrpSlave* scrp,int mode,double dt):rbt(robot),scrp(scrp),mode(mode),dt(dt),Mots(5),Encs(9),PIDs(6),IMCs(6){}
void Core::sendPWM(double pwm,int id){scrp->send1(255, id ,(pwm * 100.0));}
void Core::sendVelocity(double Vx,double Vy,double Vw){
    double w1,w2,w3,w4;
    double vx,vy;
    vx = cos(pos.theta-M_PI/4.0)*Vx + sin(pos.theta-M_PI/4.0)*Vy;
    vy = - sin(pos.theta-M_PI/4.0)*Vx + cos(pos.theta-M_PI/4.0)*Vy;
    switch(mode){
        case OMNI4:
            w1 = -vx + rbt->C2CD*Vw;
            w2 = vy + rbt->C2CD*Vw;
            w3 = vx + rbt->C2CD*Vw;
            w4 = -vy + rbt->C2CD*Vw;
            break;
        case OMNI3:
            w1 = 0.0;
            w2 = 0.0;
            w3 = 0.0;
            w4 = 0.0;
            break;
        case MECANUM:
            w1 = 0.0;
            w2 = 0.0;
            w3 = 0.0;
            w4 = 0.0;
            break;
    }/*
    Encs[rbt->RF]->Update(dt);
    Encs[rbt->RB]->Update(dt);
    Encs[rbt->LB]->Update(dt);
    Encs[rbt->LF]->Update(dt);*/
    /*
    PIDs[rbt->RF]->Update(Encs[rbt->RF]->get_Omega(),w1/rbt->CWR,dt);
    PIDs[rbt->RB]->Update(Encs[rbt->RB]->get_Omega(),w2/rbt->CWR,dt);
    PIDs[rbt->LB]->Update(Encs[rbt->LB]->get_Omega(),w3/rbt->CWR,dt);
    PIDs[rbt->LF]->Update(Encs[rbt->LF]->get_Omega(),w4/rbt->CWR,dt);*/
    
    IMCs[rbt->RF]->Update(Encs[rbt->RF]->get_Omega(),w1/rbt->CWR,dt);
    IMCs[rbt->RB]->Update(Encs[rbt->RB]->get_Omega(),w2/rbt->CWR,dt);
    IMCs[rbt->LB]->Update(Encs[rbt->LB]->get_Omega(),w3/rbt->CWR,dt);
    IMCs[rbt->LF]->Update(Encs[rbt->LF]->get_Omega(),w4/rbt->CWR,dt);
    
    printf("%lf,%lf,%lf\n",Encs[1]->get_Omega(),w1/rbt->CWR,IMCs[1]->getmv());
    /*
    WAIT(0.01);
    sendPWM(PIDs[rbt->RF]->getmv(),rbt->RF);
    WAIT(0.0125);
    sendPWM(PIDs[rbt->RB]->getmv(),rbt->RB);
    WAIT(0.015);
    sendPWM(PIDs[rbt->LB]->getmv(),rbt->LB);
    WAIT(0.0175);
    sendPWM(PIDs[rbt->LF]->getmv(),rbt->LF);*/
    
    WAIT(0.01);
    sendPWM(IMCs[rbt->RF]->getmv(),rbt->RF);
    WAIT(0.0125);
    sendPWM(IMCs[rbt->RB]->getmv(),rbt->RB);
    WAIT(0.015);
    sendPWM(IMCs[rbt->LB]->getmv(),rbt->LB);
    WAIT(0.0175);
    sendPWM(IMCs[rbt->LF]->getmv(),rbt->LF);
}