#ifndef _52SERIAL
#define _52SERIAL

#include "mbed.h"
#include "Buffer52.hpp"
/*
使用方法
ARRC::gotoSerial ser(PC_12,PD_2,9600);
DigitalOut rede(PH_1);
送信側 rede = 1;
受信側 rede = 0;

publish(id,送信する値,INT or FLOAT or FUNC(送信する型の指定));
INT,FLOAT 送信と受信でなるべく合わせること。
FUNC 受信側で設定した関数に値を引数として送信する。
subscribe(id,変数または関数のポインタ(例 &value , func));

受信側の関数(scrp_slaveでいうところのコマンド)の宣言方法

void func(Pack data){
    printf("subscribed_int:%d\n",data.integer);
    printf("subscribed_float:%d\n",data.decimal);
    led = !led;
}
ToDo
redeを組み込む
送受信可能にする
*/

namespace ARRC{

const unsigned STARTDATA = 0x01;
const unsigned ENDDATA = 0x09;
const unsigned INT = 1;
const unsigned FLOAT = 2;
const unsigned FUNC = 3;

typedef union {
    float decimal;
    int integer;
} Pack;

typedef void (*Func)(Pack data);

typedef union {
    float* decimal;
    int* integer;
} DATA;

class gotoSerial{
public:
    gotoSerial(PinName tx,PinName rx,int baudrate);
    bool publish(unsigned id,int num,unsigned type);
    bool publish(unsigned id,float num,unsigned type);
    bool subscribe(unsigned id,int* var);
    bool subscribe(unsigned id,float* var);
    bool subscribe(unsigned id,Func func);
private:
    void interrupt_read();
    bool update();
    int sub_vars_size;
    std::vector<DATA> sub_vars;
    std::vector<Func> sub_funcs;
    Buffer<int8_t> buf;
    Serial ser;
};

}

#endif
