#ifndef _52BUFFER
#define _52BUFFER

#include <vector>

namespace ARRC{
template <class type> class Buffer{
public:
    Buffer(unsigned size):buf(size,0),size(size),read_ref(0),write_ref(0){}
    type read(){
        type ret = 0;
        if(read_ref < write_ref){
            ret = buf[read_ref % size];
            read_ref++;
        }
        return ret;
    }
    void write(type elem){
        buf[write_ref % size] = elem;
        write_ref++;
    }
    bool readable(){return (read_ref < write_ref);}
    int datacount(){return write_ref - read_ref;}
private:
std::vector<type> buf;
long unsigned read_ref,write_ref;
long unsigned size;
};

}

#endif
