#ifndef _TWIDLLETABLE_H
#define _TWIDLLETABLE_H

#include "OsakanaFp.h"
#include "OsakanaFpComplex.h"

//#define USE_TWIDDLE_TABLE_N2
//#define USE_TWIDDLE_TABLE_N4
//#define USE_TWIDDLE_TABLE_N8
//#define USE_TWIDDLE_TABLE_N16
//#define USE_TWIDDLE_TABLE_N32
//#define USE_TWIDDLE_TABLE_N64
//#define USE_TWIDDLE_TABLE_N128
//#define USE_TWIDDLE_TABLE_N256
//#define USE_TWIDDLE_TABLE_N512
//#define USE_TWIDDLE_TABLE_N1024

#if defined(USE_TWIDDLE_TABLE_N2)
static const osk_fp_complex_t W0002[] = {
	{ FLOAT2FP( 1.0000000000000000f),	FLOAT2FP( -0.0000000000000000f) }
};
#endif

#if defined(USE_TWIDDLE_TABLE_N4)
static const osk_fp_complex_t W0004[] = {
	{ FLOAT2FP( 1.0000000000000000f),	FLOAT2FP( -0.0000000000000000f) },
	{ FLOAT2FP( 0.0000000000000001f),	FLOAT2FP( -1.0000000000000000f) }
};
#endif

#if defined(USE_TWIDDLE_TABLE_N8)
static const osk_fp_complex_t W0008[] = {
	{ FLOAT2FP( 1.0000000000000000f),	FLOAT2FP( -0.0000000000000000f) },
	{ FLOAT2FP( 0.7071067811865476f),	FLOAT2FP( -0.7071067811865476f) },
	{ FLOAT2FP( 0.0000000000000001f),	FLOAT2FP( -1.0000000000000000f) },
	{ FLOAT2FP( -0.7071067811865475f),	FLOAT2FP( -0.7071067811865476f) }
};
#endif

#if defined(USE_TWIDDLE_TABLE_N16)
static const osk_fp_complex_t W0016[] = {
	{ FLOAT2FP( 1.0000000000000000f),	FLOAT2FP( -0.0000000000000000f) },
	{ FLOAT2FP( 0.9238795325112867f),	FLOAT2FP( -0.3826834323650898f) },
	{ FLOAT2FP( 0.7071067811865476f),	FLOAT2FP( -0.7071067811865476f) },
	{ FLOAT2FP( 0.3826834323650898f),	FLOAT2FP( -0.9238795325112867f) },
	{ FLOAT2FP( 0.0000000000000001f),	FLOAT2FP( -1.0000000000000000f) },
	{ FLOAT2FP( -0.3826834323650897f),	FLOAT2FP( -0.9238795325112867f) },
	{ FLOAT2FP( -0.7071067811865475f),	FLOAT2FP( -0.7071067811865476f) },
	{ FLOAT2FP( -0.9238795325112867f),	FLOAT2FP( -0.3826834323650899f) }
};
#endif

#if defined(USE_TWIDDLE_TABLE_N32)
static const osk_fp_complex_t W0032[] = {
	{ FLOAT2FP( 1.0000000000000000f),	FLOAT2FP( -0.0000000000000000f) },
	{ FLOAT2FP( 0.9807852804032304f),	FLOAT2FP( -0.1950903220161282f) },
	{ FLOAT2FP( 0.9238795325112867f),	FLOAT2FP( -0.3826834323650898f) },
	{ FLOAT2FP( 0.8314696123025452f),	FLOAT2FP( -0.5555702330196022f) },
	{ FLOAT2FP( 0.7071067811865476f),	FLOAT2FP( -0.7071067811865476f) },
	{ FLOAT2FP( 0.5555702330196023f),	FLOAT2FP( -0.8314696123025452f) },
	{ FLOAT2FP( 0.3826834323650898f),	FLOAT2FP( -0.9238795325112867f) },
	{ FLOAT2FP( 0.1950903220161283f),	FLOAT2FP( -0.9807852804032304f) },
	{ FLOAT2FP( 0.0000000000000001f),	FLOAT2FP( -1.0000000000000000f) },
	{ FLOAT2FP( -0.1950903220161282f),	FLOAT2FP( -0.9807852804032304f) },
	{ FLOAT2FP( -0.3826834323650897f),	FLOAT2FP( -0.9238795325112867f) },
	{ FLOAT2FP( -0.5555702330196020f),	FLOAT2FP( -0.8314696123025453f) },
	{ FLOAT2FP( -0.7071067811865475f),	FLOAT2FP( -0.7071067811865476f) },
	{ FLOAT2FP( -0.8314696123025453f),	FLOAT2FP( -0.5555702330196022f) },
	{ FLOAT2FP( -0.9238795325112867f),	FLOAT2FP( -0.3826834323650899f) },
	{ FLOAT2FP( -0.9807852804032304f),	FLOAT2FP( -0.1950903220161286f) }
};
#endif

#if defined(USE_TWIDDLE_TABLE_N64)
static const osk_fp_complex_t W0064[] = {
	{ FLOAT2FP( 1.0000000000000000f),	FLOAT2FP( -0.0000000000000000f) },
	{ FLOAT2FP( 0.9951847266721969f),	FLOAT2FP( -0.0980171403295606f) },
	{ FLOAT2FP( 0.9807852804032304f),	FLOAT2FP( -0.1950903220161282f) },
	{ FLOAT2FP( 0.9569403357322088f),	FLOAT2FP( -0.2902846772544623f) },
	{ FLOAT2FP( 0.9238795325112867f),	FLOAT2FP( -0.3826834323650898f) },
	{ FLOAT2FP( 0.8819212643483550f),	FLOAT2FP( -0.4713967368259976f) },
	{ FLOAT2FP( 0.8314696123025452f),	FLOAT2FP( -0.5555702330196022f) },
	{ FLOAT2FP( 0.7730104533627370f),	FLOAT2FP( -0.6343932841636455f) },
	{ FLOAT2FP( 0.7071067811865476f),	FLOAT2FP( -0.7071067811865476f) },
	{ FLOAT2FP( 0.6343932841636455f),	FLOAT2FP( -0.7730104533627369f) },
	{ FLOAT2FP( 0.5555702330196023f),	FLOAT2FP( -0.8314696123025452f) },
	{ FLOAT2FP( 0.4713967368259978f),	FLOAT2FP( -0.8819212643483549f) },
	{ FLOAT2FP( 0.3826834323650898f),	FLOAT2FP( -0.9238795325112867f) },
	{ FLOAT2FP( 0.2902846772544623f),	FLOAT2FP( -0.9569403357322089f) },
	{ FLOAT2FP( 0.1950903220161283f),	FLOAT2FP( -0.9807852804032304f) },
	{ FLOAT2FP( 0.0980171403295608f),	FLOAT2FP( -0.9951847266721968f) },
	{ FLOAT2FP( 0.0000000000000001f),	FLOAT2FP( -1.0000000000000000f) },
	{ FLOAT2FP( -0.0980171403295606f),	FLOAT2FP( -0.9951847266721969f) },
	{ FLOAT2FP( -0.1950903220161282f),	FLOAT2FP( -0.9807852804032304f) },
	{ FLOAT2FP( -0.2902846772544622f),	FLOAT2FP( -0.9569403357322089f) },
	{ FLOAT2FP( -0.3826834323650897f),	FLOAT2FP( -0.9238795325112867f) },
	{ FLOAT2FP( -0.4713967368259977f),	FLOAT2FP( -0.8819212643483550f) },
	{ FLOAT2FP( -0.5555702330196020f),	FLOAT2FP( -0.8314696123025453f) },
	{ FLOAT2FP( -0.6343932841636454f),	FLOAT2FP( -0.7730104533627371f) },
	{ FLOAT2FP( -0.7071067811865475f),	FLOAT2FP( -0.7071067811865476f) },
	{ FLOAT2FP( -0.7730104533627370f),	FLOAT2FP( -0.6343932841636455f) },
	{ FLOAT2FP( -0.8314696123025453f),	FLOAT2FP( -0.5555702330196022f) },
	{ FLOAT2FP( -0.8819212643483549f),	FLOAT2FP( -0.4713967368259978f) },
	{ FLOAT2FP( -0.9238795325112867f),	FLOAT2FP( -0.3826834323650899f) },
	{ FLOAT2FP( -0.9569403357322088f),	FLOAT2FP( -0.2902846772544624f) },
	{ FLOAT2FP( -0.9807852804032304f),	FLOAT2FP( -0.1950903220161286f) },
	{ FLOAT2FP( -0.9951847266721968f),	FLOAT2FP( -0.0980171403295608f) }
};
#endif

#if defined(USE_TWIDDLE_TABLE_N128)
static const osk_fp_complex_t W0128[] = {
	{ FLOAT2FP( 1.0000000000000000f),	FLOAT2FP( -0.0000000000000000f) },
	{ FLOAT2FP( 0.9987954562051724f),	FLOAT2FP( -0.0490676743274180f) },
	{ FLOAT2FP( 0.9951847266721969f),	FLOAT2FP( -0.0980171403295606f) },
	{ FLOAT2FP( 0.9891765099647810f),	FLOAT2FP( -0.1467304744553617f) },
	{ FLOAT2FP( 0.9807852804032304f),	FLOAT2FP( -0.1950903220161282f) },
	{ FLOAT2FP( 0.9700312531945440f),	FLOAT2FP( -0.2429801799032639f) },
	{ FLOAT2FP( 0.9569403357322088f),	FLOAT2FP( -0.2902846772544623f) },
	{ FLOAT2FP( 0.9415440651830208f),	FLOAT2FP( -0.3368898533922201f) },
	{ FLOAT2FP( 0.9238795325112867f),	FLOAT2FP( -0.3826834323650898f) },
	{ FLOAT2FP( 0.9039892931234433f),	FLOAT2FP( -0.4275550934302821f) },
	{ FLOAT2FP( 0.8819212643483550f),	FLOAT2FP( -0.4713967368259976f) },
	{ FLOAT2FP( 0.8577286100002721f),	FLOAT2FP( -0.5141027441932217f) },
	{ FLOAT2FP( 0.8314696123025452f),	FLOAT2FP( -0.5555702330196022f) },
	{ FLOAT2FP( 0.8032075314806449f),	FLOAT2FP( -0.5956993044924334f) },
	{ FLOAT2FP( 0.7730104533627370f),	FLOAT2FP( -0.6343932841636455f) },
	{ FLOAT2FP( 0.7409511253549592f),	FLOAT2FP( -0.6715589548470183f) },
	{ FLOAT2FP( 0.7071067811865476f),	FLOAT2FP( -0.7071067811865476f) },
	{ FLOAT2FP( 0.6715589548470183f),	FLOAT2FP( -0.7409511253549591f) },
	{ FLOAT2FP( 0.6343932841636455f),	FLOAT2FP( -0.7730104533627369f) },
	{ FLOAT2FP( 0.5956993044924335f),	FLOAT2FP( -0.8032075314806448f) },
	{ FLOAT2FP( 0.5555702330196023f),	FLOAT2FP( -0.8314696123025452f) },
	{ FLOAT2FP( 0.5141027441932217f),	FLOAT2FP( -0.8577286100002721f) },
	{ FLOAT2FP( 0.4713967368259978f),	FLOAT2FP( -0.8819212643483549f) },
	{ FLOAT2FP( 0.4275550934302822f),	FLOAT2FP( -0.9039892931234433f) },
	{ FLOAT2FP( 0.3826834323650898f),	FLOAT2FP( -0.9238795325112867f) },
	{ FLOAT2FP( 0.3368898533922201f),	FLOAT2FP( -0.9415440651830208f) },
	{ FLOAT2FP( 0.2902846772544623f),	FLOAT2FP( -0.9569403357322089f) },
	{ FLOAT2FP( 0.2429801799032640f),	FLOAT2FP( -0.9700312531945440f) },
	{ FLOAT2FP( 0.1950903220161283f),	FLOAT2FP( -0.9807852804032304f) },
	{ FLOAT2FP( 0.1467304744553617f),	FLOAT2FP( -0.9891765099647810f) },
	{ FLOAT2FP( 0.0980171403295608f),	FLOAT2FP( -0.9951847266721968f) },
	{ FLOAT2FP( 0.0490676743274181f),	FLOAT2FP( -0.9987954562051724f) },
	{ FLOAT2FP( 0.0000000000000001f),	FLOAT2FP( -1.0000000000000000f) },
	{ FLOAT2FP( -0.0490676743274180f),	FLOAT2FP( -0.9987954562051724f) },
	{ FLOAT2FP( -0.0980171403295606f),	FLOAT2FP( -0.9951847266721969f) },
	{ FLOAT2FP( -0.1467304744553616f),	FLOAT2FP( -0.9891765099647810f) },
	{ FLOAT2FP( -0.1950903220161282f),	FLOAT2FP( -0.9807852804032304f) },
	{ FLOAT2FP( -0.2429801799032639f),	FLOAT2FP( -0.9700312531945440f) },
	{ FLOAT2FP( -0.2902846772544622f),	FLOAT2FP( -0.9569403357322089f) },
	{ FLOAT2FP( -0.3368898533922199f),	FLOAT2FP( -0.9415440651830208f) },
	{ FLOAT2FP( -0.3826834323650897f),	FLOAT2FP( -0.9238795325112867f) },
	{ FLOAT2FP( -0.4275550934302819f),	FLOAT2FP( -0.9039892931234434f) },
	{ FLOAT2FP( -0.4713967368259977f),	FLOAT2FP( -0.8819212643483550f) },
	{ FLOAT2FP( -0.5141027441932216f),	FLOAT2FP( -0.8577286100002721f) },
	{ FLOAT2FP( -0.5555702330196020f),	FLOAT2FP( -0.8314696123025453f) },
	{ FLOAT2FP( -0.5956993044924334f),	FLOAT2FP( -0.8032075314806449f) },
	{ FLOAT2FP( -0.6343932841636454f),	FLOAT2FP( -0.7730104533627371f) },
	{ FLOAT2FP( -0.6715589548470184f),	FLOAT2FP( -0.7409511253549590f) },
	{ FLOAT2FP( -0.7071067811865475f),	FLOAT2FP( -0.7071067811865476f) },
	{ FLOAT2FP( -0.7409511253549589f),	FLOAT2FP( -0.6715589548470186f) },
	{ FLOAT2FP( -0.7730104533627370f),	FLOAT2FP( -0.6343932841636455f) },
	{ FLOAT2FP( -0.8032075314806448f),	FLOAT2FP( -0.5956993044924335f) },
	{ FLOAT2FP( -0.8314696123025453f),	FLOAT2FP( -0.5555702330196022f) },
	{ FLOAT2FP( -0.8577286100002720f),	FLOAT2FP( -0.5141027441932218f) },
	{ FLOAT2FP( -0.8819212643483549f),	FLOAT2FP( -0.4713967368259978f) },
	{ FLOAT2FP( -0.9039892931234433f),	FLOAT2FP( -0.4275550934302820f) },
	{ FLOAT2FP( -0.9238795325112867f),	FLOAT2FP( -0.3826834323650899f) },
	{ FLOAT2FP( -0.9415440651830207f),	FLOAT2FP( -0.3368898533922203f) },
	{ FLOAT2FP( -0.9569403357322088f),	FLOAT2FP( -0.2902846772544624f) },
	{ FLOAT2FP( -0.9700312531945440f),	FLOAT2FP( -0.2429801799032641f) },
	{ FLOAT2FP( -0.9807852804032304f),	FLOAT2FP( -0.1950903220161286f) },
	{ FLOAT2FP( -0.9891765099647810f),	FLOAT2FP( -0.1467304744553618f) },
	{ FLOAT2FP( -0.9951847266721968f),	FLOAT2FP( -0.0980171403295608f) },
	{ FLOAT2FP( -0.9987954562051724f),	FLOAT2FP( -0.0490676743274180f) }
};
#endif

#if defined(USE_TWIDDLE_TABLE_N256)
static const osk_fp_complex_t W0256[] = {
	{ FLOAT2FP( 1.0000000000000000f),	FLOAT2FP( -0.0000000000000000f) },
	{ FLOAT2FP( 0.9996988186962042f),	FLOAT2FP( -0.0245412285229123f) },
	{ FLOAT2FP( 0.9987954562051724f),	FLOAT2FP( -0.0490676743274180f) },
	{ FLOAT2FP( 0.9972904566786902f),	FLOAT2FP( -0.0735645635996674f) },
	{ FLOAT2FP( 0.9951847266721969f),	FLOAT2FP( -0.0980171403295606f) },
	{ FLOAT2FP( 0.9924795345987100f),	FLOAT2FP( -0.1224106751992162f) },
	{ FLOAT2FP( 0.9891765099647810f),	FLOAT2FP( -0.1467304744553617f) },
	{ FLOAT2FP( 0.9852776423889412f),	FLOAT2FP( -0.1709618887603012f) },
	{ FLOAT2FP( 0.9807852804032304f),	FLOAT2FP( -0.1950903220161282f) },
	{ FLOAT2FP( 0.9757021300385286f),	FLOAT2FP( -0.2191012401568698f) },
	{ FLOAT2FP( 0.9700312531945440f),	FLOAT2FP( -0.2429801799032639f) },
	{ FLOAT2FP( 0.9637760657954398f),	FLOAT2FP( -0.2667127574748984f) },
	{ FLOAT2FP( 0.9569403357322088f),	FLOAT2FP( -0.2902846772544623f) },
	{ FLOAT2FP( 0.9495281805930367f),	FLOAT2FP( -0.3136817403988915f) },
	{ FLOAT2FP( 0.9415440651830208f),	FLOAT2FP( -0.3368898533922201f) },
	{ FLOAT2FP( 0.9329927988347390f),	FLOAT2FP( -0.3598950365349881f) },
	{ FLOAT2FP( 0.9238795325112867f),	FLOAT2FP( -0.3826834323650898f) },
	{ FLOAT2FP( 0.9142097557035307f),	FLOAT2FP( -0.4052413140049899f) },
	{ FLOAT2FP( 0.9039892931234433f),	FLOAT2FP( -0.4275550934302821f) },
	{ FLOAT2FP( 0.8932243011955153f),	FLOAT2FP( -0.4496113296546065f) },
	{ FLOAT2FP( 0.8819212643483550f),	FLOAT2FP( -0.4713967368259976f) },
	{ FLOAT2FP( 0.8700869911087115f),	FLOAT2FP( -0.4928981922297840f) },
	{ FLOAT2FP( 0.8577286100002721f),	FLOAT2FP( -0.5141027441932217f) },
	{ FLOAT2FP( 0.8448535652497071f),	FLOAT2FP( -0.5349976198870972f) },
	{ FLOAT2FP( 0.8314696123025452f),	FLOAT2FP( -0.5555702330196022f) },
	{ FLOAT2FP( 0.8175848131515837f),	FLOAT2FP( -0.5758081914178453f) },
	{ FLOAT2FP( 0.8032075314806449f),	FLOAT2FP( -0.5956993044924334f) },
	{ FLOAT2FP( 0.7883464276266062f),	FLOAT2FP( -0.6152315905806268f) },
	{ FLOAT2FP( 0.7730104533627370f),	FLOAT2FP( -0.6343932841636455f) },
	{ FLOAT2FP( 0.7572088465064846f),	FLOAT2FP( -0.6531728429537768f) },
	{ FLOAT2FP( 0.7409511253549592f),	FLOAT2FP( -0.6715589548470183f) },
	{ FLOAT2FP( 0.7242470829514670f),	FLOAT2FP( -0.6895405447370668f) },
	{ FLOAT2FP( 0.7071067811865476f),	FLOAT2FP( -0.7071067811865476f) },
	{ FLOAT2FP( 0.6895405447370669f),	FLOAT2FP( -0.7242470829514669f) },
	{ FLOAT2FP( 0.6715589548470183f),	FLOAT2FP( -0.7409511253549591f) },
	{ FLOAT2FP( 0.6531728429537769f),	FLOAT2FP( -0.7572088465064846f) },
	{ FLOAT2FP( 0.6343932841636455f),	FLOAT2FP( -0.7730104533627369f) },
	{ FLOAT2FP( 0.6152315905806268f),	FLOAT2FP( -0.7883464276266062f) },
	{ FLOAT2FP( 0.5956993044924335f),	FLOAT2FP( -0.8032075314806448f) },
	{ FLOAT2FP( 0.5758081914178453f),	FLOAT2FP( -0.8175848131515837f) },
	{ FLOAT2FP( 0.5555702330196023f),	FLOAT2FP( -0.8314696123025452f) },
	{ FLOAT2FP( 0.5349976198870973f),	FLOAT2FP( -0.8448535652497070f) },
	{ FLOAT2FP( 0.5141027441932217f),	FLOAT2FP( -0.8577286100002721f) },
	{ FLOAT2FP( 0.4928981922297841f),	FLOAT2FP( -0.8700869911087113f) },
	{ FLOAT2FP( 0.4713967368259978f),	FLOAT2FP( -0.8819212643483549f) },
	{ FLOAT2FP( 0.4496113296546066f),	FLOAT2FP( -0.8932243011955153f) },
	{ FLOAT2FP( 0.4275550934302822f),	FLOAT2FP( -0.9039892931234433f) },
	{ FLOAT2FP( 0.4052413140049899f),	FLOAT2FP( -0.9142097557035307f) },
	{ FLOAT2FP( 0.3826834323650898f),	FLOAT2FP( -0.9238795325112867f) },
	{ FLOAT2FP( 0.3598950365349883f),	FLOAT2FP( -0.9329927988347388f) },
	{ FLOAT2FP( 0.3368898533922201f),	FLOAT2FP( -0.9415440651830208f) },
	{ FLOAT2FP( 0.3136817403988916f),	FLOAT2FP( -0.9495281805930367f) },
	{ FLOAT2FP( 0.2902846772544623f),	FLOAT2FP( -0.9569403357322089f) },
	{ FLOAT2FP( 0.2667127574748984f),	FLOAT2FP( -0.9637760657954398f) },
	{ FLOAT2FP( 0.2429801799032640f),	FLOAT2FP( -0.9700312531945440f) },
	{ FLOAT2FP( 0.2191012401568698f),	FLOAT2FP( -0.9757021300385286f) },
	{ FLOAT2FP( 0.1950903220161283f),	FLOAT2FP( -0.9807852804032304f) },
	{ FLOAT2FP( 0.1709618887603014f),	FLOAT2FP( -0.9852776423889412f) },
	{ FLOAT2FP( 0.1467304744553617f),	FLOAT2FP( -0.9891765099647810f) },
	{ FLOAT2FP( 0.1224106751992163f),	FLOAT2FP( -0.9924795345987100f) },
	{ FLOAT2FP( 0.0980171403295608f),	FLOAT2FP( -0.9951847266721968f) },
	{ FLOAT2FP( 0.0735645635996675f),	FLOAT2FP( -0.9972904566786902f) },
	{ FLOAT2FP( 0.0490676743274181f),	FLOAT2FP( -0.9987954562051724f) },
	{ FLOAT2FP( 0.0245412285229123f),	FLOAT2FP( -0.9996988186962042f) },
	{ FLOAT2FP( 0.0000000000000001f),	FLOAT2FP( -1.0000000000000000f) },
	{ FLOAT2FP( -0.0245412285229121f),	FLOAT2FP( -0.9996988186962042f) },
	{ FLOAT2FP( -0.0490676743274180f),	FLOAT2FP( -0.9987954562051724f) },
	{ FLOAT2FP( -0.0735645635996673f),	FLOAT2FP( -0.9972904566786902f) },
	{ FLOAT2FP( -0.0980171403295606f),	FLOAT2FP( -0.9951847266721969f) },
	{ FLOAT2FP( -0.1224106751992162f),	FLOAT2FP( -0.9924795345987100f) },
	{ FLOAT2FP( -0.1467304744553616f),	FLOAT2FP( -0.9891765099647810f) },
	{ FLOAT2FP( -0.1709618887603012f),	FLOAT2FP( -0.9852776423889412f) },
	{ FLOAT2FP( -0.1950903220161282f),	FLOAT2FP( -0.9807852804032304f) },
	{ FLOAT2FP( -0.2191012401568697f),	FLOAT2FP( -0.9757021300385286f) },
	{ FLOAT2FP( -0.2429801799032639f),	FLOAT2FP( -0.9700312531945440f) },
	{ FLOAT2FP( -0.2667127574748983f),	FLOAT2FP( -0.9637760657954398f) },
	{ FLOAT2FP( -0.2902846772544622f),	FLOAT2FP( -0.9569403357322089f) },
	{ FLOAT2FP( -0.3136817403988914f),	FLOAT2FP( -0.9495281805930367f) },
	{ FLOAT2FP( -0.3368898533922199f),	FLOAT2FP( -0.9415440651830208f) },
	{ FLOAT2FP( -0.3598950365349882f),	FLOAT2FP( -0.9329927988347388f) },
	{ FLOAT2FP( -0.3826834323650897f),	FLOAT2FP( -0.9238795325112867f) },
	{ FLOAT2FP( -0.4052413140049897f),	FLOAT2FP( -0.9142097557035307f) },
	{ FLOAT2FP( -0.4275550934302819f),	FLOAT2FP( -0.9039892931234434f) },
	{ FLOAT2FP( -0.4496113296546067f),	FLOAT2FP( -0.8932243011955152f) },
	{ FLOAT2FP( -0.4713967368259977f),	FLOAT2FP( -0.8819212643483550f) },
	{ FLOAT2FP( -0.4928981922297840f),	FLOAT2FP( -0.8700869911087115f) },
	{ FLOAT2FP( -0.5141027441932216f),	FLOAT2FP( -0.8577286100002721f) },
	{ FLOAT2FP( -0.5349976198870970f),	FLOAT2FP( -0.8448535652497072f) },
	{ FLOAT2FP( -0.5555702330196020f),	FLOAT2FP( -0.8314696123025453f) },
	{ FLOAT2FP( -0.5758081914178453f),	FLOAT2FP( -0.8175848131515837f) },
	{ FLOAT2FP( -0.5956993044924334f),	FLOAT2FP( -0.8032075314806449f) },
	{ FLOAT2FP( -0.6152315905806267f),	FLOAT2FP( -0.7883464276266063f) },
	{ FLOAT2FP( -0.6343932841636454f),	FLOAT2FP( -0.7730104533627371f) },
	{ FLOAT2FP( -0.6531728429537765f),	FLOAT2FP( -0.7572088465064847f) },
	{ FLOAT2FP( -0.6715589548470184f),	FLOAT2FP( -0.7409511253549590f) },
	{ FLOAT2FP( -0.6895405447370669f),	FLOAT2FP( -0.7242470829514669f) },
	{ FLOAT2FP( -0.7071067811865475f),	FLOAT2FP( -0.7071067811865476f) },
	{ FLOAT2FP( -0.7242470829514668f),	FLOAT2FP( -0.6895405447370671f) },
	{ FLOAT2FP( -0.7409511253549589f),	FLOAT2FP( -0.6715589548470186f) },
	{ FLOAT2FP( -0.7572088465064847f),	FLOAT2FP( -0.6531728429537766f) },
	{ FLOAT2FP( -0.7730104533627370f),	FLOAT2FP( -0.6343932841636455f) },
	{ FLOAT2FP( -0.7883464276266062f),	FLOAT2FP( -0.6152315905806269f) },
	{ FLOAT2FP( -0.8032075314806448f),	FLOAT2FP( -0.5956993044924335f) },
	{ FLOAT2FP( -0.8175848131515836f),	FLOAT2FP( -0.5758081914178454f) },
	{ FLOAT2FP( -0.8314696123025453f),	FLOAT2FP( -0.5555702330196022f) },
	{ FLOAT2FP( -0.8448535652497071f),	FLOAT2FP( -0.5349976198870972f) },
	{ FLOAT2FP( -0.8577286100002720f),	FLOAT2FP( -0.5141027441932218f) },
	{ FLOAT2FP( -0.8700869911087113f),	FLOAT2FP( -0.4928981922297841f) },
	{ FLOAT2FP( -0.8819212643483549f),	FLOAT2FP( -0.4713967368259978f) },
	{ FLOAT2FP( -0.8932243011955152f),	FLOAT2FP( -0.4496113296546069f) },
	{ FLOAT2FP( -0.9039892931234433f),	FLOAT2FP( -0.4275550934302820f) },
	{ FLOAT2FP( -0.9142097557035307f),	FLOAT2FP( -0.4052413140049899f) },
	{ FLOAT2FP( -0.9238795325112867f),	FLOAT2FP( -0.3826834323650899f) },
	{ FLOAT2FP( -0.9329927988347388f),	FLOAT2FP( -0.3598950365349883f) },
	{ FLOAT2FP( -0.9415440651830207f),	FLOAT2FP( -0.3368898533922203f) },
	{ FLOAT2FP( -0.9495281805930367f),	FLOAT2FP( -0.3136817403988914f) },
	{ FLOAT2FP( -0.9569403357322088f),	FLOAT2FP( -0.2902846772544624f) },
	{ FLOAT2FP( -0.9637760657954398f),	FLOAT2FP( -0.2667127574748985f) },
	{ FLOAT2FP( -0.9700312531945440f),	FLOAT2FP( -0.2429801799032641f) },
	{ FLOAT2FP( -0.9757021300385285f),	FLOAT2FP( -0.2191012401568700f) },
	{ FLOAT2FP( -0.9807852804032304f),	FLOAT2FP( -0.1950903220161286f) },
	{ FLOAT2FP( -0.9852776423889412f),	FLOAT2FP( -0.1709618887603012f) },
	{ FLOAT2FP( -0.9891765099647810f),	FLOAT2FP( -0.1467304744553618f) },
	{ FLOAT2FP( -0.9924795345987100f),	FLOAT2FP( -0.1224106751992163f) },
	{ FLOAT2FP( -0.9951847266721968f),	FLOAT2FP( -0.0980171403295608f) },
	{ FLOAT2FP( -0.9972904566786902f),	FLOAT2FP( -0.0735645635996677f) },
	{ FLOAT2FP( -0.9987954562051724f),	FLOAT2FP( -0.0490676743274180f) },
	{ FLOAT2FP( -0.9996988186962042f),	FLOAT2FP( -0.0245412285229123f) }
};
#endif

#if defined(USE_TWIDDLE_TABLE_N512)
static const osk_fp_complex_t W0512[] = {
	{ FLOAT2FP( 1.0000000000000000f),	FLOAT2FP( -0.0000000000000000f) },
	{ FLOAT2FP( 0.9999247018391445f),	FLOAT2FP( -0.0122715382857199f) },
	{ FLOAT2FP( 0.9996988186962042f),	FLOAT2FP( -0.0245412285229123f) },
	{ FLOAT2FP( 0.9993223845883495f),	FLOAT2FP( -0.0368072229413588f) },
	{ FLOAT2FP( 0.9987954562051724f),	FLOAT2FP( -0.0490676743274180f) },
	{ FLOAT2FP( 0.9981181129001492f),	FLOAT2FP( -0.0613207363022086f) },
	{ FLOAT2FP( 0.9972904566786902f),	FLOAT2FP( -0.0735645635996674f) },
	{ FLOAT2FP( 0.9963126121827780f),	FLOAT2FP( -0.0857973123444399f) },
	{ FLOAT2FP( 0.9951847266721969f),	FLOAT2FP( -0.0980171403295606f) },
	{ FLOAT2FP( 0.9939069700023561f),	FLOAT2FP( -0.1102222072938831f) },
	{ FLOAT2FP( 0.9924795345987100f),	FLOAT2FP( -0.1224106751992162f) },
	{ FLOAT2FP( 0.9909026354277800f),	FLOAT2FP( -0.1345807085071262f) },
	{ FLOAT2FP( 0.9891765099647810f),	FLOAT2FP( -0.1467304744553617f) },
	{ FLOAT2FP( 0.9873014181578584f),	FLOAT2FP( -0.1588581433338614f) },
	{ FLOAT2FP( 0.9852776423889412f),	FLOAT2FP( -0.1709618887603012f) },
	{ FLOAT2FP( 0.9831054874312163f),	FLOAT2FP( -0.1830398879551410f) },
	{ FLOAT2FP( 0.9807852804032304f),	FLOAT2FP( -0.1950903220161282f) },
	{ FLOAT2FP( 0.9783173707196277f),	FLOAT2FP( -0.2071113761922186f) },
	{ FLOAT2FP( 0.9757021300385286f),	FLOAT2FP( -0.2191012401568698f) },
	{ FLOAT2FP( 0.9729399522055602f),	FLOAT2FP( -0.2310581082806711f) },
	{ FLOAT2FP( 0.9700312531945440f),	FLOAT2FP( -0.2429801799032639f) },
	{ FLOAT2FP( 0.9669764710448521f),	FLOAT2FP( -0.2548656596045146f) },
	{ FLOAT2FP( 0.9637760657954398f),	FLOAT2FP( -0.2667127574748984f) },
	{ FLOAT2FP( 0.9604305194155658f),	FLOAT2FP( -0.2785196893850531f) },
	{ FLOAT2FP( 0.9569403357322088f),	FLOAT2FP( -0.2902846772544623f) },
	{ FLOAT2FP( 0.9533060403541939f),	FLOAT2FP( -0.3020059493192281f) },
	{ FLOAT2FP( 0.9495281805930367f),	FLOAT2FP( -0.3136817403988915f) },
	{ FLOAT2FP( 0.9456073253805213f),	FLOAT2FP( -0.3253102921622629f) },
	{ FLOAT2FP( 0.9415440651830208f),	FLOAT2FP( -0.3368898533922201f) },
	{ FLOAT2FP( 0.9373390119125750f),	FLOAT2FP( -0.3484186802494346f) },
	{ FLOAT2FP( 0.9329927988347390f),	FLOAT2FP( -0.3598950365349881f) },
	{ FLOAT2FP( 0.9285060804732156f),	FLOAT2FP( -0.3713171939518375f) },
	{ FLOAT2FP( 0.9238795325112867f),	FLOAT2FP( -0.3826834323650898f) },
	{ FLOAT2FP( 0.9191138516900578f),	FLOAT2FP( -0.3939920400610481f) },
	{ FLOAT2FP( 0.9142097557035307f),	FLOAT2FP( -0.4052413140049899f) },
	{ FLOAT2FP( 0.9091679830905224f),	FLOAT2FP( -0.4164295600976372f) },
	{ FLOAT2FP( 0.9039892931234433f),	FLOAT2FP( -0.4275550934302821f) },
	{ FLOAT2FP( 0.8986744656939538f),	FLOAT2FP( -0.4386162385385277f) },
	{ FLOAT2FP( 0.8932243011955153f),	FLOAT2FP( -0.4496113296546065f) },
	{ FLOAT2FP( 0.8876396204028539f),	FLOAT2FP( -0.4605387109582400f) },
	{ FLOAT2FP( 0.8819212643483550f),	FLOAT2FP( -0.4713967368259976f) },
	{ FLOAT2FP( 0.8760700941954066f),	FLOAT2FP( -0.4821837720791227f) },
	{ FLOAT2FP( 0.8700869911087115f),	FLOAT2FP( -0.4928981922297840f) },
	{ FLOAT2FP( 0.8639728561215867f),	FLOAT2FP( -0.5035383837257176f) },
	{ FLOAT2FP( 0.8577286100002721f),	FLOAT2FP( -0.5141027441932217f) },
	{ FLOAT2FP( 0.8513551931052652f),	FLOAT2FP( -0.5245896826784689f) },
	{ FLOAT2FP( 0.8448535652497071f),	FLOAT2FP( -0.5349976198870972f) },
	{ FLOAT2FP( 0.8382247055548381f),	FLOAT2FP( -0.5453249884220465f) },
	{ FLOAT2FP( 0.8314696123025452f),	FLOAT2FP( -0.5555702330196022f) },
	{ FLOAT2FP( 0.8245893027850253f),	FLOAT2FP( -0.5657318107836131f) },
	{ FLOAT2FP( 0.8175848131515837f),	FLOAT2FP( -0.5758081914178453f) },
	{ FLOAT2FP( 0.8104571982525948f),	FLOAT2FP( -0.5857978574564389f) },
	{ FLOAT2FP( 0.8032075314806449f),	FLOAT2FP( -0.5956993044924334f) },
	{ FLOAT2FP( 0.7958369046088836f),	FLOAT2FP( -0.6055110414043255f) },
	{ FLOAT2FP( 0.7883464276266062f),	FLOAT2FP( -0.6152315905806268f) },
	{ FLOAT2FP( 0.7807372285720945f),	FLOAT2FP( -0.6248594881423863f) },
	{ FLOAT2FP( 0.7730104533627370f),	FLOAT2FP( -0.6343932841636455f) },
	{ FLOAT2FP( 0.7651672656224590f),	FLOAT2FP( -0.6438315428897914f) },
	{ FLOAT2FP( 0.7572088465064846f),	FLOAT2FP( -0.6531728429537768f) },
	{ FLOAT2FP( 0.7491363945234594f),	FLOAT2FP( -0.6624157775901718f) },
	{ FLOAT2FP( 0.7409511253549592f),	FLOAT2FP( -0.6715589548470183f) },
	{ FLOAT2FP( 0.7326542716724128f),	FLOAT2FP( -0.6806009977954530f) },
	{ FLOAT2FP( 0.7242470829514670f),	FLOAT2FP( -0.6895405447370668f) },
	{ FLOAT2FP( 0.7157308252838187f),	FLOAT2FP( -0.6983762494089728f) },
	{ FLOAT2FP( 0.7071067811865476f),	FLOAT2FP( -0.7071067811865476f) },
	{ FLOAT2FP( 0.6983762494089729f),	FLOAT2FP( -0.7157308252838186f) },
	{ FLOAT2FP( 0.6895405447370669f),	FLOAT2FP( -0.7242470829514669f) },
	{ FLOAT2FP( 0.6806009977954530f),	FLOAT2FP( -0.7326542716724128f) },
	{ FLOAT2FP( 0.6715589548470183f),	FLOAT2FP( -0.7409511253549591f) },
	{ FLOAT2FP( 0.6624157775901718f),	FLOAT2FP( -0.7491363945234593f) },
	{ FLOAT2FP( 0.6531728429537769f),	FLOAT2FP( -0.7572088465064846f) },
	{ FLOAT2FP( 0.6438315428897915f),	FLOAT2FP( -0.7651672656224590f) },
	{ FLOAT2FP( 0.6343932841636455f),	FLOAT2FP( -0.7730104533627369f) },
	{ FLOAT2FP( 0.6248594881423865f),	FLOAT2FP( -0.7807372285720945f) },
	{ FLOAT2FP( 0.6152315905806268f),	FLOAT2FP( -0.7883464276266062f) },
	{ FLOAT2FP( 0.6055110414043255f),	FLOAT2FP( -0.7958369046088835f) },
	{ FLOAT2FP( 0.5956993044924335f),	FLOAT2FP( -0.8032075314806448f) },
	{ FLOAT2FP( 0.5857978574564389f),	FLOAT2FP( -0.8104571982525948f) },
	{ FLOAT2FP( 0.5758081914178453f),	FLOAT2FP( -0.8175848131515837f) },
	{ FLOAT2FP( 0.5657318107836132f),	FLOAT2FP( -0.8245893027850253f) },
	{ FLOAT2FP( 0.5555702330196023f),	FLOAT2FP( -0.8314696123025452f) },
	{ FLOAT2FP( 0.5453249884220465f),	FLOAT2FP( -0.8382247055548380f) },
	{ FLOAT2FP( 0.5349976198870973f),	FLOAT2FP( -0.8448535652497070f) },
	{ FLOAT2FP( 0.5245896826784688f),	FLOAT2FP( -0.8513551931052652f) },
	{ FLOAT2FP( 0.5141027441932217f),	FLOAT2FP( -0.8577286100002721f) },
	{ FLOAT2FP( 0.5035383837257176f),	FLOAT2FP( -0.8639728561215867f) },
	{ FLOAT2FP( 0.4928981922297841f),	FLOAT2FP( -0.8700869911087113f) },
	{ FLOAT2FP( 0.4821837720791228f),	FLOAT2FP( -0.8760700941954066f) },
	{ FLOAT2FP( 0.4713967368259978f),	FLOAT2FP( -0.8819212643483549f) },
	{ FLOAT2FP( 0.4605387109582400f),	FLOAT2FP( -0.8876396204028539f) },
	{ FLOAT2FP( 0.4496113296546066f),	FLOAT2FP( -0.8932243011955153f) },
	{ FLOAT2FP( 0.4386162385385277f),	FLOAT2FP( -0.8986744656939538f) },
	{ FLOAT2FP( 0.4275550934302822f),	FLOAT2FP( -0.9039892931234433f) },
	{ FLOAT2FP( 0.4164295600976373f),	FLOAT2FP( -0.9091679830905223f) },
	{ FLOAT2FP( 0.4052413140049899f),	FLOAT2FP( -0.9142097557035307f) },
	{ FLOAT2FP( 0.3939920400610481f),	FLOAT2FP( -0.9191138516900578f) },
	{ FLOAT2FP( 0.3826834323650898f),	FLOAT2FP( -0.9238795325112867f) },
	{ FLOAT2FP( 0.3713171939518376f),	FLOAT2FP( -0.9285060804732156f) },
	{ FLOAT2FP( 0.3598950365349883f),	FLOAT2FP( -0.9329927988347388f) },
	{ FLOAT2FP( 0.3484186802494345f),	FLOAT2FP( -0.9373390119125750f) },
	{ FLOAT2FP( 0.3368898533922201f),	FLOAT2FP( -0.9415440651830208f) },
	{ FLOAT2FP( 0.3253102921622630f),	FLOAT2FP( -0.9456073253805213f) },
	{ FLOAT2FP( 0.3136817403988916f),	FLOAT2FP( -0.9495281805930367f) },
	{ FLOAT2FP( 0.3020059493192282f),	FLOAT2FP( -0.9533060403541938f) },
	{ FLOAT2FP( 0.2902846772544623f),	FLOAT2FP( -0.9569403357322089f) },
	{ FLOAT2FP( 0.2785196893850531f),	FLOAT2FP( -0.9604305194155658f) },
	{ FLOAT2FP( 0.2667127574748984f),	FLOAT2FP( -0.9637760657954398f) },
	{ FLOAT2FP( 0.2548656596045146f),	FLOAT2FP( -0.9669764710448521f) },
	{ FLOAT2FP( 0.2429801799032640f),	FLOAT2FP( -0.9700312531945440f) },
	{ FLOAT2FP( 0.2310581082806713f),	FLOAT2FP( -0.9729399522055601f) },
	{ FLOAT2FP( 0.2191012401568698f),	FLOAT2FP( -0.9757021300385286f) },
	{ FLOAT2FP( 0.2071113761922186f),	FLOAT2FP( -0.9783173707196277f) },
	{ FLOAT2FP( 0.1950903220161283f),	FLOAT2FP( -0.9807852804032304f) },
	{ FLOAT2FP( 0.1830398879551411f),	FLOAT2FP( -0.9831054874312163f) },
	{ FLOAT2FP( 0.1709618887603014f),	FLOAT2FP( -0.9852776423889412f) },
	{ FLOAT2FP( 0.1588581433338614f),	FLOAT2FP( -0.9873014181578584f) },
	{ FLOAT2FP( 0.1467304744553617f),	FLOAT2FP( -0.9891765099647810f) },
	{ FLOAT2FP( 0.1345807085071262f),	FLOAT2FP( -0.9909026354277800f) },
	{ FLOAT2FP( 0.1224106751992163f),	FLOAT2FP( -0.9924795345987100f) },
	{ FLOAT2FP( 0.1102222072938832f),	FLOAT2FP( -0.9939069700023561f) },
	{ FLOAT2FP( 0.0980171403295608f),	FLOAT2FP( -0.9951847266721968f) },
	{ FLOAT2FP( 0.0857973123444399f),	FLOAT2FP( -0.9963126121827780f) },
	{ FLOAT2FP( 0.0735645635996675f),	FLOAT2FP( -0.9972904566786902f) },
	{ FLOAT2FP( 0.0613207363022086f),	FLOAT2FP( -0.9981181129001492f) },
	{ FLOAT2FP( 0.0490676743274181f),	FLOAT2FP( -0.9987954562051724f) },
	{ FLOAT2FP( 0.0368072229413590f),	FLOAT2FP( -0.9993223845883495f) },
	{ FLOAT2FP( 0.0245412285229123f),	FLOAT2FP( -0.9996988186962042f) },
	{ FLOAT2FP( 0.0122715382857199f),	FLOAT2FP( -0.9999247018391445f) },
	{ FLOAT2FP( 0.0000000000000001f),	FLOAT2FP( -1.0000000000000000f) },
	{ FLOAT2FP( -0.0122715382857198f),	FLOAT2FP( -0.9999247018391445f) },
	{ FLOAT2FP( -0.0245412285229121f),	FLOAT2FP( -0.9996988186962042f) },
	{ FLOAT2FP( -0.0368072229413589f),	FLOAT2FP( -0.9993223845883495f) },
	{ FLOAT2FP( -0.0490676743274180f),	FLOAT2FP( -0.9987954562051724f) },
	{ FLOAT2FP( -0.0613207363022085f),	FLOAT2FP( -0.9981181129001492f) },
	{ FLOAT2FP( -0.0735645635996673f),	FLOAT2FP( -0.9972904566786902f) },
	{ FLOAT2FP( -0.0857973123444398f),	FLOAT2FP( -0.9963126121827780f) },
	{ FLOAT2FP( -0.0980171403295606f),	FLOAT2FP( -0.9951847266721969f) },
	{ FLOAT2FP( -0.1102222072938831f),	FLOAT2FP( -0.9939069700023561f) },
	{ FLOAT2FP( -0.1224106751992162f),	FLOAT2FP( -0.9924795345987100f) },
	{ FLOAT2FP( -0.1345807085071261f),	FLOAT2FP( -0.9909026354277800f) },
	{ FLOAT2FP( -0.1467304744553616f),	FLOAT2FP( -0.9891765099647810f) },
	{ FLOAT2FP( -0.1588581433338613f),	FLOAT2FP( -0.9873014181578584f) },
	{ FLOAT2FP( -0.1709618887603012f),	FLOAT2FP( -0.9852776423889412f) },
	{ FLOAT2FP( -0.1830398879551409f),	FLOAT2FP( -0.9831054874312163f) },
	{ FLOAT2FP( -0.1950903220161282f),	FLOAT2FP( -0.9807852804032304f) },
	{ FLOAT2FP( -0.2071113761922184f),	FLOAT2FP( -0.9783173707196277f) },
	{ FLOAT2FP( -0.2191012401568697f),	FLOAT2FP( -0.9757021300385286f) },
	{ FLOAT2FP( -0.2310581082806711f),	FLOAT2FP( -0.9729399522055602f) },
	{ FLOAT2FP( -0.2429801799032639f),	FLOAT2FP( -0.9700312531945440f) },
	{ FLOAT2FP( -0.2548656596045145f),	FLOAT2FP( -0.9669764710448521f) },
	{ FLOAT2FP( -0.2667127574748983f),	FLOAT2FP( -0.9637760657954398f) },
	{ FLOAT2FP( -0.2785196893850529f),	FLOAT2FP( -0.9604305194155659f) },
	{ FLOAT2FP( -0.2902846772544622f),	FLOAT2FP( -0.9569403357322089f) },
	{ FLOAT2FP( -0.3020059493192281f),	FLOAT2FP( -0.9533060403541939f) },
	{ FLOAT2FP( -0.3136817403988914f),	FLOAT2FP( -0.9495281805930367f) },
	{ FLOAT2FP( -0.3253102921622629f),	FLOAT2FP( -0.9456073253805214f) },
	{ FLOAT2FP( -0.3368898533922199f),	FLOAT2FP( -0.9415440651830208f) },
	{ FLOAT2FP( -0.3484186802494344f),	FLOAT2FP( -0.9373390119125750f) },
	{ FLOAT2FP( -0.3598950365349882f),	FLOAT2FP( -0.9329927988347388f) },
	{ FLOAT2FP( -0.3713171939518375f),	FLOAT2FP( -0.9285060804732156f) },
	{ FLOAT2FP( -0.3826834323650897f),	FLOAT2FP( -0.9238795325112867f) },
	{ FLOAT2FP( -0.3939920400610480f),	FLOAT2FP( -0.9191138516900578f) },
	{ FLOAT2FP( -0.4052413140049897f),	FLOAT2FP( -0.9142097557035307f) },
	{ FLOAT2FP( -0.4164295600976370f),	FLOAT2FP( -0.9091679830905225f) },
	{ FLOAT2FP( -0.4275550934302819f),	FLOAT2FP( -0.9039892931234434f) },
	{ FLOAT2FP( -0.4386162385385274f),	FLOAT2FP( -0.8986744656939539f) },
	{ FLOAT2FP( -0.4496113296546067f),	FLOAT2FP( -0.8932243011955152f) },
	{ FLOAT2FP( -0.4605387109582401f),	FLOAT2FP( -0.8876396204028539f) },
	{ FLOAT2FP( -0.4713967368259977f),	FLOAT2FP( -0.8819212643483550f) },
	{ FLOAT2FP( -0.4821837720791227f),	FLOAT2FP( -0.8760700941954066f) },
	{ FLOAT2FP( -0.4928981922297840f),	FLOAT2FP( -0.8700869911087115f) },
	{ FLOAT2FP( -0.5035383837257175f),	FLOAT2FP( -0.8639728561215868f) },
	{ FLOAT2FP( -0.5141027441932216f),	FLOAT2FP( -0.8577286100002721f) },
	{ FLOAT2FP( -0.5245896826784687f),	FLOAT2FP( -0.8513551931052652f) },
	{ FLOAT2FP( -0.5349976198870970f),	FLOAT2FP( -0.8448535652497072f) },
	{ FLOAT2FP( -0.5453249884220462f),	FLOAT2FP( -0.8382247055548382f) },
	{ FLOAT2FP( -0.5555702330196020f),	FLOAT2FP( -0.8314696123025453f) },
	{ FLOAT2FP( -0.5657318107836132f),	FLOAT2FP( -0.8245893027850252f) },
	{ FLOAT2FP( -0.5758081914178453f),	FLOAT2FP( -0.8175848131515837f) },
	{ FLOAT2FP( -0.5857978574564389f),	FLOAT2FP( -0.8104571982525948f) },
	{ FLOAT2FP( -0.5956993044924334f),	FLOAT2FP( -0.8032075314806449f) },
	{ FLOAT2FP( -0.6055110414043254f),	FLOAT2FP( -0.7958369046088836f) },
	{ FLOAT2FP( -0.6152315905806267f),	FLOAT2FP( -0.7883464276266063f) },
	{ FLOAT2FP( -0.6248594881423862f),	FLOAT2FP( -0.7807372285720946f) },
	{ FLOAT2FP( -0.6343932841636454f),	FLOAT2FP( -0.7730104533627371f) },
	{ FLOAT2FP( -0.6438315428897913f),	FLOAT2FP( -0.7651672656224591f) },
	{ FLOAT2FP( -0.6531728429537765f),	FLOAT2FP( -0.7572088465064847f) },
	{ FLOAT2FP( -0.6624157775901719f),	FLOAT2FP( -0.7491363945234593f) },
	{ FLOAT2FP( -0.6715589548470184f),	FLOAT2FP( -0.7409511253549590f) },
	{ FLOAT2FP( -0.6806009977954530f),	FLOAT2FP( -0.7326542716724128f) },
	{ FLOAT2FP( -0.6895405447370669f),	FLOAT2FP( -0.7242470829514669f) },
	{ FLOAT2FP( -0.6983762494089728f),	FLOAT2FP( -0.7157308252838187f) },
	{ FLOAT2FP( -0.7071067811865475f),	FLOAT2FP( -0.7071067811865476f) },
	{ FLOAT2FP( -0.7157308252838186f),	FLOAT2FP( -0.6983762494089729f) },
	{ FLOAT2FP( -0.7242470829514668f),	FLOAT2FP( -0.6895405447370671f) },
	{ FLOAT2FP( -0.7326542716724127f),	FLOAT2FP( -0.6806009977954532f) },
	{ FLOAT2FP( -0.7409511253549589f),	FLOAT2FP( -0.6715589548470186f) },
	{ FLOAT2FP( -0.7491363945234591f),	FLOAT2FP( -0.6624157775901720f) },
	{ FLOAT2FP( -0.7572088465064847f),	FLOAT2FP( -0.6531728429537766f) },
	{ FLOAT2FP( -0.7651672656224590f),	FLOAT2FP( -0.6438315428897914f) },
	{ FLOAT2FP( -0.7730104533627370f),	FLOAT2FP( -0.6343932841636455f) },
	{ FLOAT2FP( -0.7807372285720945f),	FLOAT2FP( -0.6248594881423863f) },
	{ FLOAT2FP( -0.7883464276266062f),	FLOAT2FP( -0.6152315905806269f) },
	{ FLOAT2FP( -0.7958369046088835f),	FLOAT2FP( -0.6055110414043257f) },
	{ FLOAT2FP( -0.8032075314806448f),	FLOAT2FP( -0.5956993044924335f) },
	{ FLOAT2FP( -0.8104571982525947f),	FLOAT2FP( -0.5857978574564390f) },
	{ FLOAT2FP( -0.8175848131515836f),	FLOAT2FP( -0.5758081914178454f) },
	{ FLOAT2FP( -0.8245893027850251f),	FLOAT2FP( -0.5657318107836135f) },
	{ FLOAT2FP( -0.8314696123025453f),	FLOAT2FP( -0.5555702330196022f) },
	{ FLOAT2FP( -0.8382247055548381f),	FLOAT2FP( -0.5453249884220464f) },
	{ FLOAT2FP( -0.8448535652497071f),	FLOAT2FP( -0.5349976198870972f) },
	{ FLOAT2FP( -0.8513551931052652f),	FLOAT2FP( -0.5245896826784689f) },
	{ FLOAT2FP( -0.8577286100002720f),	FLOAT2FP( -0.5141027441932218f) },
	{ FLOAT2FP( -0.8639728561215867f),	FLOAT2FP( -0.5035383837257176f) },
	{ FLOAT2FP( -0.8700869911087113f),	FLOAT2FP( -0.4928981922297841f) },
	{ FLOAT2FP( -0.8760700941954065f),	FLOAT2FP( -0.4821837720791229f) },
	{ FLOAT2FP( -0.8819212643483549f),	FLOAT2FP( -0.4713967368259978f) },
	{ FLOAT2FP( -0.8876396204028538f),	FLOAT2FP( -0.4605387109582402f) },
	{ FLOAT2FP( -0.8932243011955152f),	FLOAT2FP( -0.4496113296546069f) },
	{ FLOAT2FP( -0.8986744656939539f),	FLOAT2FP( -0.4386162385385275f) },
	{ FLOAT2FP( -0.9039892931234433f),	FLOAT2FP( -0.4275550934302820f) },
	{ FLOAT2FP( -0.9091679830905224f),	FLOAT2FP( -0.4164295600976372f) },
	{ FLOAT2FP( -0.9142097557035307f),	FLOAT2FP( -0.4052413140049899f) },
	{ FLOAT2FP( -0.9191138516900578f),	FLOAT2FP( -0.3939920400610482f) },
	{ FLOAT2FP( -0.9238795325112867f),	FLOAT2FP( -0.3826834323650899f) },
	{ FLOAT2FP( -0.9285060804732155f),	FLOAT2FP( -0.3713171939518377f) },
	{ FLOAT2FP( -0.9329927988347388f),	FLOAT2FP( -0.3598950365349883f) },
	{ FLOAT2FP( -0.9373390119125748f),	FLOAT2FP( -0.3484186802494348f) },
	{ FLOAT2FP( -0.9415440651830207f),	FLOAT2FP( -0.3368898533922203f) },
	{ FLOAT2FP( -0.9456073253805212f),	FLOAT2FP( -0.3253102921622633f) },
	{ FLOAT2FP( -0.9495281805930367f),	FLOAT2FP( -0.3136817403988914f) },
	{ FLOAT2FP( -0.9533060403541939f),	FLOAT2FP( -0.3020059493192280f) },
	{ FLOAT2FP( -0.9569403357322088f),	FLOAT2FP( -0.2902846772544624f) },
	{ FLOAT2FP( -0.9604305194155658f),	FLOAT2FP( -0.2785196893850532f) },
	{ FLOAT2FP( -0.9637760657954398f),	FLOAT2FP( -0.2667127574748985f) },
	{ FLOAT2FP( -0.9669764710448521f),	FLOAT2FP( -0.2548656596045147f) },
	{ FLOAT2FP( -0.9700312531945440f),	FLOAT2FP( -0.2429801799032641f) },
	{ FLOAT2FP( -0.9729399522055601f),	FLOAT2FP( -0.2310581082806713f) },
	{ FLOAT2FP( -0.9757021300385285f),	FLOAT2FP( -0.2191012401568700f) },
	{ FLOAT2FP( -0.9783173707196275f),	FLOAT2FP( -0.2071113761922188f) },
	{ FLOAT2FP( -0.9807852804032304f),	FLOAT2FP( -0.1950903220161286f) },
	{ FLOAT2FP( -0.9831054874312163f),	FLOAT2FP( -0.1830398879551409f) },
	{ FLOAT2FP( -0.9852776423889412f),	FLOAT2FP( -0.1709618887603012f) },
	{ FLOAT2FP( -0.9873014181578584f),	FLOAT2FP( -0.1588581433338615f) },
	{ FLOAT2FP( -0.9891765099647810f),	FLOAT2FP( -0.1467304744553618f) },
	{ FLOAT2FP( -0.9909026354277800f),	FLOAT2FP( -0.1345807085071263f) },
	{ FLOAT2FP( -0.9924795345987100f),	FLOAT2FP( -0.1224106751992163f) },
	{ FLOAT2FP( -0.9939069700023561f),	FLOAT2FP( -0.1102222072938832f) },
	{ FLOAT2FP( -0.9951847266721968f),	FLOAT2FP( -0.0980171403295608f) },
	{ FLOAT2FP( -0.9963126121827780f),	FLOAT2FP( -0.0857973123444402f) },
	{ FLOAT2FP( -0.9972904566786902f),	FLOAT2FP( -0.0735645635996677f) },
	{ FLOAT2FP( -0.9981181129001492f),	FLOAT2FP( -0.0613207363022085f) },
	{ FLOAT2FP( -0.9987954562051724f),	FLOAT2FP( -0.0490676743274180f) },
	{ FLOAT2FP( -0.9993223845883495f),	FLOAT2FP( -0.0368072229413588f) },
	{ FLOAT2FP( -0.9996988186962042f),	FLOAT2FP( -0.0245412285229123f) },
	{ FLOAT2FP( -0.9999247018391445f),	FLOAT2FP( -0.0122715382857200f) }
};
#endif

#if defined(USE_TWIDDLE_TABLE_N1024)
static const osk_fp_complex_t W1024[] = {
	{ FLOAT2FP( 1.0000000000000000f),	FLOAT2FP( -0.0000000000000000f) },
	{ FLOAT2FP( 0.9999811752826011f),	FLOAT2FP( -0.0061358846491545f) },
	{ FLOAT2FP( 0.9999247018391445f),	FLOAT2FP( -0.0122715382857199f) },
	{ FLOAT2FP( 0.9998305817958234f),	FLOAT2FP( -0.0184067299058048f) },
	{ FLOAT2FP( 0.9996988186962042f),	FLOAT2FP( -0.0245412285229123f) },
	{ FLOAT2FP( 0.9995294175010931f),	FLOAT2FP( -0.0306748031766366f) },
	{ FLOAT2FP( 0.9993223845883495f),	FLOAT2FP( -0.0368072229413588f) },
	{ FLOAT2FP( 0.9990777277526454f),	FLOAT2FP( -0.0429382569349408f) },
	{ FLOAT2FP( 0.9987954562051724f),	FLOAT2FP( -0.0490676743274180f) },
	{ FLOAT2FP( 0.9984755805732948f),	FLOAT2FP( -0.0551952443496899f) },
	{ FLOAT2FP( 0.9981181129001492f),	FLOAT2FP( -0.0613207363022086f) },
	{ FLOAT2FP( 0.9977230666441916f),	FLOAT2FP( -0.0674439195636641f) },
	{ FLOAT2FP( 0.9972904566786902f),	FLOAT2FP( -0.0735645635996674f) },
	{ FLOAT2FP( 0.9968202992911657f),	FLOAT2FP( -0.0796824379714301f) },
	{ FLOAT2FP( 0.9963126121827780f),	FLOAT2FP( -0.0857973123444399f) },
	{ FLOAT2FP( 0.9957674144676598f),	FLOAT2FP( -0.0919089564971327f) },
	{ FLOAT2FP( 0.9951847266721969f),	FLOAT2FP( -0.0980171403295606f) },
	{ FLOAT2FP( 0.9945645707342554f),	FLOAT2FP( -0.1041216338720546f) },
	{ FLOAT2FP( 0.9939069700023561f),	FLOAT2FP( -0.1102222072938831f) },
	{ FLOAT2FP( 0.9932119492347945f),	FLOAT2FP( -0.1163186309119048f) },
	{ FLOAT2FP( 0.9924795345987100f),	FLOAT2FP( -0.1224106751992162f) },
	{ FLOAT2FP( 0.9917097536690995f),	FLOAT2FP( -0.1284981107937932f) },
	{ FLOAT2FP( 0.9909026354277800f),	FLOAT2FP( -0.1345807085071262f) },
	{ FLOAT2FP( 0.9900582102622971f),	FLOAT2FP( -0.1406582393328492f) },
	{ FLOAT2FP( 0.9891765099647810f),	FLOAT2FP( -0.1467304744553617f) },
	{ FLOAT2FP( 0.9882575677307495f),	FLOAT2FP( -0.1527971852584434f) },
	{ FLOAT2FP( 0.9873014181578584f),	FLOAT2FP( -0.1588581433338614f) },
	{ FLOAT2FP( 0.9863080972445987f),	FLOAT2FP( -0.1649131204899699f) },
	{ FLOAT2FP( 0.9852776423889412f),	FLOAT2FP( -0.1709618887603012f) },
	{ FLOAT2FP( 0.9842100923869290f),	FLOAT2FP( -0.1770042204121487f) },
	{ FLOAT2FP( 0.9831054874312163f),	FLOAT2FP( -0.1830398879551410f) },
	{ FLOAT2FP( 0.9819638691095552f),	FLOAT2FP( -0.1890686641498062f) },
	{ FLOAT2FP( 0.9807852804032304f),	FLOAT2FP( -0.1950903220161282f) },
	{ FLOAT2FP( 0.9795697656854405f),	FLOAT2FP( -0.2011046348420919f) },
	{ FLOAT2FP( 0.9783173707196277f),	FLOAT2FP( -0.2071113761922186f) },
	{ FLOAT2FP( 0.9770281426577544f),	FLOAT2FP( -0.2131103199160914f) },
	{ FLOAT2FP( 0.9757021300385286f),	FLOAT2FP( -0.2191012401568698f) },
	{ FLOAT2FP( 0.9743393827855759f),	FLOAT2FP( -0.2250839113597928f) },
	{ FLOAT2FP( 0.9729399522055602f),	FLOAT2FP( -0.2310581082806711f) },
	{ FLOAT2FP( 0.9715038909862518f),	FLOAT2FP( -0.2370236059943672f) },
	{ FLOAT2FP( 0.9700312531945440f),	FLOAT2FP( -0.2429801799032639f) },
	{ FLOAT2FP( 0.9685220942744174f),	FLOAT2FP( -0.2489276057457201f) },
	{ FLOAT2FP( 0.9669764710448521f),	FLOAT2FP( -0.2548656596045146f) },
	{ FLOAT2FP( 0.9653944416976894f),	FLOAT2FP( -0.2607941179152755f) },
	{ FLOAT2FP( 0.9637760657954398f),	FLOAT2FP( -0.2667127574748984f) },
	{ FLOAT2FP( 0.9621214042690416f),	FLOAT2FP( -0.2726213554499490f) },
	{ FLOAT2FP( 0.9604305194155658f),	FLOAT2FP( -0.2785196893850531f) },
	{ FLOAT2FP( 0.9587034748958716f),	FLOAT2FP( -0.2844075372112719f) },
	{ FLOAT2FP( 0.9569403357322088f),	FLOAT2FP( -0.2902846772544623f) },
	{ FLOAT2FP( 0.9551411683057708f),	FLOAT2FP( -0.2961508882436238f) },
	{ FLOAT2FP( 0.9533060403541939f),	FLOAT2FP( -0.3020059493192281f) },
	{ FLOAT2FP( 0.9514350209690083f),	FLOAT2FP( -0.3078496400415349f) },
	{ FLOAT2FP( 0.9495281805930367f),	FLOAT2FP( -0.3136817403988915f) },
	{ FLOAT2FP( 0.9475855910177411f),	FLOAT2FP( -0.3195020308160157f) },
	{ FLOAT2FP( 0.9456073253805213f),	FLOAT2FP( -0.3253102921622629f) },
	{ FLOAT2FP( 0.9435934581619604f),	FLOAT2FP( -0.3311063057598764f) },
	{ FLOAT2FP( 0.9415440651830208f),	FLOAT2FP( -0.3368898533922201f) },
	{ FLOAT2FP( 0.9394592236021899f),	FLOAT2FP( -0.3426607173119944f) },
	{ FLOAT2FP( 0.9373390119125750f),	FLOAT2FP( -0.3484186802494346f) },
	{ FLOAT2FP( 0.9351835099389476f),	FLOAT2FP( -0.3541635254204903f) },
	{ FLOAT2FP( 0.9329927988347390f),	FLOAT2FP( -0.3598950365349881f) },
	{ FLOAT2FP( 0.9307669610789837f),	FLOAT2FP( -0.3656129978047739f) },
	{ FLOAT2FP( 0.9285060804732156f),	FLOAT2FP( -0.3713171939518375f) },
	{ FLOAT2FP( 0.9262102421383114f),	FLOAT2FP( -0.3770074102164183f) },
	{ FLOAT2FP( 0.9238795325112867f),	FLOAT2FP( -0.3826834323650898f) },
	{ FLOAT2FP( 0.9215140393420419f),	FLOAT2FP( -0.3883450466988262f) },
	{ FLOAT2FP( 0.9191138516900578f),	FLOAT2FP( -0.3939920400610481f) },
	{ FLOAT2FP( 0.9166790599210427f),	FLOAT2FP( -0.3996241998456468f) },
	{ FLOAT2FP( 0.9142097557035307f),	FLOAT2FP( -0.4052413140049899f) },
	{ FLOAT2FP( 0.9117060320054299f),	FLOAT2FP( -0.4108431710579039f) },
	{ FLOAT2FP( 0.9091679830905224f),	FLOAT2FP( -0.4164295600976372f) },
	{ FLOAT2FP( 0.9065957045149153f),	FLOAT2FP( -0.4220002707997997f) },
	{ FLOAT2FP( 0.9039892931234433f),	FLOAT2FP( -0.4275550934302821f) },
	{ FLOAT2FP( 0.9013488470460220f),	FLOAT2FP( -0.4330938188531520f) },
	{ FLOAT2FP( 0.8986744656939538f),	FLOAT2FP( -0.4386162385385277f) },
	{ FLOAT2FP( 0.8959662497561852f),	FLOAT2FP( -0.4441221445704292f) },
	{ FLOAT2FP( 0.8932243011955153f),	FLOAT2FP( -0.4496113296546065f) },
	{ FLOAT2FP( 0.8904487232447579f),	FLOAT2FP( -0.4550835871263438f) },
	{ FLOAT2FP( 0.8876396204028539f),	FLOAT2FP( -0.4605387109582400f) },
	{ FLOAT2FP( 0.8847970984309378f),	FLOAT2FP( -0.4659764957679662f) },
	{ FLOAT2FP( 0.8819212643483550f),	FLOAT2FP( -0.4713967368259976f) },
	{ FLOAT2FP( 0.8790122264286335f),	FLOAT2FP( -0.4767992300633221f) },
	{ FLOAT2FP( 0.8760700941954066f),	FLOAT2FP( -0.4821837720791227f) },
	{ FLOAT2FP( 0.8730949784182901f),	FLOAT2FP( -0.4875501601484360f) },
	{ FLOAT2FP( 0.8700869911087115f),	FLOAT2FP( -0.4928981922297840f) },
	{ FLOAT2FP( 0.8670462455156926f),	FLOAT2FP( -0.4982276669727818f) },
	{ FLOAT2FP( 0.8639728561215867f),	FLOAT2FP( -0.5035383837257176f) },
	{ FLOAT2FP( 0.8608669386377673f),	FLOAT2FP( -0.5088301425431070f) },
	{ FLOAT2FP( 0.8577286100002721f),	FLOAT2FP( -0.5141027441932217f) },
	{ FLOAT2FP( 0.8545579883654005f),	FLOAT2FP( -0.5193559901655896f) },
	{ FLOAT2FP( 0.8513551931052652f),	FLOAT2FP( -0.5245896826784689f) },
	{ FLOAT2FP( 0.8481203448032972f),	FLOAT2FP( -0.5298036246862946f) },
	{ FLOAT2FP( 0.8448535652497071f),	FLOAT2FP( -0.5349976198870972f) },
	{ FLOAT2FP( 0.8415549774368984f),	FLOAT2FP( -0.5401714727298929f) },
	{ FLOAT2FP( 0.8382247055548381f),	FLOAT2FP( -0.5453249884220465f) },
	{ FLOAT2FP( 0.8348628749863800f),	FLOAT2FP( -0.5504579729366048f) },
	{ FLOAT2FP( 0.8314696123025452f),	FLOAT2FP( -0.5555702330196022f) },
	{ FLOAT2FP( 0.8280450452577558f),	FLOAT2FP( -0.5606615761973360f) },
	{ FLOAT2FP( 0.8245893027850253f),	FLOAT2FP( -0.5657318107836131f) },
	{ FLOAT2FP( 0.8211025149911046f),	FLOAT2FP( -0.5707807458869673f) },
	{ FLOAT2FP( 0.8175848131515837f),	FLOAT2FP( -0.5758081914178453f) },
	{ FLOAT2FP( 0.8140363297059484f),	FLOAT2FP( -0.5808139580957645f) },
	{ FLOAT2FP( 0.8104571982525948f),	FLOAT2FP( -0.5857978574564389f) },
	{ FLOAT2FP( 0.8068475535437993f),	FLOAT2FP( -0.5907597018588742f) },
	{ FLOAT2FP( 0.8032075314806449f),	FLOAT2FP( -0.5956993044924334f) },
	{ FLOAT2FP( 0.7995372691079050f),	FLOAT2FP( -0.6006164793838690f) },
	{ FLOAT2FP( 0.7958369046088836f),	FLOAT2FP( -0.6055110414043255f) },
	{ FLOAT2FP( 0.7921065773002124f),	FLOAT2FP( -0.6103828062763095f) },
	{ FLOAT2FP( 0.7883464276266062f),	FLOAT2FP( -0.6152315905806268f) },
	{ FLOAT2FP( 0.7845565971555752f),	FLOAT2FP( -0.6200572117632891f) },
	{ FLOAT2FP( 0.7807372285720945f),	FLOAT2FP( -0.6248594881423863f) },
	{ FLOAT2FP( 0.7768884656732324f),	FLOAT2FP( -0.6296382389149270f) },
	{ FLOAT2FP( 0.7730104533627370f),	FLOAT2FP( -0.6343932841636455f) },
	{ FLOAT2FP( 0.7691033376455797f),	FLOAT2FP( -0.6391244448637757f) },
	{ FLOAT2FP( 0.7651672656224590f),	FLOAT2FP( -0.6438315428897914f) },
	{ FLOAT2FP( 0.7612023854842618f),	FLOAT2FP( -0.6485144010221124f) },
	{ FLOAT2FP( 0.7572088465064846f),	FLOAT2FP( -0.6531728429537768f) },
	{ FLOAT2FP( 0.7531867990436125f),	FLOAT2FP( -0.6578066932970786f) },
	{ FLOAT2FP( 0.7491363945234594f),	FLOAT2FP( -0.6624157775901718f) },
	{ FLOAT2FP( 0.7450577854414659f),	FLOAT2FP( -0.6669999223036375f) },
	{ FLOAT2FP( 0.7409511253549592f),	FLOAT2FP( -0.6715589548470183f) },
	{ FLOAT2FP( 0.7368165688773698f),	FLOAT2FP( -0.6760927035753159f) },
	{ FLOAT2FP( 0.7326542716724128f),	FLOAT2FP( -0.6806009977954530f) },
	{ FLOAT2FP( 0.7284643904482252f),	FLOAT2FP( -0.6850836677727004f) },
	{ FLOAT2FP( 0.7242470829514670f),	FLOAT2FP( -0.6895405447370668f) },
	{ FLOAT2FP( 0.7200025079613817f),	FLOAT2FP( -0.6939714608896539f) },
	{ FLOAT2FP( 0.7157308252838187f),	FLOAT2FP( -0.6983762494089728f) },
	{ FLOAT2FP( 0.7114321957452164f),	FLOAT2FP( -0.7027547444572253f) },
	{ FLOAT2FP( 0.7071067811865476f),	FLOAT2FP( -0.7071067811865476f) },
	{ FLOAT2FP( 0.7027547444572253f),	FLOAT2FP( -0.7114321957452164f) },
	{ FLOAT2FP( 0.6983762494089729f),	FLOAT2FP( -0.7157308252838186f) },
	{ FLOAT2FP( 0.6939714608896540f),	FLOAT2FP( -0.7200025079613817f) },
	{ FLOAT2FP( 0.6895405447370669f),	FLOAT2FP( -0.7242470829514669f) },
	{ FLOAT2FP( 0.6850836677727004f),	FLOAT2FP( -0.7284643904482252f) },
	{ FLOAT2FP( 0.6806009977954530f),	FLOAT2FP( -0.7326542716724128f) },
	{ FLOAT2FP( 0.6760927035753160f),	FLOAT2FP( -0.7368165688773698f) },
	{ FLOAT2FP( 0.6715589548470183f),	FLOAT2FP( -0.7409511253549591f) },
	{ FLOAT2FP( 0.6669999223036375f),	FLOAT2FP( -0.7450577854414659f) },
	{ FLOAT2FP( 0.6624157775901718f),	FLOAT2FP( -0.7491363945234593f) },
	{ FLOAT2FP( 0.6578066932970787f),	FLOAT2FP( -0.7531867990436125f) },
	{ FLOAT2FP( 0.6531728429537769f),	FLOAT2FP( -0.7572088465064846f) },
	{ FLOAT2FP( 0.6485144010221126f),	FLOAT2FP( -0.7612023854842618f) },
	{ FLOAT2FP( 0.6438315428897915f),	FLOAT2FP( -0.7651672656224590f) },
	{ FLOAT2FP( 0.6391244448637757f),	FLOAT2FP( -0.7691033376455796f) },
	{ FLOAT2FP( 0.6343932841636455f),	FLOAT2FP( -0.7730104533627369f) },
	{ FLOAT2FP( 0.6296382389149271f),	FLOAT2FP( -0.7768884656732324f) },
	{ FLOAT2FP( 0.6248594881423865f),	FLOAT2FP( -0.7807372285720945f) },
	{ FLOAT2FP( 0.6200572117632892f),	FLOAT2FP( -0.7845565971555752f) },
	{ FLOAT2FP( 0.6152315905806268f),	FLOAT2FP( -0.7883464276266062f) },
	{ FLOAT2FP( 0.6103828062763095f),	FLOAT2FP( -0.7921065773002123f) },
	{ FLOAT2FP( 0.6055110414043255f),	FLOAT2FP( -0.7958369046088835f) },
	{ FLOAT2FP( 0.6006164793838690f),	FLOAT2FP( -0.7995372691079050f) },
	{ FLOAT2FP( 0.5956993044924335f),	FLOAT2FP( -0.8032075314806448f) },
	{ FLOAT2FP( 0.5907597018588743f),	FLOAT2FP( -0.8068475535437992f) },
	{ FLOAT2FP( 0.5857978574564389f),	FLOAT2FP( -0.8104571982525948f) },
	{ FLOAT2FP( 0.5808139580957645f),	FLOAT2FP( -0.8140363297059483f) },
	{ FLOAT2FP( 0.5758081914178453f),	FLOAT2FP( -0.8175848131515837f) },
	{ FLOAT2FP( 0.5707807458869674f),	FLOAT2FP( -0.8211025149911046f) },
	{ FLOAT2FP( 0.5657318107836132f),	FLOAT2FP( -0.8245893027850253f) },
	{ FLOAT2FP( 0.5606615761973360f),	FLOAT2FP( -0.8280450452577558f) },
	{ FLOAT2FP( 0.5555702330196023f),	FLOAT2FP( -0.8314696123025452f) },
	{ FLOAT2FP( 0.5504579729366048f),	FLOAT2FP( -0.8348628749863800f) },
	{ FLOAT2FP( 0.5453249884220465f),	FLOAT2FP( -0.8382247055548380f) },
	{ FLOAT2FP( 0.5401714727298930f),	FLOAT2FP( -0.8415549774368983f) },
	{ FLOAT2FP( 0.5349976198870973f),	FLOAT2FP( -0.8448535652497070f) },
	{ FLOAT2FP( 0.5298036246862948f),	FLOAT2FP( -0.8481203448032971f) },
	{ FLOAT2FP( 0.5245896826784688f),	FLOAT2FP( -0.8513551931052652f) },
	{ FLOAT2FP( 0.5193559901655895f),	FLOAT2FP( -0.8545579883654005f) },
	{ FLOAT2FP( 0.5141027441932217f),	FLOAT2FP( -0.8577286100002721f) },
	{ FLOAT2FP( 0.5088301425431070f),	FLOAT2FP( -0.8608669386377673f) },
	{ FLOAT2FP( 0.5035383837257176f),	FLOAT2FP( -0.8639728561215867f) },
	{ FLOAT2FP( 0.4982276669727819f),	FLOAT2FP( -0.8670462455156926f) },
	{ FLOAT2FP( 0.4928981922297841f),	FLOAT2FP( -0.8700869911087113f) },
	{ FLOAT2FP( 0.4875501601484361f),	FLOAT2FP( -0.8730949784182901f) },
	{ FLOAT2FP( 0.4821837720791228f),	FLOAT2FP( -0.8760700941954066f) },
	{ FLOAT2FP( 0.4767992300633223f),	FLOAT2FP( -0.8790122264286334f) },
	{ FLOAT2FP( 0.4713967368259978f),	FLOAT2FP( -0.8819212643483549f) },
	{ FLOAT2FP( 0.4659764957679661f),	FLOAT2FP( -0.8847970984309378f) },
	{ FLOAT2FP( 0.4605387109582400f),	FLOAT2FP( -0.8876396204028539f) },
	{ FLOAT2FP( 0.4550835871263438f),	FLOAT2FP( -0.8904487232447579f) },
	{ FLOAT2FP( 0.4496113296546066f),	FLOAT2FP( -0.8932243011955153f) },
	{ FLOAT2FP( 0.4441221445704293f),	FLOAT2FP( -0.8959662497561851f) },
	{ FLOAT2FP( 0.4386162385385277f),	FLOAT2FP( -0.8986744656939538f) },
	{ FLOAT2FP( 0.4330938188531520f),	FLOAT2FP( -0.9013488470460220f) },
	{ FLOAT2FP( 0.4275550934302822f),	FLOAT2FP( -0.9039892931234433f) },
	{ FLOAT2FP( 0.4220002707997998f),	FLOAT2FP( -0.9065957045149153f) },
	{ FLOAT2FP( 0.4164295600976373f),	FLOAT2FP( -0.9091679830905223f) },
	{ FLOAT2FP( 0.4108431710579039f),	FLOAT2FP( -0.9117060320054299f) },
	{ FLOAT2FP( 0.4052413140049899f),	FLOAT2FP( -0.9142097557035307f) },
	{ FLOAT2FP( 0.3996241998456468f),	FLOAT2FP( -0.9166790599210427f) },
	{ FLOAT2FP( 0.3939920400610481f),	FLOAT2FP( -0.9191138516900578f) },
	{ FLOAT2FP( 0.3883450466988263f),	FLOAT2FP( -0.9215140393420419f) },
	{ FLOAT2FP( 0.3826834323650898f),	FLOAT2FP( -0.9238795325112867f) },
	{ FLOAT2FP( 0.3770074102164183f),	FLOAT2FP( -0.9262102421383113f) },
	{ FLOAT2FP( 0.3713171939518376f),	FLOAT2FP( -0.9285060804732156f) },
	{ FLOAT2FP( 0.3656129978047740f),	FLOAT2FP( -0.9307669610789837f) },
	{ FLOAT2FP( 0.3598950365349883f),	FLOAT2FP( -0.9329927988347388f) },
	{ FLOAT2FP( 0.3541635254204905f),	FLOAT2FP( -0.9351835099389475f) },
	{ FLOAT2FP( 0.3484186802494345f),	FLOAT2FP( -0.9373390119125750f) },
	{ FLOAT2FP( 0.3426607173119944f),	FLOAT2FP( -0.9394592236021899f) },
	{ FLOAT2FP( 0.3368898533922201f),	FLOAT2FP( -0.9415440651830208f) },
	{ FLOAT2FP( 0.3311063057598764f),	FLOAT2FP( -0.9435934581619604f) },
	{ FLOAT2FP( 0.3253102921622630f),	FLOAT2FP( -0.9456073253805213f) },
	{ FLOAT2FP( 0.3195020308160157f),	FLOAT2FP( -0.9475855910177411f) },
	{ FLOAT2FP( 0.3136817403988916f),	FLOAT2FP( -0.9495281805930367f) },
	{ FLOAT2FP( 0.3078496400415350f),	FLOAT2FP( -0.9514350209690083f) },
	{ FLOAT2FP( 0.3020059493192282f),	FLOAT2FP( -0.9533060403541938f) },
	{ FLOAT2FP( 0.2961508882436240f),	FLOAT2FP( -0.9551411683057707f) },
	{ FLOAT2FP( 0.2902846772544623f),	FLOAT2FP( -0.9569403357322089f) },
	{ FLOAT2FP( 0.2844075372112718f),	FLOAT2FP( -0.9587034748958716f) },
	{ FLOAT2FP( 0.2785196893850531f),	FLOAT2FP( -0.9604305194155658f) },
	{ FLOAT2FP( 0.2726213554499490f),	FLOAT2FP( -0.9621214042690416f) },
	{ FLOAT2FP( 0.2667127574748984f),	FLOAT2FP( -0.9637760657954398f) },
	{ FLOAT2FP( 0.2607941179152756f),	FLOAT2FP( -0.9653944416976894f) },
	{ FLOAT2FP( 0.2548656596045146f),	FLOAT2FP( -0.9669764710448521f) },
	{ FLOAT2FP( 0.2489276057457203f),	FLOAT2FP( -0.9685220942744173f) },
	{ FLOAT2FP( 0.2429801799032640f),	FLOAT2FP( -0.9700312531945440f) },
	{ FLOAT2FP( 0.2370236059943673f),	FLOAT2FP( -0.9715038909862518f) },
	{ FLOAT2FP( 0.2310581082806713f),	FLOAT2FP( -0.9729399522055601f) },
	{ FLOAT2FP( 0.2250839113597928f),	FLOAT2FP( -0.9743393827855759f) },
	{ FLOAT2FP( 0.2191012401568698f),	FLOAT2FP( -0.9757021300385286f) },
	{ FLOAT2FP( 0.2131103199160914f),	FLOAT2FP( -0.9770281426577544f) },
	{ FLOAT2FP( 0.2071113761922186f),	FLOAT2FP( -0.9783173707196277f) },
	{ FLOAT2FP( 0.2011046348420920f),	FLOAT2FP( -0.9795697656854405f) },
	{ FLOAT2FP( 0.1950903220161283f),	FLOAT2FP( -0.9807852804032304f) },
	{ FLOAT2FP( 0.1890686641498063f),	FLOAT2FP( -0.9819638691095552f) },
	{ FLOAT2FP( 0.1830398879551411f),	FLOAT2FP( -0.9831054874312163f) },
	{ FLOAT2FP( 0.1770042204121489f),	FLOAT2FP( -0.9842100923869290f) },
	{ FLOAT2FP( 0.1709618887603014f),	FLOAT2FP( -0.9852776423889412f) },
	{ FLOAT2FP( 0.1649131204899701f),	FLOAT2FP( -0.9863080972445987f) },
	{ FLOAT2FP( 0.1588581433338614f),	FLOAT2FP( -0.9873014181578584f) },
	{ FLOAT2FP( 0.1527971852584434f),	FLOAT2FP( -0.9882575677307495f) },
	{ FLOAT2FP( 0.1467304744553617f),	FLOAT2FP( -0.9891765099647810f) },
	{ FLOAT2FP( 0.1406582393328492f),	FLOAT2FP( -0.9900582102622971f) },
	{ FLOAT2FP( 0.1345807085071262f),	FLOAT2FP( -0.9909026354277800f) },
	{ FLOAT2FP( 0.1284981107937932f),	FLOAT2FP( -0.9917097536690995f) },
	{ FLOAT2FP( 0.1224106751992163f),	FLOAT2FP( -0.9924795345987100f) },
	{ FLOAT2FP( 0.1163186309119049f),	FLOAT2FP( -0.9932119492347945f) },
	{ FLOAT2FP( 0.1102222072938832f),	FLOAT2FP( -0.9939069700023561f) },
	{ FLOAT2FP( 0.1041216338720547f),	FLOAT2FP( -0.9945645707342554f) },
	{ FLOAT2FP( 0.0980171403295608f),	FLOAT2FP( -0.9951847266721968f) },
	{ FLOAT2FP( 0.0919089564971327f),	FLOAT2FP( -0.9957674144676598f) },
	{ FLOAT2FP( 0.0857973123444399f),	FLOAT2FP( -0.9963126121827780f) },
	{ FLOAT2FP( 0.0796824379714301f),	FLOAT2FP( -0.9968202992911657f) },
	{ FLOAT2FP( 0.0735645635996675f),	FLOAT2FP( -0.9972904566786902f) },
	{ FLOAT2FP( 0.0674439195636641f),	FLOAT2FP( -0.9977230666441916f) },
	{ FLOAT2FP( 0.0613207363022086f),	FLOAT2FP( -0.9981181129001492f) },
	{ FLOAT2FP( 0.0551952443496900f),	FLOAT2FP( -0.9984755805732948f) },
	{ FLOAT2FP( 0.0490676743274181f),	FLOAT2FP( -0.9987954562051724f) },
	{ FLOAT2FP( 0.0429382569349410f),	FLOAT2FP( -0.9990777277526454f) },
	{ FLOAT2FP( 0.0368072229413590f),	FLOAT2FP( -0.9993223845883495f) },
	{ FLOAT2FP( 0.0306748031766366f),	FLOAT2FP( -0.9995294175010931f) },
	{ FLOAT2FP( 0.0245412285229123f),	FLOAT2FP( -0.9996988186962042f) },
	{ FLOAT2FP( 0.0184067299058048f),	FLOAT2FP( -0.9998305817958234f) },
	{ FLOAT2FP( 0.0122715382857199f),	FLOAT2FP( -0.9999247018391445f) },
	{ FLOAT2FP( 0.0061358846491545f),	FLOAT2FP( -0.9999811752826011f) },
	{ FLOAT2FP( 0.0000000000000001f),	FLOAT2FP( -1.0000000000000000f) },
	{ FLOAT2FP( -0.0061358846491544f),	FLOAT2FP( -0.9999811752826011f) },
	{ FLOAT2FP( -0.0122715382857198f),	FLOAT2FP( -0.9999247018391445f) },
	{ FLOAT2FP( -0.0184067299058047f),	FLOAT2FP( -0.9998305817958234f) },
	{ FLOAT2FP( -0.0245412285229121f),	FLOAT2FP( -0.9996988186962042f) },
	{ FLOAT2FP( -0.0306748031766365f),	FLOAT2FP( -0.9995294175010931f) },
	{ FLOAT2FP( -0.0368072229413589f),	FLOAT2FP( -0.9993223845883495f) },
	{ FLOAT2FP( -0.0429382569349408f),	FLOAT2FP( -0.9990777277526454f) },
	{ FLOAT2FP( -0.0490676743274180f),	FLOAT2FP( -0.9987954562051724f) },
	{ FLOAT2FP( -0.0551952443496899f),	FLOAT2FP( -0.9984755805732948f) },
	{ FLOAT2FP( -0.0613207363022085f),	FLOAT2FP( -0.9981181129001492f) },
	{ FLOAT2FP( -0.0674439195636640f),	FLOAT2FP( -0.9977230666441916f) },
	{ FLOAT2FP( -0.0735645635996673f),	FLOAT2FP( -0.9972904566786902f) },
	{ FLOAT2FP( -0.0796824379714300f),	FLOAT2FP( -0.9968202992911658f) },
	{ FLOAT2FP( -0.0857973123444398f),	FLOAT2FP( -0.9963126121827780f) },
	{ FLOAT2FP( -0.0919089564971326f),	FLOAT2FP( -0.9957674144676598f) },
	{ FLOAT2FP( -0.0980171403295606f),	FLOAT2FP( -0.9951847266721969f) },
	{ FLOAT2FP( -0.1041216338720546f),	FLOAT2FP( -0.9945645707342554f) },
	{ FLOAT2FP( -0.1102222072938831f),	FLOAT2FP( -0.9939069700023561f) },
	{ FLOAT2FP( -0.1163186309119048f),	FLOAT2FP( -0.9932119492347945f) },
	{ FLOAT2FP( -0.1224106751992162f),	FLOAT2FP( -0.9924795345987100f) },
	{ FLOAT2FP( -0.1284981107937931f),	FLOAT2FP( -0.9917097536690995f) },
	{ FLOAT2FP( -0.1345807085071261f),	FLOAT2FP( -0.9909026354277800f) },
	{ FLOAT2FP( -0.1406582393328491f),	FLOAT2FP( -0.9900582102622971f) },
	{ FLOAT2FP( -0.1467304744553616f),	FLOAT2FP( -0.9891765099647810f) },
	{ FLOAT2FP( -0.1527971852584433f),	FLOAT2FP( -0.9882575677307495f) },
	{ FLOAT2FP( -0.1588581433338613f),	FLOAT2FP( -0.9873014181578584f) },
	{ FLOAT2FP( -0.1649131204899699f),	FLOAT2FP( -0.9863080972445987f) },
	{ FLOAT2FP( -0.1709618887603012f),	FLOAT2FP( -0.9852776423889412f) },
	{ FLOAT2FP( -0.1770042204121487f),	FLOAT2FP( -0.9842100923869290f) },
	{ FLOAT2FP( -0.1830398879551409f),	FLOAT2FP( -0.9831054874312163f) },
	{ FLOAT2FP( -0.1890686641498062f),	FLOAT2FP( -0.9819638691095552f) },
	{ FLOAT2FP( -0.1950903220161282f),	FLOAT2FP( -0.9807852804032304f) },
	{ FLOAT2FP( -0.2011046348420918f),	FLOAT2FP( -0.9795697656854405f) },
	{ FLOAT2FP( -0.2071113761922184f),	FLOAT2FP( -0.9783173707196277f) },
	{ FLOAT2FP( -0.2131103199160913f),	FLOAT2FP( -0.9770281426577544f) },
	{ FLOAT2FP( -0.2191012401568697f),	FLOAT2FP( -0.9757021300385286f) },
	{ FLOAT2FP( -0.2250839113597927f),	FLOAT2FP( -0.9743393827855759f) },
	{ FLOAT2FP( -0.2310581082806711f),	FLOAT2FP( -0.9729399522055602f) },
	{ FLOAT2FP( -0.2370236059943672f),	FLOAT2FP( -0.9715038909862518f) },
	{ FLOAT2FP( -0.2429801799032639f),	FLOAT2FP( -0.9700312531945440f) },
	{ FLOAT2FP( -0.2489276057457201f),	FLOAT2FP( -0.9685220942744174f) },
	{ FLOAT2FP( -0.2548656596045145f),	FLOAT2FP( -0.9669764710448521f) },
	{ FLOAT2FP( -0.2607941179152755f),	FLOAT2FP( -0.9653944416976894f) },
	{ FLOAT2FP( -0.2667127574748983f),	FLOAT2FP( -0.9637760657954398f) },
	{ FLOAT2FP( -0.2726213554499489f),	FLOAT2FP( -0.9621214042690416f) },
	{ FLOAT2FP( -0.2785196893850529f),	FLOAT2FP( -0.9604305194155659f) },
	{ FLOAT2FP( -0.2844075372112717f),	FLOAT2FP( -0.9587034748958716f) },
	{ FLOAT2FP( -0.2902846772544622f),	FLOAT2FP( -0.9569403357322089f) },
	{ FLOAT2FP( -0.2961508882436238f),	FLOAT2FP( -0.9551411683057707f) },
	{ FLOAT2FP( -0.3020059493192281f),	FLOAT2FP( -0.9533060403541939f) },
	{ FLOAT2FP( -0.3078496400415349f),	FLOAT2FP( -0.9514350209690083f) },
	{ FLOAT2FP( -0.3136817403988914f),	FLOAT2FP( -0.9495281805930367f) },
	{ FLOAT2FP( -0.3195020308160156f),	FLOAT2FP( -0.9475855910177412f) },
	{ FLOAT2FP( -0.3253102921622629f),	FLOAT2FP( -0.9456073253805214f) },
	{ FLOAT2FP( -0.3311063057598763f),	FLOAT2FP( -0.9435934581619604f) },
	{ FLOAT2FP( -0.3368898533922199f),	FLOAT2FP( -0.9415440651830208f) },
	{ FLOAT2FP( -0.3426607173119943f),	FLOAT2FP( -0.9394592236021899f) },
	{ FLOAT2FP( -0.3484186802494344f),	FLOAT2FP( -0.9373390119125750f) },
	{ FLOAT2FP( -0.3541635254204904f),	FLOAT2FP( -0.9351835099389476f) },
	{ FLOAT2FP( -0.3598950365349882f),	FLOAT2FP( -0.9329927988347388f) },
	{ FLOAT2FP( -0.3656129978047739f),	FLOAT2FP( -0.9307669610789837f) },
	{ FLOAT2FP( -0.3713171939518375f),	FLOAT2FP( -0.9285060804732156f) },
	{ FLOAT2FP( -0.3770074102164182f),	FLOAT2FP( -0.9262102421383114f) },
	{ FLOAT2FP( -0.3826834323650897f),	FLOAT2FP( -0.9238795325112867f) },
	{ FLOAT2FP( -0.3883450466988262f),	FLOAT2FP( -0.9215140393420420f) },
	{ FLOAT2FP( -0.3939920400610480f),	FLOAT2FP( -0.9191138516900578f) },
	{ FLOAT2FP( -0.3996241998456467f),	FLOAT2FP( -0.9166790599210427f) },
	{ FLOAT2FP( -0.4052413140049897f),	FLOAT2FP( -0.9142097557035307f) },
	{ FLOAT2FP( -0.4108431710579038f),	FLOAT2FP( -0.9117060320054299f) },
	{ FLOAT2FP( -0.4164295600976370f),	FLOAT2FP( -0.9091679830905225f) },
	{ FLOAT2FP( -0.4220002707997997f),	FLOAT2FP( -0.9065957045149153f) },
	{ FLOAT2FP( -0.4275550934302819f),	FLOAT2FP( -0.9039892931234434f) },
	{ FLOAT2FP( -0.4330938188531519f),	FLOAT2FP( -0.9013488470460220f) },
	{ FLOAT2FP( -0.4386162385385274f),	FLOAT2FP( -0.8986744656939539f) },
	{ FLOAT2FP( -0.4441221445704291f),	FLOAT2FP( -0.8959662497561852f) },
	{ FLOAT2FP( -0.4496113296546067f),	FLOAT2FP( -0.8932243011955152f) },
	{ FLOAT2FP( -0.4550835871263437f),	FLOAT2FP( -0.8904487232447580f) },
	{ FLOAT2FP( -0.4605387109582401f),	FLOAT2FP( -0.8876396204028539f) },
	{ FLOAT2FP( -0.4659764957679660f),	FLOAT2FP( -0.8847970984309379f) },
	{ FLOAT2FP( -0.4713967368259977f),	FLOAT2FP( -0.8819212643483550f) },
	{ FLOAT2FP( -0.4767992300633219f),	FLOAT2FP( -0.8790122264286335f) },
	{ FLOAT2FP( -0.4821837720791227f),	FLOAT2FP( -0.8760700941954066f) },
	{ FLOAT2FP( -0.4875501601484357f),	FLOAT2FP( -0.8730949784182902f) },
	{ FLOAT2FP( -0.4928981922297840f),	FLOAT2FP( -0.8700869911087115f) },
	{ FLOAT2FP( -0.4982276669727816f),	FLOAT2FP( -0.8670462455156928f) },
	{ FLOAT2FP( -0.5035383837257175f),	FLOAT2FP( -0.8639728561215868f) },
	{ FLOAT2FP( -0.5088301425431071f),	FLOAT2FP( -0.8608669386377672f) },
	{ FLOAT2FP( -0.5141027441932216f),	FLOAT2FP( -0.8577286100002721f) },
	{ FLOAT2FP( -0.5193559901655896f),	FLOAT2FP( -0.8545579883654005f) },
	{ FLOAT2FP( -0.5245896826784687f),	FLOAT2FP( -0.8513551931052652f) },
	{ FLOAT2FP( -0.5298036246862947f),	FLOAT2FP( -0.8481203448032972f) },
	{ FLOAT2FP( -0.5349976198870970f),	FLOAT2FP( -0.8448535652497072f) },
	{ FLOAT2FP( -0.5401714727298929f),	FLOAT2FP( -0.8415549774368984f) },
	{ FLOAT2FP( -0.5453249884220462f),	FLOAT2FP( -0.8382247055548382f) },
	{ FLOAT2FP( -0.5504579729366047f),	FLOAT2FP( -0.8348628749863801f) },
	{ FLOAT2FP( -0.5555702330196020f),	FLOAT2FP( -0.8314696123025453f) },
	{ FLOAT2FP( -0.5606615761973359f),	FLOAT2FP( -0.8280450452577558f) },
	{ FLOAT2FP( -0.5657318107836132f),	FLOAT2FP( -0.8245893027850252f) },
	{ FLOAT2FP( -0.5707807458869671f),	FLOAT2FP( -0.8211025149911048f) },
	{ FLOAT2FP( -0.5758081914178453f),	FLOAT2FP( -0.8175848131515837f) },
	{ FLOAT2FP( -0.5808139580957644f),	FLOAT2FP( -0.8140363297059485f) },
	{ FLOAT2FP( -0.5857978574564389f),	FLOAT2FP( -0.8104571982525948f) },
	{ FLOAT2FP( -0.5907597018588741f),	FLOAT2FP( -0.8068475535437994f) },
	{ FLOAT2FP( -0.5956993044924334f),	FLOAT2FP( -0.8032075314806449f) },
	{ FLOAT2FP( -0.6006164793838688f),	FLOAT2FP( -0.7995372691079052f) },
	{ FLOAT2FP( -0.6055110414043254f),	FLOAT2FP( -0.7958369046088836f) },
	{ FLOAT2FP( -0.6103828062763096f),	FLOAT2FP( -0.7921065773002123f) },
	{ FLOAT2FP( -0.6152315905806267f),	FLOAT2FP( -0.7883464276266063f) },
	{ FLOAT2FP( -0.6200572117632892f),	FLOAT2FP( -0.7845565971555751f) },
	{ FLOAT2FP( -0.6248594881423862f),	FLOAT2FP( -0.7807372285720946f) },
	{ FLOAT2FP( -0.6296382389149271f),	FLOAT2FP( -0.7768884656732324f) },
	{ FLOAT2FP( -0.6343932841636454f),	FLOAT2FP( -0.7730104533627371f) },
	{ FLOAT2FP( -0.6391244448637757f),	FLOAT2FP( -0.7691033376455796f) },
	{ FLOAT2FP( -0.6438315428897913f),	FLOAT2FP( -0.7651672656224591f) },
	{ FLOAT2FP( -0.6485144010221124f),	FLOAT2FP( -0.7612023854842619f) },
	{ FLOAT2FP( -0.6531728429537765f),	FLOAT2FP( -0.7572088465064847f) },
	{ FLOAT2FP( -0.6578066932970785f),	FLOAT2FP( -0.7531867990436125f) },
	{ FLOAT2FP( -0.6624157775901719f),	FLOAT2FP( -0.7491363945234593f) },
	{ FLOAT2FP( -0.6669999223036374f),	FLOAT2FP( -0.7450577854414661f) },
	{ FLOAT2FP( -0.6715589548470184f),	FLOAT2FP( -0.7409511253549590f) },
	{ FLOAT2FP( -0.6760927035753158f),	FLOAT2FP( -0.7368165688773700f) },
	{ FLOAT2FP( -0.6806009977954530f),	FLOAT2FP( -0.7326542716724128f) },
	{ FLOAT2FP( -0.6850836677727002f),	FLOAT2FP( -0.7284643904482253f) },
	{ FLOAT2FP( -0.6895405447370669f),	FLOAT2FP( -0.7242470829514669f) },
	{ FLOAT2FP( -0.6939714608896538f),	FLOAT2FP( -0.7200025079613818f) },
	{ FLOAT2FP( -0.6983762494089728f),	FLOAT2FP( -0.7157308252838187f) },
	{ FLOAT2FP( -0.7027547444572251f),	FLOAT2FP( -0.7114321957452167f) },
	{ FLOAT2FP( -0.7071067811865475f),	FLOAT2FP( -0.7071067811865476f) },
	{ FLOAT2FP( -0.7114321957452165f),	FLOAT2FP( -0.7027547444572252f) },
	{ FLOAT2FP( -0.7157308252838186f),	FLOAT2FP( -0.6983762494089729f) },
	{ FLOAT2FP( -0.7200025079613817f),	FLOAT2FP( -0.6939714608896539f) },
	{ FLOAT2FP( -0.7242470829514668f),	FLOAT2FP( -0.6895405447370671f) },
	{ FLOAT2FP( -0.7284643904482252f),	FLOAT2FP( -0.6850836677727004f) },
	{ FLOAT2FP( -0.7326542716724127f),	FLOAT2FP( -0.6806009977954532f) },
	{ FLOAT2FP( -0.7368165688773698f),	FLOAT2FP( -0.6760927035753159f) },
	{ FLOAT2FP( -0.7409511253549589f),	FLOAT2FP( -0.6715589548470186f) },
	{ FLOAT2FP( -0.7450577854414659f),	FLOAT2FP( -0.6669999223036376f) },
	{ FLOAT2FP( -0.7491363945234591f),	FLOAT2FP( -0.6624157775901720f) },
	{ FLOAT2FP( -0.7531867990436124f),	FLOAT2FP( -0.6578066932970787f) },
	{ FLOAT2FP( -0.7572088465064847f),	FLOAT2FP( -0.6531728429537766f) },
	{ FLOAT2FP( -0.7612023854842617f),	FLOAT2FP( -0.6485144010221126f) },
	{ FLOAT2FP( -0.7651672656224590f),	FLOAT2FP( -0.6438315428897914f) },
	{ FLOAT2FP( -0.7691033376455795f),	FLOAT2FP( -0.6391244448637758f) },
	{ FLOAT2FP( -0.7730104533627370f),	FLOAT2FP( -0.6343932841636455f) },
	{ FLOAT2FP( -0.7768884656732323f),	FLOAT2FP( -0.6296382389149272f) },
	{ FLOAT2FP( -0.7807372285720945f),	FLOAT2FP( -0.6248594881423863f) },
	{ FLOAT2FP( -0.7845565971555750f),	FLOAT2FP( -0.6200572117632894f) },
	{ FLOAT2FP( -0.7883464276266062f),	FLOAT2FP( -0.6152315905806269f) },
	{ FLOAT2FP( -0.7921065773002122f),	FLOAT2FP( -0.6103828062763097f) },
	{ FLOAT2FP( -0.7958369046088835f),	FLOAT2FP( -0.6055110414043257f) },
	{ FLOAT2FP( -0.7995372691079051f),	FLOAT2FP( -0.6006164793838689f) },
	{ FLOAT2FP( -0.8032075314806448f),	FLOAT2FP( -0.5956993044924335f) },
	{ FLOAT2FP( -0.8068475535437993f),	FLOAT2FP( -0.5907597018588742f) },
	{ FLOAT2FP( -0.8104571982525947f),	FLOAT2FP( -0.5857978574564390f) },
	{ FLOAT2FP( -0.8140363297059484f),	FLOAT2FP( -0.5808139580957645f) },
	{ FLOAT2FP( -0.8175848131515836f),	FLOAT2FP( -0.5758081914178454f) },
	{ FLOAT2FP( -0.8211025149911046f),	FLOAT2FP( -0.5707807458869673f) },
	{ FLOAT2FP( -0.8245893027850251f),	FLOAT2FP( -0.5657318107836135f) },
	{ FLOAT2FP( -0.8280450452577557f),	FLOAT2FP( -0.5606615761973361f) },
	{ FLOAT2FP( -0.8314696123025453f),	FLOAT2FP( -0.5555702330196022f) },
	{ FLOAT2FP( -0.8348628749863800f),	FLOAT2FP( -0.5504579729366049f) },
	{ FLOAT2FP( -0.8382247055548381f),	FLOAT2FP( -0.5453249884220464f) },
	{ FLOAT2FP( -0.8415549774368983f),	FLOAT2FP( -0.5401714727298930f) },
	{ FLOAT2FP( -0.8448535652497071f),	FLOAT2FP( -0.5349976198870972f) },
	{ FLOAT2FP( -0.8481203448032971f),	FLOAT2FP( -0.5298036246862948f) },
	{ FLOAT2FP( -0.8513551931052652f),	FLOAT2FP( -0.5245896826784689f) },
	{ FLOAT2FP( -0.8545579883654004f),	FLOAT2FP( -0.5193559901655898f) },
	{ FLOAT2FP( -0.8577286100002720f),	FLOAT2FP( -0.5141027441932218f) },
	{ FLOAT2FP( -0.8608669386377672f),	FLOAT2FP( -0.5088301425431073f) },
	{ FLOAT2FP( -0.8639728561215867f),	FLOAT2FP( -0.5035383837257176f) },
	{ FLOAT2FP( -0.8670462455156926f),	FLOAT2FP( -0.4982276669727818f) },
	{ FLOAT2FP( -0.8700869911087113f),	FLOAT2FP( -0.4928981922297841f) },
	{ FLOAT2FP( -0.8730949784182901f),	FLOAT2FP( -0.4875501601484359f) },
	{ FLOAT2FP( -0.8760700941954065f),	FLOAT2FP( -0.4821837720791229f) },
	{ FLOAT2FP( -0.8790122264286335f),	FLOAT2FP( -0.4767992300633221f) },
	{ FLOAT2FP( -0.8819212643483549f),	FLOAT2FP( -0.4713967368259978f) },
	{ FLOAT2FP( -0.8847970984309378f),	FLOAT2FP( -0.4659764957679662f) },
	{ FLOAT2FP( -0.8876396204028538f),	FLOAT2FP( -0.4605387109582402f) },
	{ FLOAT2FP( -0.8904487232447579f),	FLOAT2FP( -0.4550835871263439f) },
	{ FLOAT2FP( -0.8932243011955152f),	FLOAT2FP( -0.4496113296546069f) },
	{ FLOAT2FP( -0.8959662497561851f),	FLOAT2FP( -0.4441221445704293f) },
	{ FLOAT2FP( -0.8986744656939539f),	FLOAT2FP( -0.4386162385385275f) },
	{ FLOAT2FP( -0.9013488470460219f),	FLOAT2FP( -0.4330938188531521f) },
	{ FLOAT2FP( -0.9039892931234433f),	FLOAT2FP( -0.4275550934302820f) },
	{ FLOAT2FP( -0.9065957045149153f),	FLOAT2FP( -0.4220002707997998f) },
	{ FLOAT2FP( -0.9091679830905224f),	FLOAT2FP( -0.4164295600976372f) },
	{ FLOAT2FP( -0.9117060320054298f),	FLOAT2FP( -0.4108431710579041f) },
	{ FLOAT2FP( -0.9142097557035307f),	FLOAT2FP( -0.4052413140049899f) },
	{ FLOAT2FP( -0.9166790599210426f),	FLOAT2FP( -0.3996241998456471f) },
	{ FLOAT2FP( -0.9191138516900578f),	FLOAT2FP( -0.3939920400610482f) },
	{ FLOAT2FP( -0.9215140393420418f),	FLOAT2FP( -0.3883450466988266f) },
	{ FLOAT2FP( -0.9238795325112867f),	FLOAT2FP( -0.3826834323650899f) },
	{ FLOAT2FP( -0.9262102421383114f),	FLOAT2FP( -0.3770074102164181f) },
	{ FLOAT2FP( -0.9285060804732155f),	FLOAT2FP( -0.3713171939518377f) },
	{ FLOAT2FP( -0.9307669610789837f),	FLOAT2FP( -0.3656129978047738f) },
	{ FLOAT2FP( -0.9329927988347388f),	FLOAT2FP( -0.3598950365349883f) },
	{ FLOAT2FP( -0.9351835099389476f),	FLOAT2FP( -0.3541635254204904f) },
	{ FLOAT2FP( -0.9373390119125748f),	FLOAT2FP( -0.3484186802494348f) },
	{ FLOAT2FP( -0.9394592236021899f),	FLOAT2FP( -0.3426607173119944f) },
	{ FLOAT2FP( -0.9415440651830207f),	FLOAT2FP( -0.3368898533922203f) },
	{ FLOAT2FP( -0.9435934581619604f),	FLOAT2FP( -0.3311063057598765f) },
	{ FLOAT2FP( -0.9456073253805212f),	FLOAT2FP( -0.3253102921622633f) },
	{ FLOAT2FP( -0.9475855910177411f),	FLOAT2FP( -0.3195020308160158f) },
	{ FLOAT2FP( -0.9495281805930367f),	FLOAT2FP( -0.3136817403988914f) },
	{ FLOAT2FP( -0.9514350209690083f),	FLOAT2FP( -0.3078496400415350f) },
	{ FLOAT2FP( -0.9533060403541939f),	FLOAT2FP( -0.3020059493192280f) },
	{ FLOAT2FP( -0.9551411683057707f),	FLOAT2FP( -0.2961508882436240f) },
	{ FLOAT2FP( -0.9569403357322088f),	FLOAT2FP( -0.2902846772544624f) },
	{ FLOAT2FP( -0.9587034748958715f),	FLOAT2FP( -0.2844075372112721f) },
	{ FLOAT2FP( -0.9604305194155658f),	FLOAT2FP( -0.2785196893850532f) },
	{ FLOAT2FP( -0.9621214042690415f),	FLOAT2FP( -0.2726213554499493f) },
	{ FLOAT2FP( -0.9637760657954398f),	FLOAT2FP( -0.2667127574748985f) },
	{ FLOAT2FP( -0.9653944416976893f),	FLOAT2FP( -0.2607941179152758f) },
	{ FLOAT2FP( -0.9669764710448521f),	FLOAT2FP( -0.2548656596045147f) },
	{ FLOAT2FP( -0.9685220942744174f),	FLOAT2FP( -0.2489276057457201f) },
	{ FLOAT2FP( -0.9700312531945440f),	FLOAT2FP( -0.2429801799032641f) },
	{ FLOAT2FP( -0.9715038909862518f),	FLOAT2FP( -0.2370236059943672f) },
	{ FLOAT2FP( -0.9729399522055601f),	FLOAT2FP( -0.2310581082806713f) },
	{ FLOAT2FP( -0.9743393827855759f),	FLOAT2FP( -0.2250839113597928f) },
	{ FLOAT2FP( -0.9757021300385285f),	FLOAT2FP( -0.2191012401568700f) },
	{ FLOAT2FP( -0.9770281426577544f),	FLOAT2FP( -0.2131103199160914f) },
	{ FLOAT2FP( -0.9783173707196275f),	FLOAT2FP( -0.2071113761922188f) },
	{ FLOAT2FP( -0.9795697656854405f),	FLOAT2FP( -0.2011046348420920f) },
	{ FLOAT2FP( -0.9807852804032304f),	FLOAT2FP( -0.1950903220161286f) },
	{ FLOAT2FP( -0.9819638691095552f),	FLOAT2FP( -0.1890686641498064f) },
	{ FLOAT2FP( -0.9831054874312163f),	FLOAT2FP( -0.1830398879551409f) },
	{ FLOAT2FP( -0.9842100923869290f),	FLOAT2FP( -0.1770042204121489f) },
	{ FLOAT2FP( -0.9852776423889412f),	FLOAT2FP( -0.1709618887603012f) },
	{ FLOAT2FP( -0.9863080972445986f),	FLOAT2FP( -0.1649131204899701f) },
	{ FLOAT2FP( -0.9873014181578584f),	FLOAT2FP( -0.1588581433338615f) },
	{ FLOAT2FP( -0.9882575677307495f),	FLOAT2FP( -0.1527971852584437f) },
	{ FLOAT2FP( -0.9891765099647810f),	FLOAT2FP( -0.1467304744553618f) },
	{ FLOAT2FP( -0.9900582102622970f),	FLOAT2FP( -0.1406582393328495f) },
	{ FLOAT2FP( -0.9909026354277800f),	FLOAT2FP( -0.1345807085071263f) },
	{ FLOAT2FP( -0.9917097536690995f),	FLOAT2FP( -0.1284981107937931f) },
	{ FLOAT2FP( -0.9924795345987100f),	FLOAT2FP( -0.1224106751992163f) },
	{ FLOAT2FP( -0.9932119492347945f),	FLOAT2FP( -0.1163186309119047f) },
	{ FLOAT2FP( -0.9939069700023561f),	FLOAT2FP( -0.1102222072938832f) },
	{ FLOAT2FP( -0.9945645707342554f),	FLOAT2FP( -0.1041216338720546f) },
	{ FLOAT2FP( -0.9951847266721968f),	FLOAT2FP( -0.0980171403295608f) },
	{ FLOAT2FP( -0.9957674144676598f),	FLOAT2FP( -0.0919089564971328f) },
	{ FLOAT2FP( -0.9963126121827780f),	FLOAT2FP( -0.0857973123444402f) },
	{ FLOAT2FP( -0.9968202992911657f),	FLOAT2FP( -0.0796824379714302f) },
	{ FLOAT2FP( -0.9972904566786902f),	FLOAT2FP( -0.0735645635996677f) },
	{ FLOAT2FP( -0.9977230666441916f),	FLOAT2FP( -0.0674439195636642f) },
	{ FLOAT2FP( -0.9981181129001492f),	FLOAT2FP( -0.0613207363022085f) },
	{ FLOAT2FP( -0.9984755805732948f),	FLOAT2FP( -0.0551952443496901f) },
	{ FLOAT2FP( -0.9987954562051724f),	FLOAT2FP( -0.0490676743274180f) },
	{ FLOAT2FP( -0.9990777277526454f),	FLOAT2FP( -0.0429382569349410f) },
	{ FLOAT2FP( -0.9993223845883495f),	FLOAT2FP( -0.0368072229413588f) },
	{ FLOAT2FP( -0.9995294175010931f),	FLOAT2FP( -0.0306748031766369f) },
	{ FLOAT2FP( -0.9996988186962042f),	FLOAT2FP( -0.0245412285229123f) },
	{ FLOAT2FP( -0.9998305817958234f),	FLOAT2FP( -0.0184067299058051f) },
	{ FLOAT2FP( -0.9999247018391445f),	FLOAT2FP( -0.0122715382857200f) },
	{ FLOAT2FP( -0.9999811752826011f),	FLOAT2FP( -0.0061358846491548f) }
};
#endif

static const osk_fp_complex_t* s_twiddlesFp[] = {
#if defined(USE_TWIDDLE_TABLE_N2)
	W0002,
#else
	NULL,
#endif
#if defined(USE_TWIDDLE_TABLE_N4)
	W0004,
#else
	NULL,
#endif
#if defined(USE_TWIDDLE_TABLE_N8)
	W0008,
#else
	NULL,
#endif
#if defined(USE_TWIDDLE_TABLE_N16)
	W0016,
#else
	NULL,
#endif
#if defined(USE_TWIDDLE_TABLE_N32)
	W0032,
#else
	NULL,
#endif
#if defined(USE_TWIDDLE_TABLE_N64)
	W0064,
#else
	NULL,
#endif
#if defined(USE_TWIDDLE_TABLE_N128)
	W0128,
#else
	NULL,
#endif
#if defined(USE_TWIDDLE_TABLE_N256)
	W0256,
#else
	NULL,
#endif
#if defined(USE_TWIDDLE_TABLE_N512)
	W0512,
#else
	NULL,
#endif
#if defined(USE_TWIDDLE_TABLE_N1024)
	W1024
#else
	NULL
#endif
};

#endif

