#ifndef _BITREVERSETABLE_H
#define _BITREVERSETABLE_H

#include <inttypes.h>
//#define USE_BIT_REVERSE_N4
//#define USE_BIT_REVERSE_N8
//#define USE_BIT_REVERSE_N16
//#define USE_BIT_REVERSE_N32
//#define USE_BIT_REVERSE_N64
//#define USE_BIT_REVERSE_N128
//#define USE_BIT_REVERSE_N256
//#define USE_BIT_REVERSE_N512
//#define USE_BIT_REVERSE_N1024

typedef struct {
	uint16_t first;
	uint16_t second;
} osk_bitreverse_idx_pair_t;

#if defined(USE_BIT_REVERSE_N4)
static const osk_bitreverse_idx_pair_t s_bitReverse0004[] = {
	{    1,    2}
};
#endif


#if defined(USE_BIT_REVERSE_N8)
static const osk_bitreverse_idx_pair_t s_bitReverse0008[] = {
	{    1,    4},	{    3,    6}
};
#endif


#if defined(USE_BIT_REVERSE_N16)
static const osk_bitreverse_idx_pair_t s_bitReverse0016[] = {
	{    1,    8},	{    2,    4},	{    3,   12},	{    5,   10},
	{    7,   14},	{   11,   13}
};
#endif


#if defined(USE_BIT_REVERSE_N32)
static const osk_bitreverse_idx_pair_t s_bitReverse0032[] = {
	{    1,   16},	{    2,    8},	{    3,   24},	{    5,   20},
	{    6,   12},	{    7,   28},	{    9,   18},	{   11,   26},
	{   13,   22},	{   15,   30},	{   19,   25},	{   23,   29}
};
#endif


#if defined(USE_BIT_REVERSE_N64)
static const osk_bitreverse_idx_pair_t s_bitReverse0064[] = {
	{    1,   32},	{    2,   16},	{    3,   48},	{    4,    8},
	{    5,   40},	{    6,   24},	{    7,   56},	{    9,   36},
	{   10,   20},	{   11,   52},	{   13,   44},	{   14,   28},
	{   15,   60},	{   17,   34},	{   19,   50},	{   21,   42},
	{   22,   26},	{   23,   58},	{   25,   38},	{   27,   54},
	{   29,   46},	{   31,   62},	{   35,   49},	{   37,   41},
	{   39,   57},	{   43,   53},	{   47,   61},	{   55,   59}
};
#endif


#if defined(USE_BIT_REVERSE_N128)
static const osk_bitreverse_idx_pair_t s_bitReverse0128[] = {
	{    1,   64},	{    2,   32},	{    3,   96},	{    4,   16},
	{    5,   80},	{    6,   48},	{    7,  112},	{    9,   72},
	{   10,   40},	{   11,  104},	{   12,   24},	{   13,   88},
	{   14,   56},	{   15,  120},	{   17,   68},	{   18,   36},
	{   19,  100},	{   21,   84},	{   22,   52},	{   23,  116},
	{   25,   76},	{   26,   44},	{   27,  108},	{   29,   92},
	{   30,   60},	{   31,  124},	{   33,   66},	{   35,   98},
	{   37,   82},	{   38,   50},	{   39,  114},	{   41,   74},
	{   43,  106},	{   45,   90},	{   46,   58},	{   47,  122},
	{   49,   70},	{   51,  102},	{   53,   86},	{   55,  118},
	{   57,   78},	{   59,  110},	{   61,   94},	{   63,  126},
	{   67,   97},	{   69,   81},	{   71,  113},	{   75,  105},
	{   77,   89},	{   79,  121},	{   83,  101},	{   87,  117},
	{   91,  109},	{   95,  125},	{  103,  115},	{  111,  123}
};
#endif


#if defined(USE_BIT_REVERSE_N256)
static const osk_bitreverse_idx_pair_t s_bitReverse0256[] = {
	{    1,  128},	{    2,   64},	{    3,  192},	{    4,   32},
	{    5,  160},	{    6,   96},	{    7,  224},	{    8,   16},
	{    9,  144},	{   10,   80},	{   11,  208},	{   12,   48},
	{   13,  176},	{   14,  112},	{   15,  240},	{   17,  136},
	{   18,   72},	{   19,  200},	{   20,   40},	{   21,  168},
	{   22,  104},	{   23,  232},	{   25,  152},	{   26,   88},
	{   27,  216},	{   28,   56},	{   29,  184},	{   30,  120},
	{   31,  248},	{   33,  132},	{   34,   68},	{   35,  196},
	{   37,  164},	{   38,  100},	{   39,  228},	{   41,  148},
	{   42,   84},	{   43,  212},	{   44,   52},	{   45,  180},
	{   46,  116},	{   47,  244},	{   49,  140},	{   50,   76},
	{   51,  204},	{   53,  172},	{   54,  108},	{   55,  236},
	{   57,  156},	{   58,   92},	{   59,  220},	{   61,  188},
	{   62,  124},	{   63,  252},	{   65,  130},	{   67,  194},
	{   69,  162},	{   70,   98},	{   71,  226},	{   73,  146},
	{   74,   82},	{   75,  210},	{   77,  178},	{   78,  114},
	{   79,  242},	{   81,  138},	{   83,  202},	{   85,  170},
	{   86,  106},	{   87,  234},	{   89,  154},	{   91,  218},
	{   93,  186},	{   94,  122},	{   95,  250},	{   97,  134},
	{   99,  198},	{  101,  166},	{  103,  230},	{  105,  150},
	{  107,  214},	{  109,  182},	{  110,  118},	{  111,  246},
	{  113,  142},	{  115,  206},	{  117,  174},	{  119,  238},
	{  121,  158},	{  123,  222},	{  125,  190},	{  127,  254},
	{  131,  193},	{  133,  161},	{  135,  225},	{  137,  145},
	{  139,  209},	{  141,  177},	{  143,  241},	{  147,  201},
	{  149,  169},	{  151,  233},	{  155,  217},	{  157,  185},
	{  159,  249},	{  163,  197},	{  167,  229},	{  171,  213},
	{  173,  181},	{  175,  245},	{  179,  205},	{  183,  237},
	{  187,  221},	{  191,  253},	{  199,  227},	{  203,  211},
	{  207,  243},	{  215,  235},	{  223,  251},	{  239,  247}
};
#endif


#if defined(USE_BIT_REVERSE_N512)
static const osk_bitreverse_idx_pair_t s_bitReverse0512[] = {
	{    1,  256},	{    2,  128},	{    3,  384},	{    4,   64},
	{    5,  320},	{    6,  192},	{    7,  448},	{    8,   32},
	{    9,  288},	{   10,  160},	{   11,  416},	{   12,   96},
	{   13,  352},	{   14,  224},	{   15,  480},	{   17,  272},
	{   18,  144},	{   19,  400},	{   20,   80},	{   21,  336},
	{   22,  208},	{   23,  464},	{   24,   48},	{   25,  304},
	{   26,  176},	{   27,  432},	{   28,  112},	{   29,  368},
	{   30,  240},	{   31,  496},	{   33,  264},	{   34,  136},
	{   35,  392},	{   36,   72},	{   37,  328},	{   38,  200},
	{   39,  456},	{   41,  296},	{   42,  168},	{   43,  424},
	{   44,  104},	{   45,  360},	{   46,  232},	{   47,  488},
	{   49,  280},	{   50,  152},	{   51,  408},	{   52,   88},
	{   53,  344},	{   54,  216},	{   55,  472},	{   57,  312},
	{   58,  184},	{   59,  440},	{   60,  120},	{   61,  376},
	{   62,  248},	{   63,  504},	{   65,  260},	{   66,  132},
	{   67,  388},	{   69,  324},	{   70,  196},	{   71,  452},
	{   73,  292},	{   74,  164},	{   75,  420},	{   76,  100},
	{   77,  356},	{   78,  228},	{   79,  484},	{   81,  276},
	{   82,  148},	{   83,  404},	{   85,  340},	{   86,  212},
	{   87,  468},	{   89,  308},	{   90,  180},	{   91,  436},
	{   92,  116},	{   93,  372},	{   94,  244},	{   95,  500},
	{   97,  268},	{   98,  140},	{   99,  396},	{  101,  332},
	{  102,  204},	{  103,  460},	{  105,  300},	{  106,  172},
	{  107,  428},	{  109,  364},	{  110,  236},	{  111,  492},
	{  113,  284},	{  114,  156},	{  115,  412},	{  117,  348},
	{  118,  220},	{  119,  476},	{  121,  316},	{  122,  188},
	{  123,  444},	{  125,  380},	{  126,  252},	{  127,  508},
	{  129,  258},	{  131,  386},	{  133,  322},	{  134,  194},
	{  135,  450},	{  137,  290},	{  138,  162},	{  139,  418},
	{  141,  354},	{  142,  226},	{  143,  482},	{  145,  274},
	{  147,  402},	{  149,  338},	{  150,  210},	{  151,  466},
	{  153,  306},	{  154,  178},	{  155,  434},	{  157,  370},
	{  158,  242},	{  159,  498},	{  161,  266},	{  163,  394},
	{  165,  330},	{  166,  202},	{  167,  458},	{  169,  298},
	{  171,  426},	{  173,  362},	{  174,  234},	{  175,  490},
	{  177,  282},	{  179,  410},	{  181,  346},	{  182,  218},
	{  183,  474},	{  185,  314},	{  187,  442},	{  189,  378},
	{  190,  250},	{  191,  506},	{  193,  262},	{  195,  390},
	{  197,  326},	{  199,  454},	{  201,  294},	{  203,  422},
	{  205,  358},	{  206,  230},	{  207,  486},	{  209,  278},
	{  211,  406},	{  213,  342},	{  215,  470},	{  217,  310},
	{  219,  438},	{  221,  374},	{  222,  246},	{  223,  502},
	{  225,  270},	{  227,  398},	{  229,  334},	{  231,  462},
	{  233,  302},	{  235,  430},	{  237,  366},	{  239,  494},
	{  241,  286},	{  243,  414},	{  245,  350},	{  247,  478},
	{  249,  318},	{  251,  446},	{  253,  382},	{  255,  510},
	{  259,  385},	{  261,  321},	{  263,  449},	{  265,  289},
	{  267,  417},	{  269,  353},	{  271,  481},	{  275,  401},
	{  277,  337},	{  279,  465},	{  281,  305},	{  283,  433},
	{  285,  369},	{  287,  497},	{  291,  393},	{  293,  329},
	{  295,  457},	{  299,  425},	{  301,  361},	{  303,  489},
	{  307,  409},	{  309,  345},	{  311,  473},	{  315,  441},
	{  317,  377},	{  319,  505},	{  323,  389},	{  327,  453},
	{  331,  421},	{  333,  357},	{  335,  485},	{  339,  405},
	{  343,  469},	{  347,  437},	{  349,  373},	{  351,  501},
	{  355,  397},	{  359,  461},	{  363,  429},	{  367,  493},
	{  371,  413},	{  375,  477},	{  379,  445},	{  383,  509},
	{  391,  451},	{  395,  419},	{  399,  483},	{  407,  467},
	{  411,  435},	{  415,  499},	{  423,  459},	{  431,  491},
	{  439,  475},	{  447,  507},	{  463,  487},	{  479,  503}
};
#endif


#if defined(USE_BIT_REVERSE_N1024)
static const osk_bitreverse_idx_pair_t s_bitReverse1024[] = {
	{    1,  512},	{    2,  256},	{    3,  768},	{    4,  128},
	{    5,  640},	{    6,  384},	{    7,  896},	{    8,   64},
	{    9,  576},	{   10,  320},	{   11,  832},	{   12,  192},
	{   13,  704},	{   14,  448},	{   15,  960},	{   16,   32},
	{   17,  544},	{   18,  288},	{   19,  800},	{   20,  160},
	{   21,  672},	{   22,  416},	{   23,  928},	{   24,   96},
	{   25,  608},	{   26,  352},	{   27,  864},	{   28,  224},
	{   29,  736},	{   30,  480},	{   31,  992},	{   33,  528},
	{   34,  272},	{   35,  784},	{   36,  144},	{   37,  656},
	{   38,  400},	{   39,  912},	{   40,   80},	{   41,  592},
	{   42,  336},	{   43,  848},	{   44,  208},	{   45,  720},
	{   46,  464},	{   47,  976},	{   49,  560},	{   50,  304},
	{   51,  816},	{   52,  176},	{   53,  688},	{   54,  432},
	{   55,  944},	{   56,  112},	{   57,  624},	{   58,  368},
	{   59,  880},	{   60,  240},	{   61,  752},	{   62,  496},
	{   63, 1008},	{   65,  520},	{   66,  264},	{   67,  776},
	{   68,  136},	{   69,  648},	{   70,  392},	{   71,  904},
	{   73,  584},	{   74,  328},	{   75,  840},	{   76,  200},
	{   77,  712},	{   78,  456},	{   79,  968},	{   81,  552},
	{   82,  296},	{   83,  808},	{   84,  168},	{   85,  680},
	{   86,  424},	{   87,  936},	{   88,  104},	{   89,  616},
	{   90,  360},	{   91,  872},	{   92,  232},	{   93,  744},
	{   94,  488},	{   95, 1000},	{   97,  536},	{   98,  280},
	{   99,  792},	{  100,  152},	{  101,  664},	{  102,  408},
	{  103,  920},	{  105,  600},	{  106,  344},	{  107,  856},
	{  108,  216},	{  109,  728},	{  110,  472},	{  111,  984},
	{  113,  568},	{  114,  312},	{  115,  824},	{  116,  184},
	{  117,  696},	{  118,  440},	{  119,  952},	{  121,  632},
	{  122,  376},	{  123,  888},	{  124,  248},	{  125,  760},
	{  126,  504},	{  127, 1016},	{  129,  516},	{  130,  260},
	{  131,  772},	{  133,  644},	{  134,  388},	{  135,  900},
	{  137,  580},	{  138,  324},	{  139,  836},	{  140,  196},
	{  141,  708},	{  142,  452},	{  143,  964},	{  145,  548},
	{  146,  292},	{  147,  804},	{  148,  164},	{  149,  676},
	{  150,  420},	{  151,  932},	{  153,  612},	{  154,  356},
	{  155,  868},	{  156,  228},	{  157,  740},	{  158,  484},
	{  159,  996},	{  161,  532},	{  162,  276},	{  163,  788},
	{  165,  660},	{  166,  404},	{  167,  916},	{  169,  596},
	{  170,  340},	{  171,  852},	{  172,  212},	{  173,  724},
	{  174,  468},	{  175,  980},	{  177,  564},	{  178,  308},
	{  179,  820},	{  181,  692},	{  182,  436},	{  183,  948},
	{  185,  628},	{  186,  372},	{  187,  884},	{  188,  244},
	{  189,  756},	{  190,  500},	{  191, 1012},	{  193,  524},
	{  194,  268},	{  195,  780},	{  197,  652},	{  198,  396},
	{  199,  908},	{  201,  588},	{  202,  332},	{  203,  844},
	{  205,  716},	{  206,  460},	{  207,  972},	{  209,  556},
	{  210,  300},	{  211,  812},	{  213,  684},	{  214,  428},
	{  215,  940},	{  217,  620},	{  218,  364},	{  219,  876},
	{  220,  236},	{  221,  748},	{  222,  492},	{  223, 1004},
	{  225,  540},	{  226,  284},	{  227,  796},	{  229,  668},
	{  230,  412},	{  231,  924},	{  233,  604},	{  234,  348},
	{  235,  860},	{  237,  732},	{  238,  476},	{  239,  988},
	{  241,  572},	{  242,  316},	{  243,  828},	{  245,  700},
	{  246,  444},	{  247,  956},	{  249,  636},	{  250,  380},
	{  251,  892},	{  253,  764},	{  254,  508},	{  255, 1020},
	{  257,  514},	{  259,  770},	{  261,  642},	{  262,  386},
	{  263,  898},	{  265,  578},	{  266,  322},	{  267,  834},
	{  269,  706},	{  270,  450},	{  271,  962},	{  273,  546},
	{  274,  290},	{  275,  802},	{  277,  674},	{  278,  418},
	{  279,  930},	{  281,  610},	{  282,  354},	{  283,  866},
	{  285,  738},	{  286,  482},	{  287,  994},	{  289,  530},
	{  291,  786},	{  293,  658},	{  294,  402},	{  295,  914},
	{  297,  594},	{  298,  338},	{  299,  850},	{  301,  722},
	{  302,  466},	{  303,  978},	{  305,  562},	{  307,  818},
	{  309,  690},	{  310,  434},	{  311,  946},	{  313,  626},
	{  314,  370},	{  315,  882},	{  317,  754},	{  318,  498},
	{  319, 1010},	{  321,  522},	{  323,  778},	{  325,  650},
	{  326,  394},	{  327,  906},	{  329,  586},	{  331,  842},
	{  333,  714},	{  334,  458},	{  335,  970},	{  337,  554},
	{  339,  810},	{  341,  682},	{  342,  426},	{  343,  938},
	{  345,  618},	{  346,  362},	{  347,  874},	{  349,  746},
	{  350,  490},	{  351, 1002},	{  353,  538},	{  355,  794},
	{  357,  666},	{  358,  410},	{  359,  922},	{  361,  602},
	{  363,  858},	{  365,  730},	{  366,  474},	{  367,  986},
	{  369,  570},	{  371,  826},	{  373,  698},	{  374,  442},
	{  375,  954},	{  377,  634},	{  379,  890},	{  381,  762},
	{  382,  506},	{  383, 1018},	{  385,  518},	{  387,  774},
	{  389,  646},	{  391,  902},	{  393,  582},	{  395,  838},
	{  397,  710},	{  398,  454},	{  399,  966},	{  401,  550},
	{  403,  806},	{  405,  678},	{  406,  422},	{  407,  934},
	{  409,  614},	{  411,  870},	{  413,  742},	{  414,  486},
	{  415,  998},	{  417,  534},	{  419,  790},	{  421,  662},
	{  423,  918},	{  425,  598},	{  427,  854},	{  429,  726},
	{  430,  470},	{  431,  982},	{  433,  566},	{  435,  822},
	{  437,  694},	{  439,  950},	{  441,  630},	{  443,  886},
	{  445,  758},	{  446,  502},	{  447, 1014},	{  449,  526},
	{  451,  782},	{  453,  654},	{  455,  910},	{  457,  590},
	{  459,  846},	{  461,  718},	{  463,  974},	{  465,  558},
	{  467,  814},	{  469,  686},	{  471,  942},	{  473,  622},
	{  475,  878},	{  477,  750},	{  478,  494},	{  479, 1006},
	{  481,  542},	{  483,  798},	{  485,  670},	{  487,  926},
	{  489,  606},	{  491,  862},	{  493,  734},	{  495,  990},
	{  497,  574},	{  499,  830},	{  501,  702},	{  503,  958},
	{  505,  638},	{  507,  894},	{  509,  766},	{  511, 1022},
	{  515,  769},	{  517,  641},	{  519,  897},	{  521,  577},
	{  523,  833},	{  525,  705},	{  527,  961},	{  529,  545},
	{  531,  801},	{  533,  673},	{  535,  929},	{  537,  609},
	{  539,  865},	{  541,  737},	{  543,  993},	{  547,  785},
	{  549,  657},	{  551,  913},	{  553,  593},	{  555,  849},
	{  557,  721},	{  559,  977},	{  563,  817},	{  565,  689},
	{  567,  945},	{  569,  625},	{  571,  881},	{  573,  753},
	{  575, 1009},	{  579,  777},	{  581,  649},	{  583,  905},
	{  587,  841},	{  589,  713},	{  591,  969},	{  595,  809},
	{  597,  681},	{  599,  937},	{  601,  617},	{  603,  873},
	{  605,  745},	{  607, 1001},	{  611,  793},	{  613,  665},
	{  615,  921},	{  619,  857},	{  621,  729},	{  623,  985},
	{  627,  825},	{  629,  697},	{  631,  953},	{  635,  889},
	{  637,  761},	{  639, 1017},	{  643,  773},	{  647,  901},
	{  651,  837},	{  653,  709},	{  655,  965},	{  659,  805},
	{  661,  677},	{  663,  933},	{  667,  869},	{  669,  741},
	{  671,  997},	{  675,  789},	{  679,  917},	{  683,  853},
	{  685,  725},	{  687,  981},	{  691,  821},	{  695,  949},
	{  699,  885},	{  701,  757},	{  703, 1013},	{  707,  781},
	{  711,  909},	{  715,  845},	{  719,  973},	{  723,  813},
	{  727,  941},	{  731,  877},	{  733,  749},	{  735, 1005},
	{  739,  797},	{  743,  925},	{  747,  861},	{  751,  989},
	{  755,  829},	{  759,  957},	{  763,  893},	{  767, 1021},
	{  775,  899},	{  779,  835},	{  783,  963},	{  787,  803},
	{  791,  931},	{  795,  867},	{  799,  995},	{  807,  915},
	{  811,  851},	{  815,  979},	{  823,  947},	{  827,  883},
	{  831, 1011},	{  839,  907},	{  847,  971},	{  855,  939},
	{  859,  875},	{  863, 1003},	{  871,  923},	{  879,  987},
	{  887,  955},	{  895, 1019},	{  911,  967},	{  919,  935},
	{  927,  999},	{  943,  983},	{  959, 1015},	{  991, 1007}
};
#endif


static const osk_bitreverse_idx_pair_t* s_bitReverseTable[] = {
#if defined(USE_BIT_REVERSE_N2)
	s_bitReverse0002,
#else
	NULL,
#endif

#if defined(USE_BIT_REVERSE_N4)
	s_bitReverse0004,
#else
	NULL,
#endif

#if defined(USE_BIT_REVERSE_N8)
	s_bitReverse0008,
#else
	NULL,
#endif

#if defined(USE_BIT_REVERSE_N16)
	s_bitReverse0016,
#else
	NULL,
#endif

#if defined(USE_BIT_REVERSE_N32)
	s_bitReverse0032,
#else
	NULL,
#endif

#if defined(USE_BIT_REVERSE_N64)
	s_bitReverse0064,
#else
	NULL,
#endif

#if defined(USE_BIT_REVERSE_N128)
	s_bitReverse0128,
#else
	NULL,
#endif

#if defined(USE_BIT_REVERSE_N256)
	s_bitReverse0256,
#else
	NULL,
#endif

#if defined(USE_BIT_REVERSE_N512)
	s_bitReverse0512,
#else
	NULL,
#endif

#if defined(USE_BIT_REVERSE_N1024)
	s_bitReverse1024
#else
	NULL
#endif

};

static const uint16_t s_bitReversePairNums[] = {
	   0,    1,    2,    6, 
	  12,   28,   56,  120, 
	 240,  496
};

#endif

