#ifndef SBDBT_h
#define SBDBT_h


#define JoyStick_L1         0x02    //dt[1]
#define JoyStick_L2         0x04    //dt[1]
#define JoyStick_R1         0x08    //dt[1]
#define JoyStick_R2         0x10    //dt[1]

#define JoyStick_SELECT     0x0C    //dt[2]
#define JoyStick_START      0x03    //dt[2]

#define JoyStick_TRIANGLE   0x10    //dt[2]
#define JoyStick_CIRCLE     0x40    //dt[2]
#define JoyStick_CROSS      0x20    //dt[2]
#define JoyStick_SQUARE     0x01    //dt[1]

#define JoyStick_UP         0x01    //dt[2]
#define JoyStick_DOWN       0x02    //dt[2]
#define JoyStick_LEFT       0x08    //dt[2]
#define JoyStick_RIGHT      0x04    //dt[2]


class sbdbt{
 public:
    sbdbt(PinName TX,PinName RX,int baud): ps(TX,RX,baud){};
    void PS3_JOYSTICK();
    int  PS3_L1_bit()            ;//dt[1]
    int  PS3_L2_bit()            ;//dt[1]
    int  PS3_R1_bit()            ;//dt[1]
    int  PS3_R2_bit()            ;//dt[1]
    int  PS3_TRIANGLE_bit()      ;//dt[2]
    int  PS3_CIRCLE_bit()        ;//dt[2]
    int  PS3_CROSS_bit()         ;//dt[2]
    int  PS3_SQUARE_bit()        ;//dt[1
    int  PS3_UP_bit()            ;//dt[2]
    int  PS3_DOWN_bit()          ;//dt[2]
    int  PS3_LEFT_bit()          ;//dt[2]
    int  PS3_RIGHT_bit()         ;//dt[2]
    int dt[8];int JoyStick_dt[4];
    void Data_Show();
    void setup(int sel);
 private:
    Serial ps;
    void get_data();
    void joystick_read();
    int bitread(int value,int bit) ;
    int bitset(int value,int bit)  ;
    int bitclear(int value,int bit);
    int bitwrite(int value,int bit,int bitvalue);
    long map(long x, long in_min, long in_max, long out_min, long out_max);
    int select;
};
#endif