#include<math.h>
#include"mbed.h"
#include"SBDBT.h"
Serial pc(USBTX,USBRX,115200); 
void sbdbt::get_data(){
    for(char i=0;i<8;i++)dt[i] =ps.getc();
}
void sbdbt::setup(int sel){
        select = sel;
    switch(sel){
        case 0:     ps.attach(this,&sbdbt::get_data,Serial::RxIrq);break;
        case 1:     break;
        default:    break;
    }
}
void sbdbt::joystick_read(){
    for(int i=0;i<4;i++)JoyStick_dt[i] = map(dt[i + 3],0,255,127,-127);    
}

long sbdbt::map(long x, long in_min, long in_max, long out_min, long out_max)
{
  return (x - in_min) * (out_max - out_min) / (in_max - in_min) + out_min;
}

void sbdbt::PS3_JOYSTICK(){
    if(select == 0){
        joystick_read();
    }else {
        get_data();
        joystick_read();
    }
}

void sbdbt::Data_Show(){
    pc.printf("L1:%d L2:%d R1:%d R2:%d ",PS3_L1_bit(),PS3_L2_bit(),PS3_R1_bit(),PS3_R2_bit());
    pc.printf("CIR:%d CRO:%d TRI:%d SQU:%d ",PS3_CIRCLE_bit(),PS3_CROSS_bit(),PS3_TRIANGLE_bit(),PS3_SQUARE_bit());
    pc.printf("U:%d R:%d D:%d L:%d ",PS3_UP_bit(),PS3_RIGHT_bit(),PS3_DOWN_bit(),PS3_LEFT_bit());
    pc.printf("%d %d %d %d\n",JoyStick_dt[0],JoyStick_dt[1],JoyStick_dt[2],JoyStick_dt[3]);
}
int sbdbt::bitread(int value,int bit)           {return(((value) >> (bit)) & 0x01);}
int sbdbt::bitset(int value,int bit)            {return((value) |= (1UL << (bit)));}
int sbdbt::bitclear(int value,int bit)          {return((value) &= ~(1UL << (bit)));}
int sbdbt::bitwrite(int value,int bit,int bitvalue) {return(bitvalue ? bitset(value,bit) : bitclear(value,bit));}

int  sbdbt::PS3_L1_bit()            {return bitread(dt[1],1);} //dt[1]
int  sbdbt::PS3_L2_bit()            {return bitread(dt[1],2);} //dt[1]
int  sbdbt::PS3_R1_bit()            {return bitread(dt[1],3);} //dt[1]
int  sbdbt::PS3_R2_bit()            {return bitread(dt[1],4);} //dt[1]
int  sbdbt::PS3_TRIANGLE_bit()      {return bitread(dt[2],4);} //dt[2]
int  sbdbt::PS3_CIRCLE_bit()        {return bitread(dt[2],6);} //dt[2]
int  sbdbt::PS3_CROSS_bit()         {return bitread(dt[2],5);} //dt[2]
int  sbdbt::PS3_SQUARE_bit()        {return bitread(dt[1],0);} //dt[1]
int  sbdbt::PS3_UP_bit()            {return bitread(dt[2],0);} //dt[2]
int  sbdbt::PS3_DOWN_bit()          {return bitread(dt[2],1);} //dt[2]
int  sbdbt::PS3_LEFT_bit()          {return bitread(dt[2],2);} //dt[2]
int  sbdbt::PS3_RIGHT_bit()         {return bitread(dt[2],3);} //dt[2]