#include "mbed.h"
#include "math.h"
#include "SBDBT.h"
#define P_OFFSET 10
#define M_OFFSET -10
#define MOTOR_OFFSET 0.0f
sbdbt sb(D1,D0,115200);
PwmOut MotorR_SPD(D3);  PwmOut MotorL_SPD(D4);
PwmOut Motor_R(D5);     PwmOut Motor_L(D6);
DigitalOut MotorR_A(D7);   DigitalOut MotorR_B(D8);
DigitalOut MotorL_A(D9);   DigitalOut MotorL_B(D10);
DigitalOut Motor_R_A(D11); DigitalOut Motor_R_B(D12);
DigitalOut Motor_L_A(D13); DigitalOut Motor_L_B(A0);
DigitalOut Debug_LED(A2);
void move_Motor_R(){
    if(sb.JoyStick_dt[3] > P_OFFSET){
        MotorR_A = 1; MotorR_B = 0;
    }else if(sb.JoyStick_dt[3] < M_OFFSET){
        MotorR_A = 0; MotorR_B = 1;
    }else{
        MotorR_A = 0; MotorR_B = 0;
    }    
    MotorR_SPD = abs(sb.JoyStick_dt[3])/128.0 + MOTOR_OFFSET;
}
void move_Motor_L(){
    if(sb.JoyStick_dt[1] > P_OFFSET){
        MotorL_A = 1; MotorL_B = 0;
    }else if(sb.JoyStick_dt[1] < M_OFFSET){
        MotorL_A = 0; MotorL_B = 1;
    }else{
        MotorL_A = 0; MotorL_B = 0;
    }
    MotorL_SPD = abs(sb.JoyStick_dt[1])/128.0 + MOTOR_OFFSET;
}
void Front_Motor(){
    if(sb.PS3_L1_bit()){
        Motor_R_A = 0; Motor_R_B = 1;
        Motor_L_A = 0; Motor_L_B = 1;
        Motor_R = 0.8f; Motor_L = 0.8f;
    }else if(sb.PS3_L2_bit()){
        Motor_R_A = 1; Motor_R_B = 0;
        Motor_L_A = 1; Motor_L_B = 0;
        Motor_R = 0.8f; Motor_L = 0.8f;
    }else {
        Motor_R_A = 0; Motor_R_B = 0;
        Motor_L_A = 0; Motor_L_B = 0;
        Motor_R = 0.0f; Motor_L = 0.0f;
    }
}
void setup(){
    sb.setup(0);
    MotorR_SPD.period(0.00010);
    MotorL_SPD.period(0.00010);
    Debug_LED = 1;
}
int main(){
    setup();
    while(1){
        Debug_LED = ~Debug_LED;
        move_Motor_R();    
        move_Motor_L();
        Front_Motor();
        wait_ms(10);
    }
}