#include "mbed.h"
 
PwmOut left(D5);
PwmOut right(D6);

void init_pwm();
void stop();
void forward(float speed);
void backward(float speed);
void turn_left_forward(float speed);
void turn_right_forward(float speed);
void turn_right_backward(float speed);
void turn_left_backward(float speed);
void rotate_left(float speed);
void rotate_right(float speed);
 
int main() {
    
    init_pwm();
    
    wait_ms(100);
    
            forward(50);
            wait(1);
            stop();
            wait(1);
            turn_left_forward(50);
            wait(1);
            stop();
            wait(1);
            turn_right_backward(50);
            wait(1);
            stop();
            wait(1);
            backward(50);
            wait(1);
            stop();
            wait(1);
            rotate_right(50);
            wait(1);
            stop();
            
            
        
}

void init_pwm(){
    
    //frequency set to 10kHz for both motors
    left.period(0.0001f);
    right.period(0.0001f);
    //stall the motors
    left.write(0.5f); 
    right.write(0.5f); 
    }
    
void forward(float speed){
        left.write(0.5f + speed/1000);
        right.write(0.5f + speed/1000);
    }
    
void backward(float speed){
        left.write(0.5f - speed/1000);
        right.write(0.5f - speed/1000);
    }

void turn_left_forward(float speed){
        left.write(0.5f);
        right.write(0.5f + speed/1000);
    }
    
void turn_right_forward(float speed){
        left.write(0.5f + speed/1000);
        right.write(0.5f);
    }
    
void turn_right_backward(float speed){
        left.write(0.5f - speed/1000);
        right.write(0.5f);
    }

void turn_left_backward(float speed){
        left.write(0.5f);
        right.write(0.5f - speed/1000);
    }
    
void rotate_left(float speed){
        left.write(0.5f - speed/100);
        right.write(0.5f + speed/1000);
    }

void rotate_right(float speed){
        left.write(0.5f - speed/100);
        right.write(0.5f + speed/1000);
    }

void stop(){
        left.write(0.5f);
        right.write(0.5f);
    }