//////////////////////////////////////////////////////////
//Nest Egg Inc.                                         //
//Wi-Fi TANK with Air conditioner                       //
//                                                      //
//SD card module must be Normal chip select mode.       //
//Do not use wwChipSelect.cpp & wwChipSelect.h          //
//White Wizard Chip Select setting must be              //
//invalidated.                                          //
//////////////////////////////////////////////////////////

#include "mbed.h"
#include "EthernetNetIf.h"
#include "HTTPServer.h"
#include "RPCFunction.h"

#include "string.h"
#include "stdio.h"

//SD-----------------------
#include "SDFileSystem.h"

//semaphore----------------
#include "Semaphore.h"

#define SDch        0x05
#define MAXdatanum  500
#define TimeLimit   3000
#define pul38khz       26
#define pul38k_ON      13
#define pul38k_OFF     26

#define test 1

//semaphore----------------
Semaphore sem;
volatile char shared_resource = 'a';   // This is a shared resource for example.
#define LOCK() sem.try_enter()
#define UNLOCK() sem.release()

//prototype
void send_pulse(int, int);

SDFileSystem sd(p5, p6, p7, p8, "sd");
//-------------------------

//IR-----------------------
PwmOut Pulse_pin(p25);
//-------------------------

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

DigitalOut motor1(p21);
DigitalOut motor2(p22);
DigitalOut motor3(p23);
DigitalOut motor4(p24);

AnalogIn ad19(p19);
AnalogIn ad20(p20);

#if 1
/*
 * Use DHCP
 */
        EthernetNetIf ethif;
#else
/*
 * Use "static IP address" (Parameters:IP, Subnet mask, Gateway, DNS)
 */
        EthernetNetIf ethif(IpAddr(xxx,xxx,xxx,xxx), IpAddr(xxx,xxx,xxx,xxx), IpAddr(xxx,xxx,xxx,xxx), IpAddr(xxx,xxx,xxx,xxx));
#endif
    
    HTTPServer server;
    LocalFileSystem local("local");
    void MotorSig(char *input,char *output);
    void ReadStatus(char *input,char *output);
    RPCFunction rpcFunc(&MotorSig, "MotorSig");
    RPCFunction readrpcFunc(&ReadStatus, "ReadStatus");

int main(void) {
    //Base::add_rpc_class<DigitalOut>();
    //Base::add_rpc_class<AnalogIn>();

    if (ethif.setup()) {
        error("Ethernet setup failed.");
        return 1;
    }
    
    IpAddr ethIp=ethif.getIp();
    
    led1=1;
    wait(1);
    server.addHandler<SimpleHandler>("/hello");
    server.addHandler<RPCHandler>("/rpc");
    FSHandler::mount("/local", "/");
    server.addHandler<FSHandler>("/");
    server.bind(80);
    while (1) {
        Net::poll();
    }

}


void MotorSig(char *input , char *output)
{
    //for data-----------------------
    int     IRdata[MAXdatanum];
    int     pulsetime[MAXdatanum];
    int     j = 0;
    int     datanum = 0;
    int     pHL = 0;    
    int     t = 0; 
//    FILE    *fp1;
    
    //text---------------------------
    int length = 0;
    char *str;
    char *str1;
    char str2[30] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
    char str3[30] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
    
    //get input data length
    for (length = 0; input[length] != '\0'; length++);
    
    //check data
    printf("length = %d : input = %s\n", length, input);
    
    //check period of extension
    if((length > 4)&&(input[length-4] == '.')){
        //data
        //printf("data mode start\n");
        
        //read file from micro SD card
        str1 = "/sd/";
        //printf("%s\n",str1);
        for(j = 0; j < length; j++){
            //printf("j=%d  input[%d] = %c\n",j,j,input[j]);
            str2[j] = input[j];
        }
        
       // printf("str1 = %s\n",str1);
        //printf("str2 = %s\n",str2);
        
        strcpy(str3, str1);
        //printf("strcpy = %s\n",str3);
        
        strcat(str3, str2);
        //printf("strcat = %s\n",str3);
        
        for (length = 0; (str3[length] != '\0'); length++);
        
        FILE *fp1 = fopen(str3, "r");
        //FILE *fp1 = fopen("/sd/off.csv", "r");
        
        if(fp1 == NULL){
            printf("can not open data file!\n");
            
        }else{
            printf("loading %s ...\n",str3);
            datanum = 0;           
        
            fscanf(fp1, "%d\n",&datanum);    //read from SD
            printf("datanum, %d\n",datanum);
            
            Pulse_pin.period_us(pul38khz);
            
            j=0;
            for(j=0;j<datanum;++j){
                 fscanf(fp1, "%d,%d,\n", &pHL, &t);
                 IRdata[j] = pHL;
                 pulsetime[j] = t;
            }
            
            
            fclose(fp1);
            printf("close fp1\n");
            
            j=0;
            if (LOCK()) {
                for(j=0;j<datanum;++j){
                    send_pulse(IRdata[j],pulsetime[j]);
                }
                UNLOCK();
                printf("WW sent IR data!\n");
            }
                
                Pulse_pin.pulsewidth(pul38k_OFF);
        }
        
    }else{
        //controller
        printf("controller mode start\n");
    
        str = "forward";
        if (strcmp(input,str) == 0){
            //printf("input OK!\n");
            motor1 = 0;
            motor2 = 1;
            motor3 = 1;
            motor4 = 0;
                
            led1 = 0;
            led2 = 1;
            led3 = 1;
            led4 = 0;
        }
        
        str = "stop";
        if (strcmp(input,str) == 0){
            //printf("input OK!\n");
            motor1 = 0;
            motor2 = 0;
            motor3 = 0;
            motor4 = 0;
                
            led1 = 0;
            led2 = 0;
            led3 = 0;
            led4 = 0;
        }
        
        str = "back";
        if (strcmp(input,str) == 0){
            //printf("input OK!\n");
            motor1 = 1;
            motor2 = 0;
            motor3 = 0;
            motor4 = 1;
                
            led1 = 1;
            led2 = 0;
            led3 = 0;
            led4 = 1;
        }
        
        str = "right";
        if (strcmp(input,str) == 0){
            //printf("input OK!\n");
            motor1 = 0;
            motor2 = 1;
            motor3 = 0;
            motor4 = 1;
                
            led1 = 0;
            led2 = 1;
            led3 = 0;
            led4 = 1;
        }
        
        str = "left";
        if (strcmp(input,str) == 0){
            //printf("input OK!\n");
            motor1 = 1;
            motor2 = 0;
            motor3 = 1;
            motor4 = 0;
                
            led1 = 1;
            led2 = 0;
            led3 = 1;
            led4 = 0;
        }
    }
    //-------------------------------
}

void ReadStatus(char * input, char * output){

    float   ADdata19,ADdata20,temp,humid;
    char    str[30] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
    
    ADdata19 = ad19.read()*3.3;
    ADdata20 = ad20.read()*3.3;
    
    temp = 100*(ADdata20-0.5);       //temp
    humid = (80.0/1.3)*(ADdata19-0.6);    //humid
    
    sprintf( str, "T : %.1f <br>  H : %.1f", temp, humid);
    sprintf(output, str);
}

void send_pulse(int pHL, int t){

    int k = 0;
    
    if(pHL == 0){
        //38kHz pulse on
        Pulse_pin.pulsewidth_us(pul38k_ON);
        
    }else if(pHL == 1){
        //38kHz pulse off
        Pulse_pin.pulsewidth(pul38k_OFF);
        
    }else{
        Pulse_pin.pulsewidth(pul38k_OFF);
        printf("\n\n-----Data format is incorrect!!-----\n pHL = %d, t = %d \n", pHL, t);
        
    }
        for(k = 0; k < t; ++k){
            wait_us(50);
        }
}


