//  Copyright (C) 2010 Robert M. Bouwens

#ifndef _SEMAPHORE_H_
#define _SEMAPHORE_H_

/*
 * http://mbed.org/forum/mbed/topic/181/#comment-799
 */

class Semaphore {
public:
    Semaphore(): s(SemFree) {};

    bool try_enter() {
        int oldval = __ldrex(&s);
        if (oldval == SemTaken) {
            __clrex();
            return false;
        }
        s = SemTaken;
        __clrex();
        return SemTaken == s;
    };

    void release() {
        s = SemFree;
    };

private:
    enum { SemFree = 1, SemTaken = 2 };
    volatile int s;
};

#endif