#include "mbed.h"
#include "EthernetNetIf.h"
#include "HTTPServer.h"
#include "RPCFunction.h"

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

DigitalOut motor1(p21);
DigitalOut motor2(p22);
DigitalOut motor3(p23);
DigitalOut motor4(p24);

#if 1
/*
 * Use DHCP
 */
        EthernetNetIf ethif;
#else
/*
 * Use "static IP address" (Parameters:IP, Subnet mask, Gateway, DNS)
 */
        EthernetNetIf ethif(IpAddr(xxx,xxx,xxx,xxx), IpAddr(xxx,xxx,xxx,xxx), IpAddr(xxx,xxx,xxx,xxx), IpAddr(xxx,xxx,xxx,xxx));
#endif
    
    HTTPServer server;
    LocalFileSystem local("local");
    void MotorSig(char *input,char *output);
    RPCFunction rpcFunc(&MotorSig, "MotorSig");

int main(void) {

    Base::add_rpc_class<DigitalOut>();


    if (ethif.setup()) {
        error("Ethernet setup failed.");
        return 1;
    }
    IpAddr ethIp=ethif.getIp();
    
    led1=1;
    wait(1);
    server.addHandler<SimpleHandler>("/hello");
    server.addHandler<RPCHandler>("/rpc");
    FSHandler::mount("/local", "/");
    server.addHandler<FSHandler>("/");
    server.bind(80);
    while (1) {
        Net::poll();
    }
    return 0;
}


void MotorSig(char *input , char *output)
{

    //text---------------------------
    int length = 0;
    char str[] = "abcd";
    
    //get input data length
	for (length = 0; input[length] != '\0'; length++);
	
	//check data
	printf("length = %d : input = %s\n", length, input);
	
	if (strcmp(input,str) == 0){
	    printf("input OK!\n");
	}
    //-------------------------------
	
	led1=!led1;
    if(*input == 'a'){
        led2 =! led2;
    }
    if(*input == 'F'){
        led3 =! led3;
    }
    
    
    switch(*input){
        case 'F':
            motor1 = 0;
            motor2 = 1;
            motor3 = 1;
            motor4 = 0;
            
            led1 = 0;
            led2 = 1;
            led3 = 1;
            led4 = 0;
            break;
            
        case 'L':
            motor1 = 1;
            motor2 = 0;
            motor3 = 1;
            motor4 = 0;
            
            led1 = 1;
            led2 = 0;
            led3 = 1;
            led4 = 0;
            break;
            
        case 'R':
            motor1 = 0;
            motor2 = 1;
            motor3 = 0;
            motor4 = 1;
            
            led1 = 0;
            led2 = 1;
            led3 = 0;
            led4 = 1;
            break;
            
        case 'B':
            motor1 = 1;
            motor2 = 0;
            motor3 = 0;
            motor4 = 1;
            
            led1 = 1;
            led2 = 0;
            led3 = 0;
            led4 = 1;
            break;
                   
        case 'S':
            motor1 = 0;
            motor2 = 0;
            motor3 = 0;
            motor4 = 0;
            
            led1 = 0;
            led2 = 0;
            led3 = 0;
            led4 = 0;
            break;
            
            
    }
}

