//Nest Egg Inc.
//http://nestegg.jp/
//White Wizard Board SPI Chip Select Code
//Auther : Yoshinari kou
//2010/10/03

#include "wwChipSelect.h"
//#define NORMAL    //if you want to use normal chipselect, you should enable this code.

wwChipSelect :: wwChipSelect(PinName cs):
 ChipSelect(cs){
 }
 
void wwChipSelect :: wwCSwrite(int ch){

#ifdef NORMAL
    if(ch == 0){//reset code
        ChipSelect.write(1);
    }else{
        ChipSelect.write(0);
    }
    
#else
    //start
    ChipSelect.write(1);   
    wait_us(20); 
    
    ChipSelect.write(0);
        
    wait_us(26);//26
    
//A1
    ChipSelect.write(0x01 & ch);    
    wait_us(20);//46  
    
//A2    
    ChipSelect.write((0x02 & ch)>>1);
    wait_us(20);//66  
    
//A3    
    ChipSelect.write((0x04 & ch)>>2);
    wait_us(20);//86 
    
//A4    
    ChipSelect.write((0x08 & ch)>>3);
    wait_us(20);//106
    
    ChipSelect.write(1);
#endif
}

