//////////////////////////////////////
// White Wizard Board (PAT.PEND)    //
// Send IR data from microSD card.  //
//                                  //
// Nest Egg Inc. 2011/7/9           //
//                                  //
//////////////////////////////////////
#include "mbed.h"
#include "SDFileSystem.h"

#define SDch        0x05
#define MAXdatanum  1000
#define TimeLimit   3000
#define pul38khz       26
#define pul38k_ON      13
#define pul38k_OFF     26

//for ifdef
//#define TEST 1
//#define SEND 1
//#define SAVE 1

//prototype
void send_pulse(int, int);

SDFileSystem sd(p5, p6, p7, p8, "sd");

DigitalOut myled1(LED1);
DigitalOut myled2(LED2);
DigitalOut myled3(LED3);
DigitalOut myled4(LED4);

PwmOut Pulse_pin(p25);

int trigger = 0;
int saved = 0;

int main(){
    int     IRdata[MAXdatanum];
    int     pulsetime[MAXdatanum];
    int     j = 0;
    int     datanum = 0;
    
    myled1 = 0;
    myled2 = 0;
    myled3 = 0;
    myled4 = 0;
    
    myled1 = 1;
    
    sd.SetCh(SDch);    //channel No 0101(=0x05), depend on your SPI module setting. (1:High 0:Low)
    printf("again\n");
    int pHL = 0;    
    int t = 0; 
    FILE *fp1 = fopen("/sd/IRDATA.csv", "r");
    //FILE *fp1 = fopen("/sd/off.csv", "r");
    
    datanum = 0;
    
    fscanf(fp1, "%d\n",&datanum);    //read from SD
    printf("datanum, %d\n",datanum);
    myled2 = 1;
    
    Pulse_pin.period_us(pul38khz);
    
    j=0;
    for(j=0;j<datanum;++j){
         fscanf(fp1, "%d,%d,\n",&pHL, &t);
         //printf("%d : %d,%d,\n",j,pHL, t);
         IRdata[j] = pHL;
         pulsetime[j] = t;
    }
    
    myled3 = 1;
    
    for(j=0;j<datanum;++j){
        send_pulse(IRdata[j],pulsetime[j]);
    }
    
    Pulse_pin.pulsewidth(pul38k_OFF);
    fclose(fp1);
    myled4 = 1;
    printf("close fp1\n");    
}


void send_pulse(int pHL, int t){

    int k = 0;
    
    if(pHL == 0){
        //38kHz pulse on
        Pulse_pin.pulsewidth_us(pul38k_ON);
        
    }else if(pHL == 1){
        //38kHz pulse off
        Pulse_pin.pulsewidth(pul38k_OFF);
        
    }else{
        Pulse_pin.pulsewidth(pul38k_OFF);
        printf("\n\n-----Data format is incorrect!!-----\n pHL = %d, t = %d \n", pHL, t);
        
    }
        for(k = 0; k < t; ++k){
            wait_us(50);
        }
}

