//////////////////////////////////////
// White Wizard Board (PAT.PEND)    //
// Save IR data to microSD card.    //
//                                  //
// Nest Egg Inc. 2011/7/9           //
//                                  //
//////////////////////////////////////
#include "mbed.h"
#include "SDFileSystem.h"

#define SDch        0x05
#define MAXdatanum  1000
#define TimeLimit   3000
#define pul38khz       0.0263
#define pul38k_ON      0.0131
#define pul38k_OFF     0.0
//#define TEST 1

//prototype
void SDsave(int[], int[], int);
void send_pulse(int, int);

SDFileSystem sd(p5, p6, p7, p8, "sd");

//DigitalIn IR(p9);

InterruptIn IR(p9);

DigitalOut myled1(LED1);
DigitalOut myled2(LED2);
DigitalOut myled3(LED3);
DigitalOut myled4(LED4);

PwmOut Pulse_pin(p21);

int trigger = 0;
int saved = 0;
int datanum = 0;
int i = 0;
int    IRdata[MAXdatanum];
int     pulsetime[MAXdatanum];


void triggerOn() {
    trigger = 1;
    IRdata[i] = 0;
    pulsetime[i]=0;
    
    if(i < MAXdatanum){
        while(IR==0 && pulsetime[i]<=15000){
            ++pulsetime[i];
            wait_us(50);
            
        }
        
        if(pulsetime[i]>=15000){
            printf(" pulsetime[i] >= TimeLimit !\n");
            datanum = i;
            i = MAXdatanum;
        }
        
        ++i;
    }
}


void triggerOff() {
    trigger = 0;
    pulsetime[i]=0;
    IRdata[i] = 1;    
    
    if(i < MAXdatanum){
        while(IR==1 && pulsetime[i]<=15000){
            ++pulsetime[i];
            wait_us(50);
            
        }
        
        if(pulsetime[i]>=15000){
            printf(" pulsetime[i] >= TimeLimit !\n");
            datanum = i;
            i = MAXdatanum;
        }
        
        ++i;
    }
}


int main(){
    //Buffer is 100 pulses.
    //int    IRdata[MAXdatanum];
    //int     pulsetime[MAXdatanum];
    //int     i = 0;
    
    myled1 = 0;
    myled2 = 0;
    myled3 = 0;
    myled4 = 0;
    
    myled1 = 1;
    
    IR.fall(&triggerOn);
    IR.rise(&triggerOff);
    
    printf("start!\n");
    
    while(1){
        IR.fall(&triggerOn);
        IR.rise(&triggerOff);
        
        if(i >= MAXdatanum && i!= (MAXdatanum + 100)){
            printf("Save start!\n");
            SDsave(IRdata, pulsetime,datanum);
            i = MAXdatanum + 100;
            printf("Finish!");
        }
    }
#ifdef TEST

#else
    while(1){
    
        if(trigger == 0 && saved == 0){   //no signal
            ;
        }else if(trigger == 1 && saved == 0){ //"save" start
            //IR.fall(NULL);
            for(i = 0; i < MAXdatanum; ++i){
                pulsetime[i] = 0;   //init
                
                if(IR == 1){
                    //check signal type
                    IRdata[i] = 1;
                    
                    while(IR==1 && pulsetime[i]<=TimeLimit){  //while IR = 1
                        //check time
                        ++pulsetime[i];
                        wait_us(50);    //count by 100 usec
                    }
                
                
                }else{
                    //check signal type
                    IRdata[i] = 0;
                    
                    while(IR==0 && pulsetime[i]<=TimeLimit){  //while IR = 0
                        //check time
                        ++pulsetime[i];
                        wait_us(50);    //count by 100 usec
                        
                    }
                    
                }
                
                datanum = i;
                            
                if( pulsetime[i] >= TimeLimit){
                    printf(" pulsetime[i] >= TimeLimit !\n");
                    i = MAXdatanum;
                }
                
            }
            
            SDsave(IRdata, pulsetime,datanum);   
        }else{
            ;
        }
    }
#endif
    
#ifdef TEST    
    IRdata[0] = 1;
    pulsetime[0] = 555;
    IRdata[1] = 0;
    pulsetime[1] = 777;
    SDsave(IRdata, pulsetime,2);
#endif

    while(1){
    }
    
}

void SDsave(int IRdata1[], int pulsetime1[], int datanum1){

    int j = 0;
    
    //channel No must be A4 A3 A2 A1
    sd.SetCh(SDch);    //channel No 0101(=0x05), depend on your SPI module setting. (1:High 0:Low)
    wait(1);

    printf("Start to save data\n");   
    myled2 = 1;
        
    FILE *fp = fopen("/sd/IRDATA.csv", "w");
    if(fp == NULL) {
        error("Could not open file to write\n");
        myled3 = 1;
    }
    
#ifdef TEST
    fprintf(fp, "%d\n",datanum1);
    fprintf(fp, "%d,%d,\n",IRdata1[0], pulsetime1[0]);
    fprintf(fp, "%d,%d,\n",IRdata1[1], pulsetime1[1]);
#else

    fprintf(fp, "%d\n",datanum1);
    for(j=0;j<datanum1;++j){
        fprintf(fp, "%d,%d,\n",IRdata1[j], pulsetime1[j]);
    }
#endif

    
    fclose(fp);
    saved = 1;
    printf("Saved!\n");
    
    sd.SetCh(0x00);    //not select
    
//#ifdef TEST
    wait(1);
    sd.SetCh(SDch);    //channel No 0101(=0x05), depend on your SPI module setting. (1:High 0:Low)
    printf("again\n");
    int pHL = 0;    
    int t = 0; 
    FILE *fp1 = fopen("/sd/IRDATA.csv", "r");
    
    datanum = 0;
    
    fscanf(fp1, "%d\n",&datanum1);    //read from SD
    printf("datanum, %d\n",datanum1);
    
    for(j=0;j<datanum1;++j){
        fscanf(fp1, "%d,%d,\n", &pHL, &t);    //read from SD
        
        send_pulse(pHL,t);
        
        //printf("ans, %d,%d,\n", pHL, t);
    }
    
    fclose(fp1);
    printf("close fp1\n");
    
//#endif
     
    myled3 = 1;
    myled4 = 1;
}   


void send_pulse(int pHL, int t){

    int k = 0;
    int err = 0;
    
    Pulse_pin.period(pul38khz);
    
    if(pHL == 0){
        //38kHz pulse on
        Pulse_pin.pulsewidth(pul38k_ON);
        
    }else if(pHL == 1){
        //38kHz pulse off
        Pulse_pin.pulsewidth(pul38k_OFF);
        
    }else{
        Pulse_pin.pulsewidth(pul38k_OFF);
        printf("\n\n-----Data format is incorrect!!-----\n pHL = %d, t = %d \n", pHL, t);
        err = 1;
        
    }
    
    if(err == 0){
        for(k = 0; k < t; ++k){
            wait_us(50);
        }
    }
    
}

