/*-----------------------------------------
Nest Egg Inc.
White Wizard Board Android TANK Ver1.0

How to connect?

*Bluetooth module
 from p9 to p16.
(you can select other serial pins)

*Motor Driver Board
 p21 - IN_R1
 p22 - IN_R2
 p23 - IN_L2
 p24 - IN_L1

-----------------------------------------*/

#include "mbed.h"

Serial rn42(p9,p10);
DigitalOut myled(LED1);
DigitalOut myled2(LED2);
DigitalOut myled3(LED3);
DigitalOut myled4(LED4);

PwmOut motorR1(p21);
PwmOut motorR2(p22);
PwmOut motorL2(p23);
PwmOut motorL1(p24);

void read_string(char*);

int main() {
    int i = 0;
    int j = 0;
    char input[255];
    rn42.baud(115200);
    
    motorR1.period(0.003*9);
    motorR2.period(0.003*9);
    motorL2.period(0.003*9);
    motorL1.period(0.003*9);
    
    float flg_width_a = 0.0;
    float flg_width_b = 0.0;
    
    int flg_error;
    
    while (1) {    
    
        i=0;
        flg_error = 0;
        myled2 = 1;
            
        if (rn42.readable()) {
            
            while ((i==0) || ( input[i-1] != 'G')) {
                input[i] = rn42.getc();
                //printf("%c;%d\n",input[i],i);
                ++i;
                myled != myled;
            }
                        
            for(j=0;j<i;++j){
                rn42.putc(input[j]);
            }
            
            //check format L**R**G
            if((input[0]=='L') && (input[3]=='R') && (input[6]=='G')){
                myled2 = 0;
                
                //check speed
                switch(input[2]){
                    case '0':
                        flg_width_a = 0.0;
                        break;
                    case '1':
                        flg_width_a = 0.003;
                        break;
                    case '2':
                        flg_width_a = 0.003*2;
                        break;
                    case '3':
                        flg_width_a = 0.003*3;
                        break;
                    case '4':
                        flg_width_a = 0.003*4;
                        break;
                    case '5':
                        flg_width_a = 0.003*5;
                        break;
                    case '6':
                        flg_width_a = 0.003*6;
                        break;
                    case '7':
                        flg_width_a = 0.003*7;
                        break;
                    case '8':
                        flg_width_a = 0.003*8;
                        break;
                    case '9':
                        flg_width_a = 0.003*9;
                        break;
                    default:
                        flg_error = 1;
                        
                }
                
                
                switch(input[1]){
                    case 'F':
                        motorL2.pulsewidth(flg_width_a);
                        motorL1.pulsewidth(0);
                        break;
                    case 'B':
                        motorL2.pulsewidth(0);
                        motorL1.pulsewidth(flg_width_a);
                        break;
                    default:
                        flg_error = 1;
                        
                }
                
                //check speed
                switch(input[5]){
                    case '0':
                        flg_width_b = 0.0;
                        break;
                    case '1':
                        flg_width_b = 0.003;
                        break;
                    case '2':
                        flg_width_b = 0.003*2;
                        break;
                    case '3':
                        flg_width_b = 0.003*3;
                        break;
                    case '4':
                        flg_width_b = 0.003*4;
                        break;
                    case '5':
                        flg_width_b = 0.003*5;
                        break;
                    case '6':
                        flg_width_b = 0.003*6;
                        break;
                    case '7':
                        flg_width_b = 0.003*7;
                        break;
                    case '8':
                        flg_width_b = 0.003*8;
                        break;
                    case '9':
                        flg_width_b = 0.003*9;
                        break;
                    default:
                        flg_error = 1;
                        
                }
                
                switch(input[4]){
                        
                    case 'F':
                        motorR2.pulsewidth(flg_width_b);
                        motorR1.pulsewidth(0);
                        myled3 = 0;
                        break;
                    case 'B':
                        motorR2.pulsewidth(0);
                        motorR1.pulsewidth(flg_width_b);
                        myled3 = 0;
                        break;
                    default:
                        flg_error = 1;
                        
                }
            }
        }
        
        if(flg_error == 1){
            myled2 = 1;
            motorL2.pulsewidth(0);
            motorL1.pulsewidth(0);
            motorR2.pulsewidth(0);
            motorR1.pulsewidth(0);
            
        }
        //wait(0.05);
        
    }
}