#include "mbed.h"

Serial rn42(p9,p10);
//Serial rn42(p28,p27); // tx, rx
DigitalOut myled1(LED1);
DigitalOut myled2(LED2);
DigitalOut myled3(LED3);
DigitalOut myled4(LED4);

AnalogIn ad(p20);
AnalogOut da(p18);

Ticker flipper;

int AD_now, AD_before;
int ADdata[200];
int i1;
bool flg_save;
bool flg_finish_saving;

int flg_mode;   //trigger mode
int trigger_y;


int flip_counter;

void flip() {
    //printf("flg_save = %d, flg_finish_saving = %d, flg_mode = %c, trigger_y = %d",flg_save, flg_finish_saving, flg_mode, trigger_y);
    //DA out
        //da = (float)flip_counter * 0.01;
        da = sin(((float)flip_counter*4.0 / 180.0) * 3.14)*0.5+0.5;
        ++flip_counter;
        
    if(flip_counter<90){
        ;
    }else{
        flip_counter=0;
    }
    
    //AD comvert
    AD_now = (int)(ad.read()*3300.0);     //return mV
    
    if(flg_save == 1){  //saving mode
        if(i1 < 100){
            flg_finish_saving = 0;
            ADdata[i1] = AD_now;     //return uV
            myled1 = !myled1;
            ++i1;
            //printf("%d\n",i1);
        }else{
            i1 = 0;
            flg_finish_saving = 1;
            flg_save = 0; //break saving mode
            
            //printf("flg_finish_saving = 1");
            myled4 = !myled4;
        }
    }
    
    //check trigger
    //printf("flg_save = %d, flg_finish_saving = %d, flg_mode = %d\n",flg_save,flg_finish_saving,flg_mode);
    if((flg_save == 0)&&(flg_finish_saving == 0)){
        if(flg_mode == 1){    //up
            if((trigger_y > AD_before)&&(trigger_y < AD_now)){
                flg_save = 1;
                myled2 = !myled2;
                ADdata[0] = AD_before; 
                ADdata[1] = AD_now;
                i1 = 2;
               
            }
        }else if(flg_mode == 2){  //down
            if((trigger_y < AD_before)&&(trigger_y > AD_now)){
                flg_save = 1;
                myled2 = !myled2;
                ADdata[0] = AD_before; 
                ADdata[1] = AD_now;
                i1 = 2;
            }
        }else if(flg_mode == 0){ //stop
            //do nothing
        }
    }
    
    //printf("flg_save = %d, flg_finish_saving = %d, flg_mode = %d\n",flg_save,flg_finish_saving,flg_mode);
    
    AD_before = AD_now;
    myled3 = !myled3;
}


int main() {
    //char input[100];
    rn42.baud(115200);
    myled1 = 0;
    myled2 = 0;
        
    int j=0;
    
    flipper.attach_us(&flip, 1000); // the address of the function to be attached (flip) and the interval
    //flipper.attach(&flip, 1);
    printf("start\n");
    
    // echo back characters, toggle the LED
    while (1) {
        if (rn42.readable()) {
           int n = rn42.scanf("T%dV%d", &flg_mode, &trigger_y);
           printf("T%dV%d\n", flg_mode, trigger_y);
           rn42.getc();//These getc() are for stopping scanf().
           rn42.getc();
           //printf("T%dV%d\n", flg_mode, trigger_y);
        }
        
        
        if(flg_finish_saving==1){
            while(j<100){
                if(rn42.writeable()){
                printf("%d,%d\n\r", j,ADdata[j]);
                rn42.printf("%d,\n\r", ADdata[j]);
                ++j;
            
                if(j>=100){
                //flg reset
                    printf("END\n\r");
                    rn42.printf("END\n\r");
                    flg_finish_saving = 0;
                    flg_mode = 0;
                    flg_save = 0;
                    
                    
                    myled1 = 0;
                    myled2 = 0;
                    myled3 = 0;
                    myled4 = 0;
                
                }
                }
            
            }
                
            j = 0;
        }
    }
}
