#include "mbed.h"
#include "TextLCD.h"
#include "HMC6352.h"

HMC6352 compass(p28,p27);
TextLCD lcd(p6, p7, p8, p9, p10, p11, p12);//Connect LCD module from p5 to p12. 
AnalogIn ad_h(p19);
AnalogIn ad_t(p20);

int main() {

    float H_data, T_data;
    float C_data;
    
    lcd.cls();
    lcd.printf("White Wizard");
    
    //Continuous mode, periodic set/reset, 20Hz measurement rate.
    compass.setOpMode(HMC6352_CONTINUOUS, 1, 20);
    
    wait(3);
    
    lcd.cls();
    
    while(1){
        C_data = compass.sample();
        T_data = ad_t.read() * 3.3;
        T_data = 100.0 * (T_data - 0.5);
        
        H_data = ad_h.read() * 3.3;
        H_data = (80.0 / 1.4) * (H_data - 0.6);
        
        lcd.cls();
        lcd.printf("C:%d T:%d H:%d", (int)(C_data/10.0), (int)T_data, (int)H_data);
        wait(1);
      }
}