#include "mbed.h"
#include "rtos.h"
#include "RFM12B/RFM12B.h"
#include "TextLCD/TextLCD.h"

extern "C" void mbed_reset();

TextLCD lcd(p22, p23, p24, p25, p26, p27, p28,TextLCD::LCD16x2); // rs, rw, e, d4-d7

RFM12B rfm12b_sender(p5, p6, p7, p10, p9, LED1); //RFM12B(PinName SDI, PinName SDO, PinName SCK, PinName SEL, PinName IRQ, , PinName IRQ_LED);
RFM12B rfm12b_receiver(p11, p12, p13, p14, p15, LED4); //RFM12B(PinName SDI, PinName SDO, PinName SCK, PinName SEL, PinName IRQ, , PinName IRQ_LED);

DigitalOut rfm12b_sender_led(p21);
DigitalOut rfm12b_receiver_led(p18);

DigitalOut activity_ledOn(LED2);
DigitalOut activity_ledOff(LED3);

Serial pc(USBTX, USBRX);

char send_message[255] = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";

uint8_t KEY[] = "ABCDABCDABCDABCD";

#define ACK_TIME                 15000        //R of ms to wait for an ack (usually between 600ms and 1300ms)
#define CLIENT_MOTEINO_NODE          1
#define CLIENT_MBED_NODE             2

#define SERVER_MOTEINO_NODE         10
#define SERVER_MBED_NODE            11

#define NETWORD_ID                   5 //GROUP / NETWORK ID

#define MBED_TO_MBED                 0
#define MBED_TO_ARDUINO              1
#define ARDUINO_TO_MBED              2

#define TEST_TYPE MBED_TO_MBED

void ReceiverThread(void const *args)
{
    Timer receiverTimer;
    rfm12b_receiver.Initialize(SERVER_MBED_NODE, RF12_433MHZ, NETWORD_ID); //id = 10, band 433, group 5
    rfm12b_receiver.SetEncryptionKey((uint8_t*) KEY);
    rfm12b_receiver.ReceiveStart();

    while (true) {

        if (rfm12b_receiver.ReceiveComplete()) {
            // Do something with received data

            receiverTimer.start();
            printf("RRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRR\nRECEIVER- beginning receiving message\n");
            lcd.locate(0,1);
            lcd.printf("RECEIVER- BRM");

            if (rfm12b_receiver.CRC_Pass()) {

                printf("RECEIVER- Data received from [%d] : ", rfm12b_receiver.GetSender());
                for (int i = 0; i < int(rfm12b_receiver.GetDataLen()); i++) {
                    printf("%c", (rfm12b_receiver.GetData())[i]);
                }
                printf("\n");

                if (rfm12b_receiver.ACKRequested()) {
                    printf("RECEIVER- ACK sent to [%d] \n", rfm12b_receiver.GetSender());
                    rfm12b_receiver.SendACK("ACK sent from mBed server");
                }

            } else {
                printf("RECEIVER- !!! BAD-CRC !!! \n");
            }

            printf("RECEIVER- finishing receiving message (time since start receiving message %d ms, %4.2f s)\nRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRR\n", receiverTimer.read_ms(), receiverTimer.read());
            lcd.locate(0,1);
            lcd.printf("RECEIVER- finishing receiving message");

            receiverTimer.stop();
            receiverTimer.reset();

            rfm12b_receiver_led = 1;
            wait(0.2);
            rfm12b_receiver_led = 0;
        }
    }
}

void SenderThread(void const *args)
{
    Timer ackTimer;
    Timer senderTimer;

    bool requestACK = true;
    rfm12b_sender.Initialize(CLIENT_MBED_NODE, RF12_433MHZ, NETWORD_ID); //id = 2, band 866, group 5
    rfm12b_sender.SetEncryptionKey((uint8_t*) KEY);

    int i = 1;

    while (true) {
        senderTimer.start();

        printf("\n\n\n\n");
        printf("SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS\nSENDER- beginning sending the message\n");

#if TEST_TYPE == MBED_TO_MBED
        rfm12b_sender.SendStart(SERVER_MBED_NODE, send_message, i, requestACK, false);
#elif TEST_TYPE == MBED_TO_ARDUINO
        rfm12b_sender.SendStart(SERVER_MOTEINO_NODE, send_message, i, requestACK, false);
#endif
        if (requestACK) {
            printf("SENDER- Waiting for ACK... after sending message \n");

            ackTimer.start();
            while (ackTimer.read_ms() <= ACK_TIME) {

#if TEST_TYPE == MBED_TO_MBED

                if (rfm12b_sender.ACKReceived(SERVER_MBED_NODE) == true) {
                    printf("SENDER- ACK... received YEAHHHHHHHHH I FEEL GOOD \n");
                    break;
                }

#elif TEST_TYPE == MBED_TO_ARDUINO

                if (rfm12b_sender.ACKReceived(SERVER_MOTEINO_NODE) == true) {
                    printf("SENDER- ACK... received YEAHHHHHHHHH I FEEL GOOD \n");
                    break;
                }
#endif

            }
            printf("SENDER- time since Waiting for ACK... %d ms, %4.2f s \n", ackTimer.read_ms(), ackTimer.read());

        }

        printf("SENDER- finishing sending the message (time since start sending message %d ms, %4.2f s)\nSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS\n \n\n", senderTimer.read_ms(), senderTimer.read());

        senderTimer.stop();
        senderTimer.reset();

        ackTimer.stop();
        ackTimer.reset();

        rfm12b_sender_led = 1;
        wait(0.2);
        rfm12b_sender_led = 0;

        (i >= 60) ? i = 0 : i++;

        wait(20);
    }
}

int main()
{

#if TEST_TYPE == MBED_TO_MBED

    printf("TEST TYPE: MBED_TO_MBED \n");
    Thread b_thread(ReceiverThread);
    printf("Receive thread \n");
    wait(20);
    Thread a_thread(SenderThread);
    printf("Send thread \n");

#elif TEST_TYPE == MBED_TO_ARDUINO

    printf("TEST TYPE: MBED_TO_ARDUINO \n");
    Thread a_thread(SenderThread);
    printf("Send thread \n");

#elif TEST_TYPE == ARDUINO_TO_MBED

    printf("TEST TYPE: MBED_TO_ARDUINO \n");
    Thread b_thread(ReceiverThread);
    printf("Receive thread \n");

#endif

    while (true) {
        activity_ledOn = 1;
        activity_ledOff = 0;
        wait(0.2);
        activity_ledOn = 0;
        activity_ledOff = 1;
        wait(0.2);

        if(pc.readable()) {
            if (pc.getc() == 'r') {
                mbed_reset();
            }

        }
    }
}
