#include "circular_buffer.h"

CircularBuffer::CircularBuffer()
{
    size = gCircularBufferSize_c;
    readIndex = 0;
    writeIndex = 0;
    count = 0;
    MEM_Init();
    buffer = (uint8_t *) MEM_BufferAlloc(size * sizeof(uint8_t));
    if ( NULL == buffer )
    {
        /*if buffer alloc fails stop the program execution*/
        while(1);
    }
}
 
CircularBuffer::CircularBuffer(uint32_t sz)
{
    size = sz;
    readIndex = 0;
    writeIndex = 0;
    count = 0;
    MEM_Init();
    buffer = (uint8_t *) MEM_BufferAlloc(size * sizeof(uint8_t));
    if ( NULL == buffer )
    {
        /*if buffer alloc fails stop the program execution*/
        while(1);
    }
}

CircularBuffer::~CircularBuffer()
{
    size = 0;
    readIndex = 0;
    writeIndex = 0;
    count = 0;
    MEM_BufferFree(buffer);  
}

bufferStatus_t CircularBuffer :: addToBuffer (uint8_t c)
{
    buffer[writeIndex] = c;
    writeIndex++;
    if (writeIndex >= size)
    {
        writeIndex = 0;
    }
    count++;
    if (count >= size)
    {
        return buffer_Full_c;
    }
    return buffer_Ok_c;
}

bufferStatus_t CircularBuffer :: getFromBuffer (uint8_t *c)
{
    if ( 0 == count )
    {
        return buffer_Empty_c;
    }
    (*c) = buffer[readIndex];
    readIndex++;
    if (readIndex >= size)
    {
        readIndex = 0;
    }
    count--;
    return buffer_Ok_c;
}

uint32_t CircularBuffer :: getCount()
{
    return count;
}