/* FXOS8700Q Example Program
 * Copyright (c) 2014-2015 ARM Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "mbed.h"
#include "FXOS8700Q.h"
#include "nRF24L01P.h"
#include <string.h>
#include <stdlib.h>
#include <stdio.h>

/*Pin Declarations*/
Serial pc(USBTX, USBRX);
I2C i2c(PTE25, PTE24);
FXOS8700QAccelerometer acc(i2c, FXOS8700CQ_SLAVE_ADDR1);    // Configured for the FRDM-K64F with onboard sensors
DigitalIn sw3(SW3); //Enable button for sending data

/*RF Module Instantiations*/
nRF24L01P my_nrf24l01p (PTD6,PTD7,PTD5,PTD4,PTB20,PTC18); // mosi, miso, sck, csn, ce, irq

DigitalOut myled1(LED1);
DigitalOut myled2(LED2);

/*Function Prototypes*/
void packetize(int16_t raX, int16_t raY, int16_t raZ, char* buffer);

int main(void)
{
    
#define TRANSFER_SIZE   15

    int16_t raX, raY, raZ;
    
    char buffer[TRANSFER_SIZE];/*first char is sign, the rest are ints*/
    
    my_nrf24l01p.powerUp();
     
    // Display the (default) setup of the nRF24L01+ chip
    pc.printf( "nRF24L01+ Frequency    : %d MHz\r\n",  my_nrf24l01p.getRfFrequency() );
    pc.printf( "nRF24L01+ Output power : %d dBm\r\n",  my_nrf24l01p.getRfOutputPower() );
    pc.printf( "nRF24L01+ Data Rate    : %d kbps\r\n", my_nrf24l01p.getAirDataRate() );
    pc.printf( "nRF24L01+ TX Address   : 0x%010llX\r\n", my_nrf24l01p.getTxAddress() );
    pc.printf( "nRF24L01+ RX Address   : 0x%010llX\r\n", my_nrf24l01p.getRxAddress() );

    /*setting intializations and enable of RF module*/
    my_nrf24l01p.setTransferSize( TRANSFER_SIZE );
    my_nrf24l01p.setReceiveMode();
    my_nrf24l01p.enable();
    
    /*enable accelerometer*/
    acc.enable();

    
    while (true) {
        
        /* get accelerometer data*/
        acc.getX(raX);
        acc.getY(raY);
        acc.getZ(raZ);
                
        /*print data to terminal*/
        printf("ACC: X=%d Y=%d Z=%d \r\n", raX, raY, raZ);
    
        /*packetize data to be sent*/
        packetize(raX,raY,raZ,buffer); 
        
        
        if(!sw3){/*only send data via RF module when sw2 button is held*/
            
            /* Send the transmit buffer via the RF module*/
            my_nrf24l01p.write( NRF24L01P_PIPE_P0, buffer, TRANSFER_SIZE );
         
            pc.printf( "\n\rData has been sent!\n\r");

        }/*end if*/
        
        // Toggle LED1 (to help debug Host -> nRF24L01+ communication)
        myled1 = !myled1;
            
        wait(1);
        
    }/*end while*/
}/*end main*/

void packetize(int16_t raX, int16_t raY, int16_t raZ, char* buffer){
/*Packetize is called upon when a char buffer should be loaded to send
data via RF module. In this particular instance the char buffer "buffer"
holds three signed - four digit numbers, therefore the sign of each of the
three numbers are determined first and loaded to it's corresponding index 
in buffer. Then, the Thousands, Hundreds, Tens and Ones digits are converted 
to ASCII chars by adding the hex ASCII value of 0 to the corresponding digit.*/
    
    
    /*determine sign char for raX,raY,raZ*/ 
        if(raX >= 0){ 
        
            buffer[0] = ' ';
        }
        else{/*raX is negative*/
            
            buffer[0] = '-';
            
            raX = raX * (-1);/*get the absolute value of raX*/
            
        }
        if(raY >= 0){ /*determine sign char*/
        
            buffer[5] = ' ';
        }
        else{/*raY is negative*/
            
            buffer[5] = '-';
            
            raY = raY * (-1);/*get the absolute value of raY*/
            
        }
        if(raZ >= 0){ /*determine sign char*/
        
            buffer[10] = ' ';
        }
        else{/*raZ is negative*/
            
            buffer[10] = '-';
            
            raZ = raZ * (-1);/*get the absolute value of raZ*/
            
        }
        
        /*int to string for raX,raY,raZ*/
        /*raX*/
        buffer[1] = (raX/1000)+'0'; /*thousands char*/
        raX = raX % 1000;
        buffer[2] = (raX/100) + '0';/*hundreds char*/
        raX = raX % 100;
        buffer[3] = (raX/10) + '0'; /*tens char*/
        raX = raX % 10;
        buffer[4] = raX + '0';      /*ones char*/
        
        /*raY*/
        buffer[6] = (raY/1000)+'0'; /*thousands char*/
        raY = raY % 1000;
        buffer[7] = (raY/100) + '0';/*hundreds char*/
        raY = raY % 100;
        buffer[8] = (raY/10) + '0'; /*tens char*/
        raY = raY % 10;
        buffer[9] = raY + '0';      /*ones char*/
        
        /*raZ*/
        buffer[11] = (raZ/1000)+'0'; /*thousands char*/
        raZ = raZ % 1000;
        buffer[12] = (raZ/100) + '0';/*hundreds char*/
        raZ = raZ % 100;
        buffer[13] = (raZ/10) + '0'; /*tens char*/
        raZ = raZ % 10;
        buffer[14] = raZ + '0';      /*ones char*/
        
}/*end packetize()*/