#include "mbed.h"
#include "nRF24L01P.h" /*RF Module*/
#include "M2XStreamClient.h" /*AT&T M2X*/
#include "EthernetInterface.h" /*Ethernet*/
#include <stdlib.h>

/***************              Base Board Code               **********************/
/*     -- All revisions made by Nigel Leitzell for ECE533 final project --       */
/* This code allows for communication between the Mobile Board and Bluetooth App */
/* to the Base Board for Smart Home Automoation. Values logged from sensors will */
/* be collected and sent to the cloud via Ethernet from the Base Board. The Base */
/* Board should allow the user to control aspects of their home (i.e. lighting-  */
/* and air temperature). However, only the Mobile Board or Bluetooth App may be- */
/* used at any one time. Selection of board which assumes control of the Base-   */
/* Board is determined using buttons on the Base Board or the Bluetooth App.     */
/*********************************************************************************/

/*****************************Pin Declarations************************************/
Serial pc(USBTX, USBRX);// tx, rx
nRF24L01P my_nrf24l01p (PTD6,PTD7,PTD5,PTD4,PTB20,PTC18);// mosi, miso, sck, csn, ce, irq
DigitalOut myled1(LED1);
DigitalOut myled2(LED2);
/*********************************************************************************/

/**************************Function Prototypes************************************/
void unpack(int &x,int &y,int &z,char *b); /*unpacketize the buffer*/
void initEthernet(EthernetInterface eth); /*Initialize Ethernet*/
/*********************************************************************************/

/*******************************Globals*******************************************/
/*************** Set Sensor Stream details (AT&T M2X stuff) **********************/
char deviceId[] = "81c5ecb0ac94aad592ad558ead689321"; // Device you want to push to
char streamX[] = "acc_x"; // Stream you want to push to
char streamY[] ="acc_y"; // Stream you want to push to
char streamZ[] ="acc_z"; // Stream you want to push to
char m2xKey[] = "b2c3795c7022a811a3c4de49095b26ec"; // Your M2X API Key or Master API Key
/*********************************************************************************/

int main() {

// The nRF24L01+ supports transfers from 1 to 32 bytes, but Sparkfun's
//  "Nordic Serial Interface Board" (http://www.sparkfun.com/products/9019)
//  only handles 4 byte transfers in the ATMega code.
#define TRANSFER_SIZE   15

    char txData[TRANSFER_SIZE], rxData[TRANSFER_SIZE];
    int txDataCnt = 0;
    int rxDataCnt = 0;
    int x,y,z;
    
    my_nrf24l01p.powerUp();

    //my_nrf24l01p.setRxAddress(00001,5,NRF24L01P_PIPE_P0);
    //my_nrf24l01p.setTxAddress(00001,5);
     
    // Display the (default) setup of the nRF24L01+ chip
    pc.printf( "nRF24L01+ Frequency    : %d MHz\r\n",  my_nrf24l01p.getRfFrequency() );
    pc.printf( "nRF24L01+ Output power : %d dBm\r\n",  my_nrf24l01p.getRfOutputPower() );
    pc.printf( "nRF24L01+ Data Rate    : %d kbps\r\n", my_nrf24l01p.getAirDataRate() );
    pc.printf( "nRF24L01+ TX Address   : 0x%010llX\r\n", my_nrf24l01p.getTxAddress() );
    pc.printf( "nRF24L01+ RX Address   : 0x%010llX\r\n", my_nrf24l01p.getRxAddress() );

    pc.printf( "Type keys to test transfers:\r\n  (transfers are grouped into %d characters)\r\n\n\n", TRANSFER_SIZE );

    my_nrf24l01p.setTransferSize( TRANSFER_SIZE );

    my_nrf24l01p.setReceiveMode();
    my_nrf24l01p.enable();
    
    /* Intialize Ethernet connection*/
    EthernetInterface eth; 
    initEthernet(eth); 
    
    /* Initialize the M2X client */
    Client client;
    M2XStreamClient m2xClient(&client, m2xKey);
    
    while (1) {

        // If we've received anything over the host serial link...
        if ( pc.readable() ) {

            // ...add it to the transmit buffer
            txData[txDataCnt++] = pc.getc();

            pc.printf( "Key press recognized as key count %d\n\r", txDataCnt);
            
            // If the transmit buffer is full
            if ( txDataCnt >= sizeof( txData ) ) {

                pc.printf( "Final key press before TX has been recorded, count is %d..\n\n\r",txDataCnt);
                pc.printf( "Buffer is now full, preparing to send data..\n\r");
                pc.printf( "Contents of txData buffer: ");
                
                /*print the contents of buffer*/
                for(int i=0; i<txDataCnt; i++){ 
                    
                    pc.printf("%c",txData[i]);
                    
                }/*end for*/
                
                
                // Send the transmitbuffer via the nRF24L01+
                my_nrf24l01p.write( NRF24L01P_PIPE_P0, txData, txDataCnt );

                txDataCnt = 0;
                
                pc.printf( "\n\rData has been sent!\n\r");
            }/*end if*/

            // Toggle LED1 (to help debug Host -> nRF24L01+ communication)
            myled1 = !myled1;
            
        }/*end if*/

        // If we've received anything in the nRF24L01+...
        if ( my_nrf24l01p.readable() ) {

            // ...read the data into the receive buffer
            rxDataCnt = my_nrf24l01p.read( NRF24L01P_PIPE_P0, rxData, TRANSFER_SIZE );

            unpack(x,y,z,rxData);//unpack data 
                        
            pc.printf("Integer Representation: X-Axis Acc: %d \t",x);
            pc.printf("Y-Axis Acc: %d\t",y);
            pc.printf("Z-Axis Acc: %d\n\r",z);
            
            
            //Now that data is unpacked.. What to do?
            if(x >= 2000){
                
                pc.printf("Woah, leaning right!\n\r");
            }
            else if(x <= -2000){
                
                pc.printf("Woah, leaning left!\n\r");
                
            }
            else{
                
                pc.printf("Just right.\n\r");
                
            }
            
            //Send data to M2X
            m2xClient.updateStreamValue(deviceId, streamX, x);
            m2xClient.updateStreamValue(deviceId, streamY, y);
            m2xClient.updateStreamValue(deviceId, streamZ, z);
            
            // Display the receive buffer contents via the host serial link
            /*for ( int i = 0; rxDataCnt > 0; rxDataCnt--, i++ ) {
            
                
                if(i == 0){
                    
                    pc.printf("String  Representation: X-axis Acc: ");
                    
                }
                else if(i == 5){
                    
                    pc.printf("\tY-axis Acc: ");
                
                }
                else if(i == 10){
                    
                    pc.printf("\tZ-axis Acc: ");
                    
                }
                    
                pc.putc( rxData[i] );
                
            }//end for*/
            
            
            
            pc.printf("\r\n");
            
            // Toggle LED2 (to help debug nRF24L01+ -> Host communication)
            myled2 = !myled2;
        
        }/*end if*/
    }/*end if*/
}/*end while*/


void unpack(int &x,int &y,int &z,char *b){
/*This function is resposible for unpacketizing a buffer 
that has been transmitted wirelessly by distributing data to variables 
passed by reference appropriately.*/
    
    char buffer[5];/*buffer used to unpack data from packet*/
    
    for(int i = 0; i < TRANSFER_SIZE; i++){
                
        buffer[i%5] = b[i];
                
            
        if(i == 4){/*buffer contains x*/
                 
            x = atoi(buffer);
                
        }
        else if(i == 9){/*buffer contains y*/
                    
            y = atoi(buffer);
                    
        }
        else if(i == 14){/*buffer contains z*/
                    
            z = atoi(buffer);
                    
        }/*end if*/
    }/*end for*/
}/*end unpack()*/

void initEthernet(EthernetInterface eth){
/*This function handles the ethernet initialization upon being passed a
pointer to an EthernetInterface object*/
        
        eth.init();/*initialize DHCP*/
        
        printf("Initialized DHCP! Preparing to connect...\r\n");
        
        eth.connect();/*connect eth to internet*/
        
        printf("Success. Connected!. Device IP Address is %s\r\n", eth.getIPAddress());
    
}/*end initEthernet()*/