/*  Naam:
 *      SPI_4x7LED
 *
 *  Geschreven door: 
 *      Marout Yasuo Sluijter-Borms
 *
 *  Omschrijving:
 *      4 x 7 LED segmentdisplay en 2x 74hc595 schuifregister aansturen op de SPI bus
 *      teller 0 tot 9999
 *
 *  Aanmaakdatum:
 *      5 mei 2016
 *  Laatste update:
 *      7 mei 2016
 *
 *  Revisie:
 *          1 - Ombouwen spi_led_helloworld
 *          2 - Patroongenetator en digit selector geconstrueerd
 *          3 - Inversie van uitgangen
 *            - MSB = DP, LSB = segment A
 * 
 *  Copyright (c) 2016, MYSB, The Manhattan Project
 *  Zie einde programma / See end of program.
 */ 
/*  Libraries en classes insluiten  */
#include "mbed.h"

/*  Definineer macros               */
#define SPI_SPEED       48000000    //  max speed
#define SPI_MOSI        P0_9        //  MOSI: p5 = P0_9
#define SPI_MISO        P0_8        //  MISO: p6 = P0_8
#define SPI_SCLK        P0_7        //  SCLK: p7 = P0_7
#define SPI_MODE        3           //  Mode 3: CPOL = 1, CPHA= 1
#define REGISTER_WIDTH  8           //  8-bit register
#define REGISTER_COUNT  2           //  aantal registers in serie
#define DIGIT_COUNT     4           //  aantal aan te sturen digits
#define SEGMENT_COUNT   7           //  aantal segmenten per digit
#define DP_OUT          0x80        //  register adres decimale punt (MSB = 128 = 0x80)
#define LED_ON_TIME     0.2         //  tijd dat LED aan is

/*  Declareer seriële poorten       */
SPI spi0( SPI_MOSI, SPI_MISO, SPI_SCLK);
                                    //  Definieer SPI bus

/*  Declareer digitale IO           */
DigitalOut ss0( P0_6, 1);           //  p8 = slave select 0, actief LAAG! Dus pin hoog om chip te deselecteren!

/*  Declareer Analoge IO            */
/*  Declareer globale variabelen    */
int spi_data = 0x0000;

/*  Declareer globale constanten    */
const int digit[] = {               //  waarden om digits te selecteren (activeer een uitgang van schuifregister
    0x01,   0x02,                   //  #1, #2
    0x04,   0x08,                   //  #3, #4
    0x10,   0x20,                   //  #5, #6
    0x40,   0x80                    //  #7, #8
    };
const int decimalepunt = 0x80;      //  waarde van de decimale punt (DP = MSB)
const int patroon[] = {             //  patroon om hexadecimaal digit te tonen (LSB a..g MSB-1, actief LAAG)
    0x40,   0x79,   0x24,   0x30,   //  0,  1,  2,  3,
    0x19,   0x12,   0x02,   0x78,   //  4,  5,  6,  7,
    0x00,   0x10,   0x08,   0x03,   //  8,  9,  A,  B,
    0x46,   0x21,   0x06,   0x0E    //  C,  D,  E,  F
    };
const int patroon_aantal = (        //  aantal patronen in patroon
    sizeof( patroon) / 
            sizeof (patroon[0])
    );
    
/*  Declareer functies              */
/*  Start hoofprogramma             */
int main()
{
    //  intellen SPI bus
    spi0.frequency( SPI_SPEED);     //  Snelheid bus instellen
    spi0.format( REGISTER_WIDTH * REGISTER_COUNT, SPI_MODE);
                                    //  SPI mode instellen; 
    
    /*  maak schuifregisters leeg   */
    ss0 = 0;                        //  selecteer chip
    spi0.write( 0);                 //  Schrijf leeg byte naar chip
    ss0 = 1;                        //  deselecteer chip
    wait( LED_ON_TIME);             //  wacht even
    /*  Schijf patroon naar register    */
    while(1) {
        spi_data = 0x0000;
        for( int d = 0; d < DIGIT_COUNT; ++d) {
                                    //  selecteer digit
            for( int v = 0; v < patroon_aantal; ++v) {
                                    //  selekteer segment
                spi_data = digit[d];
                                    //  laad patroon om digit te selecteren
                spi_data <<= 8;     //  schuif digit naar MSB
                spi_data += patroon[v];
                                    //  voeg patroon om segmenten te selecteren toe
// write
                ss0 = 0;            //  selekteer chip
                spi0.write( spi_data);
                                    //  schrijf data naar bus
                ss0 = 1;            //  deselecteer chip
                wait( LED_ON_TIME); //  wacht even
            }   // endfor
        }   //  endfor
    };  //  enwhile
};  //  endmain
/*
 *  Permission is hereby granted, free of charge, to any person obtaining a copy
 *  of this software and associated documentation files (the "Software"), to deal
 *  in the Software without restriction, including without limitation the rights
 *  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 *  copies of the Software, and to permit persons to whom the Software is
 *  furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in
 *  all copies or substantial portions of the Software.
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 *  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 *  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 *  THE SOFTWARE.
 */
