/* 
 * Naam:            PCF8574_ButtonPress
 *
 * Omschrijving:
 *                  I2C testprogramma:
 *                  -Als PCF8574-Knop# ingedrukt: PCF8574-Led# aan
 *                  -Als PCF8574-Knop# losgelaten: PCF8574-Led# uit.
 *
 * Aanmaakdatum:    05 april 2016
 * 
 * Geschreven door: Marout Yasuo Sluijter-Borms
 * 
 * Copyright (c) 2016, MYSB, The Manhattan Project
 * Zie einde programma /  See end of program.
 */ 
 
/*  Libraries en classes insluiten  */
#include "mbed.h"
#include "PCF8574.h"

/*  Definieer seriële poorten       */
Serial pc(USBTX, USBRX);            //  tx, rx communicatie met PC terminal via USB.
PCF8574 pcf0( p9, p10, 0x72);      //  Eerste PCF8574 chip
//PCF8574 pcf1( p28, p37, 0x74);      //  Tweede PCF8574 chip


/*  Definieer digitale IO           */
DigitalOut led(LED2);               //  Led 2 op mbed is signaal 'Initialisatie klaar'.

/*  Definieer Analoge IO            */

/*  Definieer globale variabelen    */
char DataIn;                        //  Data ingelezen van PCF8574
char DataOut;                       //  Data te schrijven naar PCF8574

/*  Definieer globale constanten    */

/*  Definieer functie   */

/*  Start hoofprogramma             */

int main()
{
    while (1)
        {
            DataIn = pcf0.read();       //  lees inputs uit
            DataOut = DataIn >> 4;      //  schuif knoppen naar leds
            DataOut = DataOut + 0xf0;   //  zet leds uit en knoppen uitleesbaar (out = high)
            pcf0.write(DataOut);
        }       //  endwhile
}       //  endmain
/*
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
