/* This program is part of the Interreg MOTION project. It aims at acquiring the data from the 2 feet and to send it to a computer.
All the data are coming through a CAN BUS.
This program is developped using mbed OS 5 (on https://ide.mbed.com/) for the STM32 Nucleo L432KC*/

#include "mbed.h"   
#include "EasyCAT.h"                // EasyCAT library to interface the LAN9252
#include "MPU9250.h"
#include <stdio.h>
#include <cmath>
#include <cstdint>
#include <string> 
#include <Serial.h>    

using namespace std;

void Application (void); 

 
EasyCAT EASYCAT;                    // EasyCAT istantiation

                                    // The constructor allow us to choose the pin used for the EasyCAT SPI chip select 
                                    // Without any parameter pin 9 will be used 
                                                                      
                                    // for EasyCAT board REV_A we can choose between:
                                    // 8, 9, 10 
                                    //  
                                    // for EasyCAT board REV_B we can choose between:
                                    // 8, 9, 10, A5, 6, 7                                    

                                    // example:                                  
//EasyCAT EASYCAT(8);               // pin 8 will be used as SPI chip select
                             
//Variables for the MPU9250 IMU
#define RAD_TO_DEG 180/PI
MPU9250 mpu9250;
char buffer[14];
uint8_t whoami;
float Max[3]={0,0,0};

//Variables used for filtering
int prec_yaw=0; //previous yaw
int prec_pitch=0; //previous pitch
int prec_roll=0; //previous roll
float alpha=0.4; //filtering coefficient

//Variables of the CAN bus
DigitalInOut CANRX(PA_11);
DigitalInOut CANTX(PA_12);
CAN can1(PA_11, PA_12);
CANMessage msg;     
CANMessage msg2;   
int msg_id;
char value[3]; 

//variables for etherCAT
uint8_t SlipTxBuff[60];
uint8_t WrIdx;

int dataL[9]={100,0,0,0,0,0,0,0}; //for the left foot: ID, centerX, centerY, force, yaw, pitch, roll, unused

int dataR[9]={200,0,0,0,0,0,0,0}; //for the right foot: ID, centerX, centerY, force, yaw, pitch, roll, unused

int dataM[9]={300,0,0,0,0,0,0,0}; //for the hip: ID, 0, 0, 0, yaw, pitch, roll, unused

union u_tag {
   int32_t temp_int32 ; 
   uint8_t temp_byte[4] ;
} u;
//---- global variables ---------------------------------------------------------------------------


UWORD ContaUp;                      // used for sawthoot test generation
UWORD ContaDown;                    //

unsigned long Millis = 0;
unsigned long PreviousSaw = 0;
unsigned long PreviousCycle = 0;
int32_t data_Test = 0; // tab to test 
//General variables
Serial pc(PA_2, PA_15); //serial to send data to a computer //RawSerial
string legende[6]={"unused","unused","unused","yaw   ","pitch ","roll  "};
Timer t;

long prec_tps=0;
long prec_tps2=0;
long prec_tps3=0;
int temp=0;
int flag=0;

string msg_pc=" "; //works with mbed os2, add .c_str() for mbed os5

//---- declarations for Arduino "millis()" emulation ----------------------- 

static Ticker uS_Tick;
static volatile uint32_t MillisVal = 0;

void InitMillis(void);    
void mS_Tick(void);
  
inline static uint32_t millis (void) 
{
    return MillisVal; 
};
 
void start_MPU() //This function is use to start the IMU using the MPU9250 library
{
    whoami = mpu9250.readByte(MPU9250_ADDRESS, WHO_AM_I_MPU9250);
    if (whoami == 0x71) // WHO_AM_I should always be 0x71
    {  
        pc.printf("MPU9250 WHO_AM_I is 0x%x\n\r", whoami);
        pc.printf("MPU9250 is online...\n\r");
        sprintf(buffer, "0x%x", whoami);
        thread_sleep_for(1000);
        
        mpu9250.resetMPU9250(); // Reset registers to default in preparation for device calibration
        
        mpu9250.MPU9250SelfTest(SelfTest); // Start by performing self test and reporting values (accelerometer and gyroscope self test)
        pc.printf("x-axis self test: acceleration trim within : %f percent of factory value\n\r", SelfTest[0]);
        pc.printf("y-axis self test: acceleration trim within : %f percent of factory value\n\r", SelfTest[1]);
        pc.printf("z-axis self test: acceleration trim within : %f percent of factory value\n\r", SelfTest[2]);
        pc.printf("x-axis self test: gyration trim within : %f percent of factory value\n\r", SelfTest[3]);
        pc.printf("y-axis self test: gyration trim within : %f percent of factory value\n\r", SelfTest[4]);
        pc.printf("z-axis self test: gyration trim within : %f percent of factory value\n\r", SelfTest[5]);
        
        /*
        mpu9250.calibrateMPU9250(gyroBias, accelBias); // Calibrate gyro and accelerometer, load biases in bias registers  
        pc.printf("x gyro bias = %f\n\r", gyroBias[0]);
        pc.printf("y gyro bias = %f\n\r", gyroBias[1]);
        pc.printf("z gyro bias = %f\n\r", gyroBias[2]);
        pc.printf("x accel bias = %f\n\r", accelBias[0]);
        pc.printf("y accel bias = %f\n\r", accelBias[1]);
        pc.printf("z accel bias = %f\n\r", accelBias[2]);
        thread_sleep_for(2000);//wait(2);
        */
        
        // Initialize device for active mode read of acclerometer, gyroscope, and temperature
        mpu9250.initMPU9250();
        pc.printf("MPU9250 initialized for active data mode....\n\r");
        
        // Initialize device for active mode read of magnetometer, 16 bit resolution, 100Hz.
        mpu9250.initAK8963(magCalibration);
        pc.printf("AK8963 initialized for active data mode....\n\r");
        pc.printf("Accelerometer full-scale range = %f  g\n\r", 2.0f*(float)(1<<Ascale));
        pc.printf("Gyroscope full-scale range = %f  deg/s\n\r", 250.0f*(float)(1<<Gscale));
        if(Mscale == 0) pc.printf("Magnetometer resolution = 14  bits\n\r");
        if(Mscale == 1) pc.printf("Magnetometer resolution = 16  bits\n\r");
        if(Mmode == 2) pc.printf("Magnetometer ODR = 8 Hz\n\r");
        if(Mmode == 6) pc.printf("Magnetometer ODR = 100 Hz\n\r");
        thread_sleep_for(1000);//wait(1);
    }
   
    else // Connection failure
    {
        pc.printf("Could not connect to MPU9250: \n\r");
        pc.printf("%#x \n",  whoami);    
        sprintf(buffer, "WHO_AM_I 0x%x", whoami);
        while(1){} // Loop forever if communication doesn't happen
    }
  
    mpu9250.getAres(); // Get accelerometer sensitivity
    mpu9250.getGres(); // Get gyro sensitivity
    mpu9250.getMres(); // Get magnetometer sensitivity
    pc.printf("Accelerometer sensitivity is %f LSB/g \n\r", 1.0f/aRes);
    pc.printf("Gyroscope sensitivity is %f LSB/deg/s \n\r", 1.0f/gRes);
    pc.printf("Magnetometer sensitivity is %f LSB/G \n\r", 1.0f/mRes);      
    
    magbias[0] = 155;//218;// User environmental x-axis correction in milliGauss, given by the calibration fonction (see in main)
    magbias[1] = -77;//258;// User environmental x-axis correction in milliGauss
    magbias[2] = -87;//13;//// User environmental x-axis correction in milliGauss  
    
}

void getData_MPU() //This function is use to obtain the data from the IMU using the MPU9250 library
{
    // If intPin goes high, all data registers have new data
    if(mpu9250.readByte(MPU9250_ADDRESS, INT_STATUS) & 0x01) 
    {  // On interrupt, check if data ready interrupt
          
        mpu9250.readAccelData(accelCount);  // Read the x/y/z adc values   
        // Now we'll calculate the accleration value into actual g's
        if (I2Cstate != 0) //error on I2C
            pc.printf("I2C error ocurred while reading accelerometer data. I2Cstate = %d \n\r", I2Cstate);
        else{ // I2C read or write ok
            I2Cstate = 1;
            ax = (float)accelCount[0]*aRes - accelBias[0];  // get actual g value, this depends on scale being set
            ay = (float)accelCount[1]*aRes - accelBias[1];
            az = (float)accelCount[2]*aRes - accelBias[2];
        }   
        
        mpu9250.readGyroData(gyroCount);  // Read the x/y/z adc values
        // Calculate the gyro value into actual degrees per second
        if (I2Cstate != 0) //error on I2C
            pc.printf("I2C error ocurred while reading gyrometer data. I2Cstate = %d \n\r", I2Cstate);
        else{ // I2C read or write ok
            I2Cstate = 1;
            gx = (float)gyroCount[0]*gRes - gyroBias[0];  // get actual gyro value, this depends on scale being set
            gy = (float)gyroCount[1]*gRes - gyroBias[1]; 
            gz = (float)gyroCount[2]*gRes - gyroBias[2];
        }
      
        mpu9250.readMagData(magCount);  // Read the x/y/z adc values   
        // Calculate the magnetometer values in milliGauss
        // Include factory calibration per data sheet and user environmental corrections
        if (I2Cstate != 0) //error on I2C
            pc.printf("I2C error ocurred while reading magnetometer data. I2Cstate = %d \n\r", I2Cstate);
        else{ // I2C read or write ok
            I2Cstate = 1;
            mx = (float)magCount[0]*mRes*magCalibration[0] - magbias[0];  // get actual magnetometer value, this depends on scale being set
            my = (float)magCount[1]*mRes*magCalibration[1] - magbias[1];  
            mz = (float)magCount[2]*mRes*magCalibration[2] - magbias[2];
        }      
    }
}

void getOrientation() //This function is use to acquire, calculate, make the data fusion and filter the orientation
{
    getData_MPU();

    ax *=1000;
    ay *=1000;
    az *=1000;
    pitch =  atan(ay/sqrt(pow(ax,2) + pow(az,2)));
    roll = atan(ax/sqrt(pow(ay,2) + pow(az,2)));  //atan(-ax/sqrt(pow(ay,2) + pow(az,2))); 
    float temp=mx;
    mz=-mz;
    mx=my;
    my=temp;
    
    float yh = (my * cos(roll)) - (mz* sin(roll));
    float xh = (mx * cos(pitch))+(my * sin(roll)*sin(pitch)) + (mz * cos(roll) * sin(pitch));
    yaw = atan2(-yh, xh);

    pitch *= RAD_TO_DEG;
    roll *= RAD_TO_DEG;
    yaw *= RAD_TO_DEG;
    
    //low pass - filtering
    pitch=(1-alpha)*(prec_pitch+gx*0.01f)+alpha*pitch;
    roll=(1-alpha)*(prec_roll+gy*0.01f)+alpha*roll;
    yaw=(1-alpha)*(prec_yaw)+alpha*yaw;
    prec_pitch=pitch;
    prec_roll=roll;
    prec_yaw=yaw;
    

    dataM[4]=(int) yaw;
    dataM[5]=(int) pitch;
    dataM[6]=(int) roll;  
   // printf("\nyaw: %d",dataM[4]);
   // printf("\npitch: %d",dataM[5]);
    //printf("\nroll: %d",dataM[6]);
}     

void send_CAN(int flag) { //UNUSED -> This function is use to send data through the CAN bus

    msg_id=300+flag+1;// CAN ID starting from x01 to x06, x being 1 for the left foot, 2 for the right foot and 3 for the hip              
    
    //to send a signed integer of 16 bits through a can bus, it is required to transform it into 3 bytes
    //first is the sign, then the most significant bits and finally the less significant bits
    //hence the array: value[3]
    if(dataM[flag]<0)
    {
        value[0]='-';
    }
    else
    {
        value[0]='+';
    }
    value[1] = abs(dataM[flag])/256;
    value[2] = abs(dataM[flag])%256;
    
    //sending the value through CAN bus
    msg= CANMessage(msg_id,value,3);
    if(can1.write(msg)) 
    
    {
        printf("%s",legende[flag].c_str());
        printf(": %c%i\r\n",value[0],value[1]*256+value[2]);
      
    }
    else
    {
        printf("CAN mailbox is full. \r\n");
    }
}

void send_SERIAL(int device) //UNUSED -> This function is use to send data through the Serial to a computer
{
    char buf[50]; 
    if(device == 1) //sending the data of the left foot
    {
        msg_pc="";
        for(int i=0;i<7;i++)
        {
            sprintf(buf,"%i,",dataL[i]);
            msg_pc+=buf;    
        }
        pc.printf("%s\r\n",msg_pc.c_str()); //sending the data
    }
    else if(device == 2)//sending the data of the right foot
    {
        msg_pc="";
        for(int i=0;i<7;i++)
        {
            sprintf(buf,"%i,",dataR[i]);
            msg_pc+=buf;    
        }
        pc.printf("%s\r\n",msg_pc.c_str()); //sending the data
    }
    else //sending the data of the master
    {
        msg_pc="";
        for(int i=0;i<7;i++)
        {
            sprintf(buf,"%i,",dataM[i]);
            msg_pc+=buf;    
        }
        pc.printf("%s\r\n",msg_pc.c_str()); //sending the data
    }
}
//---------------------------------------------------------------------------------------------
 
int main(void)
{
    pc.baud(115200);
    CANRX.mode(OpenDrain);
    CANTX.mode(OpenDrain);
    //setup of the I2C used by the IMU
    i2c.frequency(400000);  
    start_MPU();
    t.start();
    int flag=0; //for the data to be asked
    char value2[12]={101,102,103,104,105,106,201,202,203,204,205,206}; //CAN ID of the requested data    
    thread_sleep_for(1000); //wait 1s
    pc.printf("Hip is started ! \r\n");  
         
  printf ("\nEasyCAT - Generic EtherCAT slave\n");      // print the banner

  InitMillis();                                         // init Arduino "millis()" emulation                

  ContaDown.Word = 0x0000;
  ContaUp.Word = 0x0000; 
                                                        //---- initialize the EasyCAT board -----
                                                                  
  if (EASYCAT.Init() == true)                           // initialization
  {                                                     // succesfully completed
    printf ("initialized\n");                           //
  }                                                            
  
  else                                                  // initialization failed   
  {                                                     // the EasyCAT board was not recognized
    printf ("initialization failed\n");                 //     
                                                        // The most common reason is that the SPI 
                                                        // chip select choosen on the board doesn't 
                                                        // match the one choosen by the firmware
  }                                                           
   
 
  while (1)                                             //---- main loop ---------------------------
  {      
     if(t.read_us()-prec_tps3>10000.0f) //every 10ms the orientation of the master is updated
            {  
                getOrientation();
                //printf("\n Time %d",(t.read_us()-prec_tps3));
                prec_tps3=t.read_us();
            }                                                       
     if(t.read_us()-prec_tps2>1000.0f) //every 1ms new data is asked
            {  
                msg2= CANMessage(1,&value2[flag],1); //master of adress 1, ask every measure
                if(can1.write(msg2)) 
                {             
                }
                else
                {
                    pc.printf("CAN mailbox is full. \r\n");
                }
                flag++;
                if(flag>=12){flag=0;}
                
                prec_tps2=t.read_us();
            }
            
    
            if (can1.read(msg)) //if a CAN message is received in a package format: sign, most significant byte, less significant byte
            {
                int value=0;
                if(msg.data[0]=='-')
                {
                    value=-(msg.data[1]*256+msg.data[2]);
                }
                else
                {
                    value=msg.data[1]*256+msg.data[2];
                }
                
                switch(msg.id/100) //update the data array depending on the received ID
                {
                    case 1: //for the left foot
                    {
                        temp=msg.id%100;
                        dataL[temp]=value;
                        break;
                    }
                    
                    case 2: //for the right foot
                    {
                        temp=msg.id%200;
                        dataR[temp]=value;
                        break;
                    } 
                }
            }





                                                        // Instead we can also use millis() to set the cycle time  
                                                        //  
                                                        // example:
    Millis = millis();                                  //
    if (Millis - PreviousCycle >= 10)                   // each 10 mS   
    {                                                   // 
      PreviousCycle = Millis;                           //
    
      EASYCAT.MainTask();                               // execute the EasyCAT task
      
      EASYCAT.BufferIn.Cust.centerXL = dataL[1];

      EASYCAT.BufferIn.Cust.centerYL = dataL[2];

      EASYCAT.BufferIn.Cust.forceL = dataL[3];

      EASYCAT.BufferIn.Cust.yawL = dataL[4];

      EASYCAT.BufferIn.Cust.pitchL = dataL[5];

      EASYCAT.BufferIn.Cust.rollL = dataL[6];

      EASYCAT.BufferIn.Cust.centerXR = dataR[1];

      EASYCAT.BufferIn.Cust.centerYR = dataR[2];

      EASYCAT.BufferIn.Cust.forceR = dataR[3];

      EASYCAT.BufferIn.Cust.yawR = dataR[4];

      EASYCAT.BufferIn.Cust.pitchR = dataR[5];

      EASYCAT.BufferIn.Cust.rollR = dataR[6];

      EASYCAT.BufferIn.Cust.yawH = dataM[4];

      EASYCAT.BufferIn.Cust.pitchH = dataM[5];

      EASYCAT.BufferIn.Cust.rollH = dataM[6];    
   
    //  printf("\ndata %d",data_Test);
    //  data_Test++ ;                                                                 
    }  
     //printf("\nforceL %d",dataL[3]); 
     //printf("\nforceR %d",dataR[3]); 
  }  
}

  


//--- functions for Arduino "millis()" emulation -------------------------------------


void InitMillis(void) 
{
  uS_Tick.attach (&mS_Tick, 0.001);        
}

void mS_Tick(void)
{
  MillisVal++;
}