//---------------------------------------------------------------
// Motion Touch Screen 
//---------------------------------------------------------------
#include "mbed.h"
#include "F469_BUTTON.hpp"
#include "F469_SLIDER.hpp"
#include "EasyCAT.h"                // EasyCAT library to interface the LAN9252

DigitalOut led_green(LED1);
DigitalOut led_orange(LED2);
DigitalOut led_red(LED3);
DigitalOut led_blue(LED4);

TS_DISCO_F469NI ts_;
LCD_DISCO_F469NI lcd_;

EasyCAT EASYCAT;                    // EasyCAT istantiation

char char_SliderDisplayValue[4];    // String Value to display for the Slider Control value 
uint16_t SliderDisplayValue_;       // Variable used to access Slider Control Value in F469SLIDER.cpp

//---- global variables ---------------------------------------------------------------------------
int menu = 0;

UWORD ContaUp;                      // used for sawthoot test generation
UWORD ContaDown;                    //

unsigned long Millis = 0;    // Time counter 
unsigned long Millis2 = 0;     // Time counter 2
unsigned long PreviousSaw = 0;  // Time counter 
unsigned long PreviousCycle = 0; // Time counter 

int8_t stand = 0; // data to Send 
int8_t start = 0; // data to Send  
int8_t stepping = 0; // data to Send  
int8_t endStep = 0; // data to Send 

int8_t enable = 0; // data to Send 
char enable_S[10];      // TO print Data 
int8_t enable_Lateral = 0; // data to Send 
char enable_Lateral_S[10];   // TO print Data 
int8_t quick_Stop = 0; // data to Send 
int8_t clear_Fault = 0; // data to Send 

float Standing_Time = 2.0 ; // data to Send 
char Standing_Time_S[10];       // TO print Data 
float Step_Time = 2.0 ;  // data to Send 
char Step_Time_S[10];       // TO print Data 
float Wait_COM_Tr_Time = 0.5 ; // data to Send 
char Wait_COM_Tr_Time_S[10];        // TO print Data 
float COM_Tr_Threshold = 20 ; // data to Send 
char COM_Tr_Threshold_S[10];        // TO print Data 

uint8_t Ethercat = 0 ;  // data to Receive
char Ethercat_S[10];   // TO print Data 
float Running_Time = 0.0 ;  // data to Receive 
char Running_Time_S[20];        // TO print Data 
uint8_t State_Step = 0 ;  // data to Receive
char State_Step_S[10];      // TO print Data 
uint8_t Status_Driver = 0 ;// data to Receive
char Status_Driver_S[10];       // TO print Data 
uint8_t END = 0 ;// data to Receive
char END_S[10];     // TO print Data 

//---- declarations for Arduino "millis()" emulation ----------------------- 

static Ticker uS_Tick;
static volatile uint32_t MillisVal = 0;

void InitMillis(void);    
void mS_Tick(void);
  
inline static uint32_t millis (void) 
{
    return MillisVal; 
};
 
      

//---------------------------------------------------------------------------------------------
int main()
{
    led_green = 1;         // Switch off all LEDs
    led_orange = 1;
    led_red = 1;
    led_blue = 1; 
    EASYCAT.Init();
    lcd_.Clear(LCD_COLOR_WHITE);                                        // Set LCD Background colour
    
                                                          // Set Text colour to Black

    lcd_.SetTextColor(LCD_COLOR_BLACK);   
    lcd_.SetFont(&Font24);                                                                      // Font size 24
    lcd_.DisplayStringAt(10, 20, (uint8_t *)" Status EtherCAT: ", LEFT_MODE);            // Display main header text
    lcd_.SetFont(&Font24);      
    lcd_.DisplayStringAt(400, 20, (uint8_t *)" Running Time: ", LEFT_MODE);            // Display main header text
    lcd_.SetFont(&Font24);  
    lcd_.DisplayStringAt(10, 60, (uint8_t *)" State Step: ", LEFT_MODE);            // Display main header text
    lcd_.SetFont(&Font24);      
    lcd_.DisplayStringAt(400, 60, (uint8_t *)" Status Driver: ", LEFT_MODE);            // Display main header text
    lcd_.SetFont(&Font24);      
    lcd_.DisplayStringAt(10, 440, (uint8_t *)" END ? : ", LEFT_MODE);            // Display main header text
    lcd_.DrawHLine(20, 90, 760);
    lcd_.DrawHLine(20, 91, 760);
    
    lcd_.SetTextColor(LCD_COLOR_RED); 
    lcd_.SetFont(&Font24);                                                                 // Font size 24
    lcd_.DisplayStringAt(10, 110, (uint8_t *)" Driver Controle ", LEFT_MODE);            // Display main header text     
    
    Button btn1(lcd_, ts_, 20, 160, 160, 70,            
              LCD_COLOR_GREEN , LCD_COLOR_DARKBLUE, 1, "Enable", Font20);  // Define btn1 button           
    btn1.Render();
    lcd_.SetFont(&Font24);
    lcd_.SetTextColor(LCD_COLOR_BLACK); 
    sprintf(enable_S, "%d", enable);
    lcd_.DisplayStringAt(90, 136, (uint8_t *)" ", LEFT_MODE);
    lcd_.DisplayStringAt(90, 136, (uint8_t *)enable_S, LEFT_MODE);                                                         // Draw Enable button
    
    Button btn2(lcd_, ts_, 220, 160, 160, 70,
                 LCD_COLOR_GREEN , LCD_COLOR_DARKBLUE, 1, "Lateral", Font20);  // Define test button                   
    btn2.Render();
    lcd_.SetFont(&Font24);
    lcd_.SetTextColor(LCD_COLOR_BLACK); 
    sprintf(enable_Lateral_S, "%d", enable_Lateral);
    lcd_.DisplayStringAt(290, 136, (uint8_t *)" ", LEFT_MODE);
    lcd_.DisplayStringAt(290, 136, (uint8_t *)enable_Lateral_S, LEFT_MODE);                                                          // Draw Lateral button
    Button btn3(lcd_, ts_, 420, 160, 160, 70,            
              LCD_COLOR_BROWN, LCD_COLOR_GRAY, 1, "Quick Stop", Font20);  // Define Quick Stop button            
    btn3.Render();                                                         // Draw Quick Stop button
    
    Button btn4(lcd_, ts_, 620, 160, 160, 70,
                 LCD_COLOR_BROWN, LCD_COLOR_GRAY, 1, "Clear Fault", Font20);  // Define Clear Fault button                   
    btn4.Render();                                                             // Draw Clear Fault button
    
    lcd_.SetTextColor(LCD_COLOR_RED); 
    lcd_.SetFont(&Font24);                                                                      // Font size 24
    lcd_.DisplayStringAt(10, 250, (uint8_t *)" Step Control ", LEFT_MODE);            // Display main header text  

    
    Button button3D1(lcd_, ts_, 20, 300, 160, 70,            
                 LCD_COLOR_BLUE, LCD_COLOR_YELLOW, 2, "Stand", Font20);    // Define Stand button            
    button3D1.Render(); 
    
    Button button3D2(lcd_, ts_, 220, 300, 160, 70,            
                 LCD_COLOR_BLUE, LCD_COLOR_YELLOW, 2, "Start", Font20);    // Define Start button            
    button3D2.Render();  
       
    Button button3D3(lcd_, ts_, 420, 300, 160, 70,            
                 LCD_COLOR_BLUE, LCD_COLOR_YELLOW, 2, "Stepping", Font20);    // Define Stepping button            
    button3D3.Render();   
    Button button3D4(lcd_, ts_, 620, 300, 160, 70,            
                 LCD_COLOR_BLUE, LCD_COLOR_YELLOW, 2, "EndStep", Font20);    // Define EndStep button            
    button3D4.Render();     
    
    lcd_.SetTextColor(LCD_COLOR_RED);   
    lcd_.SetFont(&Font24);                                                                      // Font size 24
    lcd_.DisplayStringAt(280, 440, (uint8_t *)" MOTION PROJECT ", LEFT_MODE);            // Display main header text
    
    Button btn5(lcd_, ts_, 660, 410, 120, 60,
                 LCD_COLOR_ORANGE, LCD_COLOR_GRAY, 1, "Next", Font20);  // Define Next button                   
    btn5.Render();  
    

  InitMillis();                                         // init "millis()" emulation                

  ContaDown.Word = 0x0000;
  ContaUp.Word = 0x0000; 

    while (true)                                                    // Main program loop
    {    
        led_green = 1;                                              // Switch off all LEDs
        led_orange = 1;
        led_red = 1;
        led_blue = 1;  
                                                                                
        if (btn1.Press() )                                         // Check if Enable button was touched and run instructions if true
        {    
            if (enable==0)
                {
                    enable=1;
                }
            else enable=0;
            lcd_.SetFont(&Font24);
            lcd_.SetTextColor(LCD_COLOR_BLACK); 
            sprintf(enable_S, "%d", enable);
            lcd_.DisplayStringAt(90, 136, (uint8_t *)" ", LEFT_MODE);
            lcd_.DisplayStringAt(90, 136, (uint8_t *)enable_S, LEFT_MODE);
            lcd_.SetFont(&Font16);
            lcd_.SetTextColor(LCD_COLOR_BLACK);
            lcd_.DisplayStringAt(5, 460, (uint8_t *)"Enable pressed - switch on orange LED", LEFT_MODE);
            led_orange = 0; 
            wait(0.2); 
            lcd_.DisplayStringAt(5, 460, (uint8_t *)"                                        ", LEFT_MODE);
            
        }  
                                                              // End Enable button instructions       
        if (btn2.Press())                                         // Check if Enable Lateral button was touched and run instructions if true
        {
             if (enable_Lateral==0)
                {
                    enable_Lateral=1;
                }
            else enable_Lateral=0;
            lcd_.SetFont(&Font24);
            lcd_.SetTextColor(LCD_COLOR_BLACK); 
            sprintf(enable_Lateral_S, "%d", enable_Lateral);
            lcd_.DisplayStringAt(290, 136, (uint8_t *)" ", LEFT_MODE);
            lcd_.DisplayStringAt(290, 136, (uint8_t *)enable_Lateral_S, LEFT_MODE);
            lcd_.SetFont(&Font16);
            lcd_.SetTextColor(LCD_COLOR_BLACK);
            lcd_.DisplayStringAt(5, 460, (uint8_t *)"Enable Lateral pressed - switch on red LED", LEFT_MODE);
            led_red = 0;
            wait(0.2);
            lcd_.DisplayStringAt(5, 460, (uint8_t *)"                                            ", LEFT_MODE);
            
        }                                                           // End Enable Lateral button instructions        
        
         if (btn3.Press())                                  // Check if Quick Stop button was touched and run instructions if true
        {    
            if (quick_Stop==0)
                {
                    quick_Stop=1;
                }
            else quick_Stop=0;
            lcd_.SetFont(&Font16);
            lcd_.SetTextColor(LCD_COLOR_BLACK);
            lcd_.DisplayStringAt(5, 460, (uint8_t *)"Quick Stop pressed - switch on blue LED", LEFT_MODE);
            led_blue = 0;
            wait(0.2);
            lcd_.DisplayStringAt(5, 460, (uint8_t *)"                                           ", LEFT_MODE);
        }                                                           // End Quick Stop button instructions        
        if (btn4.Press())                                         // Check if Clear Fault button was touched and run instructions if true
        {
             if (clear_Fault==0)
                {
                    clear_Fault=1;
                }
            else clear_Fault=0;
            lcd_.SetFont(&Font16);
            lcd_.SetTextColor(LCD_COLOR_BLACK);
            lcd_.DisplayStringAt(5, 460, (uint8_t *)"Clear Fault pressed - switch on red LED", LEFT_MODE);
            led_red = 0;
            wait(0.2);
            lcd_.DisplayStringAt(5, 460, (uint8_t *)"                                         ", LEFT_MODE);
            
        }  
      

        if (button3D1.Press() )                                         // Check if Stand button was touched and run instructions if true
        {    
            if (stand==0)
                {
                    stand=1;
                }
            else stand=0;
            lcd_.SetFont(&Font16);
            lcd_.SetTextColor(LCD_COLOR_BLACK);
            lcd_.DisplayStringAt(5, 460, (uint8_t *)"Stand pressed - switch on orange LED", LEFT_MODE);
            led_orange = 0; 
            wait(0.2); 
            lcd_.DisplayStringAt(5, 460, (uint8_t *)"                                        ", LEFT_MODE);
            
        }  
                                                              // End Stand button instructions
        
        if (button3D2.Press())                                         // Check if Start button was touched and run instructions if true
        {
             if (start==0)
                {
                    start=1;
                }
            else start=0;
            lcd_.SetFont(&Font16);
            lcd_.SetTextColor(LCD_COLOR_BLACK);
            lcd_.DisplayStringAt(5, 460, (uint8_t *)"Start pressed - switch on red LED", LEFT_MODE);
            led_red = 0;
            wait(0.2);
            lcd_.DisplayStringAt(5, 460, (uint8_t *)"                                        ", LEFT_MODE);
            
        }                                                           // End Start button instructions
        
         if (button3D3.Press())                                  // Check if Stepping button was touched and run instructions if true
        {    
            if (stepping==0)
                {
                    stepping=1;
                }
            else stepping=0;
            lcd_.SetFont(&Font16);
            lcd_.SetTextColor(LCD_COLOR_BLACK);
            lcd_.DisplayStringAt(5, 460, (uint8_t *)"Stepping pressed - switch on blue LED", LEFT_MODE);
            led_blue = 0;
            wait(0.2);
            lcd_.DisplayStringAt(5, 460, (uint8_t *)"                                           ", LEFT_MODE);
        }
        
         if (button3D4.Press())                                  // Check if EndStep button was touched and run instructions if true
        {    
            if (endStep==0)
                {
                    endStep=1;
                }
            else endStep=0;
            lcd_.SetFont(&Font16);
            lcd_.SetTextColor(LCD_COLOR_BLACK);
            lcd_.DisplayStringAt(5, 460, (uint8_t *)"EndStep pressed - switch on blue LED", LEFT_MODE);
            led_blue = 0;
            wait(0.2);
            lcd_.DisplayStringAt(5, 460, (uint8_t *)"                                           ", LEFT_MODE);
        }
        
                        if ( btn5.Press() )                  // Check if next button was touched and run instructions if true
        {   menu = 1 ;
            lcd_.Clear(LCD_COLOR_WHITE);
            led_orange = 0; 
            wait(0.1);
            led_orange = 1;                                         // Set LCD Background colour
            
            lcd_.SetTextColor(LCD_COLOR_BLACK);   
            lcd_.SetFont(&Font24);                                                                      // Font size 24
            lcd_.DisplayStringAt(20, 45, (uint8_t *)"Standing Time", LEFT_MODE);            // Display main header text
            sprintf(Standing_Time_S, "%0.2f", Standing_Time);
            lcd_.SetFont(&Font24);
            lcd_.SetTextColor(LCD_COLOR_BLACK);
            lcd_.DisplayStringAt(320, 45, (uint8_t *)Standing_Time_S, LEFT_MODE); 
            
            Button btn11(lcd_, ts_, 400, 20, 150, 60,            
            LCD_COLOR_GREEN , LCD_COLOR_DARKBLUE, 1, " + ", Font24);  // Define + button           
            btn11.Render();
            Button btn12(lcd_, ts_, 600, 20, 150, 60,            
            LCD_COLOR_RED , LCD_COLOR_DARKBLUE, 1, " - ", Font24);  // Define - button           
            btn12.Render();
            
            lcd_.SetTextColor(LCD_COLOR_BLACK);   
            lcd_.SetFont(&Font24);                                                                      // Font size 24
            lcd_.DisplayStringAt(20, 145, (uint8_t *)"Step Time", LEFT_MODE);            // Display main header text
            sprintf(Step_Time_S, "%0.2f", Step_Time);
            lcd_.SetFont(&Font24);
            lcd_.SetTextColor(LCD_COLOR_BLACK);
            lcd_.DisplayStringAt(320, 145, (uint8_t *)Step_Time_S, LEFT_MODE);
            Button btn13(lcd_, ts_, 400, 120, 150, 60,            
            LCD_COLOR_GREEN , LCD_COLOR_DARKBLUE, 1, " + ", Font24);  // Define + button           
            btn13.Render();
            Button btn14(lcd_, ts_, 600, 120, 150, 60,            
            LCD_COLOR_RED , LCD_COLOR_DARKBLUE, 1, " - ", Font24);  // Define - button           
            btn14.Render();
            
            lcd_.SetTextColor(LCD_COLOR_BLACK);   
            lcd_.SetFont(&Font24);                                                                      // Font size 24
            lcd_.DisplayStringAt(20, 245, (uint8_t *)"Wait COM Tr Time", LEFT_MODE);            // Display main header text
            sprintf(Wait_COM_Tr_Time_S, "%0.2f", Wait_COM_Tr_Time);
            lcd_.SetFont(&Font24);
            lcd_.SetTextColor(LCD_COLOR_BLACK);
            lcd_.DisplayStringAt(320, 245, (uint8_t *)Wait_COM_Tr_Time_S, LEFT_MODE);
            Button btn15(lcd_, ts_, 400, 220, 150, 60,            
            LCD_COLOR_GREEN , LCD_COLOR_DARKBLUE, 1, " + ", Font24);  // Define + button           
            btn15.Render();
            Button btn16(lcd_, ts_, 600, 220, 150, 60,            
            LCD_COLOR_RED , LCD_COLOR_DARKBLUE, 1, " - ", Font24);  // Define - button           
            btn16.Render();
            
            lcd_.SetTextColor(LCD_COLOR_BLACK);   
            lcd_.SetFont(&Font24);                                                                      // Font size 24
            lcd_.DisplayStringAt(20, 345, (uint8_t *)"COM Tr Threshold", LEFT_MODE);            // Display main header text
            sprintf(COM_Tr_Threshold_S, "%0.1f", COM_Tr_Threshold);
            lcd_.SetFont(&Font24);
            lcd_.SetTextColor(LCD_COLOR_BLACK);
            lcd_.DisplayStringAt(320, 345, (uint8_t *)COM_Tr_Threshold_S, LEFT_MODE);
            lcd_.DisplayStringAt(360, 345, (uint8_t *)" %", LEFT_MODE);
            Button btn17(lcd_, ts_, 400, 320, 150, 60,            
            LCD_COLOR_GREEN , LCD_COLOR_DARKBLUE, 1, " + ", Font24);  // Define + button           
            btn17.Render();
            Button btn18(lcd_, ts_, 600, 320, 150, 60,            
            LCD_COLOR_RED , LCD_COLOR_DARKBLUE, 1, " - ", Font24);  // Define - button           
            btn18.Render();
            
            Button btn6(lcd_, ts_, 20, 410, 120, 60,
            LCD_COLOR_ORANGE, LCD_COLOR_GRAY, 1, "Back", Font20);  // Define Back button                   
            btn6.Render();  
               
            Button btn7(lcd_, ts_, 650, 400, 140, 70,
                 LCD_COLOR_ORANGE, LCD_COLOR_GRAY, 1, "Reset", Font20);  // Define Reset button                   
            btn7.Render();  
            
            lcd_.SetTextColor(LCD_COLOR_RED);   
            lcd_.SetFont(&Font24);                                                                      // Font size 24
            lcd_.DisplayStringAt(280, 440, (uint8_t *)" MOTION PROJECT ", LEFT_MODE);            // Display main header text
           
            while (menu==1)
            {           if (btn11.Press() )                                         // Check if + button was touched and run instructions if true
                        {   
                            Standing_Time = Standing_Time + 0.5 ;
                            sprintf(Standing_Time_S, "%0.2f", Standing_Time);
                            lcd_.SetFont(&Font24);
                            lcd_.SetTextColor(LCD_COLOR_BLACK);
                            lcd_.DisplayStringAt(320, 45, (uint8_t *)"    ", LEFT_MODE);
                            lcd_.DisplayStringAt(320, 45, (uint8_t *)Standing_Time_S, LEFT_MODE); 
                            
                        }
                        if (btn12.Press() )                                         // Check if - button was touched and run instructions if true
                        {   if (Standing_Time>0)
                            {
                            Standing_Time = Standing_Time - 0.5 ;
                            sprintf(Standing_Time_S, "%0.2f", Standing_Time);
                            lcd_.SetFont(&Font24);
                            lcd_.SetTextColor(LCD_COLOR_BLACK);
                            lcd_.DisplayStringAt(320, 45, (uint8_t *)"    ", LEFT_MODE);
                            lcd_.DisplayStringAt(320, 45, (uint8_t *)Standing_Time_S, LEFT_MODE); 
                            }
                        }
                        if (btn13.Press() )                                         // Check if + button was touched and run instructions if true
                        {   
                            Step_Time = Step_Time + 0.5 ;
                            sprintf(Step_Time_S, "%0.2f", Step_Time);
                            lcd_.SetFont(&Font24);
                            lcd_.SetTextColor(LCD_COLOR_BLACK);
                            lcd_.DisplayStringAt(320, 145, (uint8_t *)"    ", LEFT_MODE);
                            lcd_.DisplayStringAt(320, 145, (uint8_t *)Step_Time_S, LEFT_MODE); 
                            
                        }
                        if (btn14.Press() )                                         // Check if - button was touched and run instructions if true
                        {   if (Step_Time>0)
                            {
                            Step_Time = Step_Time - 0.5 ;
                            sprintf(Step_Time_S, "%0.2f", Step_Time);
                            lcd_.SetFont(&Font24);
                            lcd_.SetTextColor(LCD_COLOR_BLACK);
                            lcd_.DisplayStringAt(320, 145, (uint8_t *)"    ", LEFT_MODE);
                            lcd_.DisplayStringAt(320, 145, (uint8_t *)Step_Time_S, LEFT_MODE); 
                            }
                        }
                        if (btn15.Press() )                                         // Check if + button was touched and run instructions if true
                        {   
                            Wait_COM_Tr_Time = Wait_COM_Tr_Time + 0.5 ;
                            sprintf(Wait_COM_Tr_Time_S, "%0.2f", Wait_COM_Tr_Time);
                            lcd_.SetFont(&Font24);
                            lcd_.SetTextColor(LCD_COLOR_BLACK);
                            lcd_.DisplayStringAt(320, 245, (uint8_t *)"    ", LEFT_MODE);
                            lcd_.DisplayStringAt(320, 245, (uint8_t *)Wait_COM_Tr_Time_S, LEFT_MODE); 
                            
                        }
                        if (btn16.Press() )                                         // Check if - button was touched and run instructions if true
                        {   if (Wait_COM_Tr_Time>0)
                            {
                            Wait_COM_Tr_Time = Wait_COM_Tr_Time - 0.5 ;
                            sprintf(Wait_COM_Tr_Time_S, "%0.2f", Wait_COM_Tr_Time);
                            lcd_.SetFont(&Font24);
                            lcd_.SetTextColor(LCD_COLOR_BLACK);
                            lcd_.DisplayStringAt(320, 245, (uint8_t *)"    ", LEFT_MODE);
                            lcd_.DisplayStringAt(320, 245, (uint8_t *)Wait_COM_Tr_Time_S, LEFT_MODE); 
                            }
                        }
                        if (btn17.Press() )                                         // Check if + button was touched and run instructions if true
                        {   
                            COM_Tr_Threshold = COM_Tr_Threshold + 5 ;
                            sprintf(COM_Tr_Threshold_S, "%0.1f", COM_Tr_Threshold);
                            lcd_.SetFont(&Font24);
                            lcd_.SetTextColor(LCD_COLOR_BLACK);
                            lcd_.DisplayStringAt(320, 345, (uint8_t *)"   ", LEFT_MODE);
                            lcd_.DisplayStringAt(320, 345, (uint8_t *)COM_Tr_Threshold_S, LEFT_MODE);
                            lcd_.DisplayStringAt(360, 345, (uint8_t *)" %", LEFT_MODE); 
                            
                        }
                        if (btn18.Press() )                                         // Check if - button was touched and run instructions if true
                        {   if (COM_Tr_Threshold>0)
                            {
                            COM_Tr_Threshold = COM_Tr_Threshold - 5 ;
                            sprintf(COM_Tr_Threshold_S, "%0.1f", COM_Tr_Threshold);
                            lcd_.SetFont(&Font24);
                            lcd_.SetTextColor(LCD_COLOR_BLACK);
                            lcd_.DisplayStringAt(320, 345, (uint8_t *)"  ", LEFT_MODE);
                            lcd_.DisplayStringAt(320, 345, (uint8_t *)COM_Tr_Threshold_S, LEFT_MODE);
                            lcd_.DisplayStringAt(360, 345, (uint8_t *)" %", LEFT_MODE);
                            }
                        }
                        if (btn7.Press() )                    // Check if Reset button was touched and run instructions if true
                        {   
                        Standing_Time = 2.0 ;
                        Step_Time = 2.0 ;
                        Wait_COM_Tr_Time = 0.5 ;
                        COM_Tr_Threshold = 20 ;
                                                                     
                        stand = 0; 
                        start = 0; 
                        stepping = 0;  
                        endStep = 0;                        
                        
                        enable=0;
                        enable_Lateral = 0; 
                        quick_Stop = 0; 
                        clear_Fault = 0; 
                                                             
                        Ethercat=0;
                        Running_Time=0;
                        State_Step=0;
                        Status_Driver=0;
                        END=0;
                        
                        lcd_.SetFont(&Font24);
                        lcd_.SetTextColor(LCD_COLOR_BLACK);
                        
                        sprintf(Standing_Time_S, "%0.2f", Standing_Time);
                        lcd_.DisplayStringAt(320, 45, (uint8_t *)"    ", LEFT_MODE);
                        lcd_.DisplayStringAt(320, 45, (uint8_t *)Standing_Time_S, LEFT_MODE);
                        
                        sprintf(Step_Time_S, "%0.2f", Step_Time);
                        lcd_.DisplayStringAt(320, 145, (uint8_t *)"    ", LEFT_MODE);
                        lcd_.DisplayStringAt(320, 145, (uint8_t *)Step_Time_S, LEFT_MODE);  
                        
                        sprintf(Wait_COM_Tr_Time_S, "%0.2f", Wait_COM_Tr_Time);
                        lcd_.DisplayStringAt(320, 245, (uint8_t *)"    ", LEFT_MODE);
                        lcd_.DisplayStringAt(320, 245, (uint8_t *)Wait_COM_Tr_Time_S, LEFT_MODE);
                        
                        sprintf(COM_Tr_Threshold_S, "%0.1f", COM_Tr_Threshold);
                        lcd_.DisplayStringAt(320, 345, (uint8_t *)"   ", LEFT_MODE);
                        lcd_.DisplayStringAt(320, 345, (uint8_t *)COM_Tr_Threshold_S, LEFT_MODE);
                        lcd_.DisplayStringAt(360, 345, (uint8_t *)" %", LEFT_MODE); 
                        }
                        if (btn6.Press() )                                         // Check if btn back button was touched and run instructions if true
                        {
                        menu=0;   
                        led_orange = 0; 
                        lcd_.Clear(LCD_COLOR_WHITE);                                        // Set LCD Background colour                                                            
                        lcd_.SetTextColor(LCD_COLOR_BLACK);                                 // Set Text colour to Black
                        lcd_.SetFont(&Font24);                                                                      // Font size 24
                        lcd_.DisplayStringAt(10, 20, (uint8_t *)" Status EtherCAT: ", LEFT_MODE);            // Display main header text
                        lcd_.SetFont(&Font24);      
                        lcd_.DisplayStringAt(400, 20, (uint8_t *)" Running Time: ", LEFT_MODE);            // Display main header text
                        lcd_.SetFont(&Font24);  
                        lcd_.DisplayStringAt(10, 60, (uint8_t *)" State Step: ", LEFT_MODE);            // Display main header text
                        lcd_.SetFont(&Font24);      
                        lcd_.DisplayStringAt(400, 60, (uint8_t *)" Status Driver: ", LEFT_MODE);            // Display main header text
                        lcd_.SetFont(&Font24);      
                        lcd_.DisplayStringAt(10, 440, (uint8_t *)" END ? : ", LEFT_MODE);            // Display main header text
                        lcd_.DrawHLine(20, 90, 760);
                        lcd_.DrawHLine(20, 91, 760);
    
                        lcd_.SetTextColor(LCD_COLOR_RED); 
                        lcd_.SetFont(&Font24);                                                                 // Font size 24
                        lcd_.DisplayStringAt(10, 110, (uint8_t *)" Driver Controle ", LEFT_MODE);            // Display main header text     
                        
                        Button btn1(lcd_, ts_, 20, 160, 160, 70,            
                                  LCD_COLOR_GREEN , LCD_COLOR_DARKBLUE, 1, "Enable", Font20);  // Define Enable button           
                        btn1.Render();
                        lcd_.SetFont(&Font24);
                        lcd_.SetTextColor(LCD_COLOR_BLACK); 
                        sprintf(enable_S, "%d", enable);
                        lcd_.DisplayStringAt(90, 136, (uint8_t *)" ", LEFT_MODE);
                        lcd_.DisplayStringAt(90, 136, (uint8_t *)enable_S, LEFT_MODE);                                                         // Draw btn1 button
                        
                        Button btn2(lcd_, ts_, 220, 160, 160, 70,
                                     LCD_COLOR_GREEN , LCD_COLOR_DARKBLUE, 1, "Lateral", Font20);  // Define Lateral button                   
                        btn2.Render();                                                         // Draw Lateral button
                        lcd_.SetFont(&Font24);
                        lcd_.SetTextColor(LCD_COLOR_BLACK); 
                        sprintf(enable_Lateral_S, "%d", enable_Lateral);
                        lcd_.DisplayStringAt(290, 136, (uint8_t *)" ", LEFT_MODE);
                        lcd_.DisplayStringAt(290, 136, (uint8_t *)enable_Lateral_S, LEFT_MODE);
                        
                        Button btn3(lcd_, ts_, 420, 160, 160, 70,            
                                  LCD_COLOR_BROWN, LCD_COLOR_GRAY, 1, "Quick Stop", Font20);  // Define Quick Stop button            
                        btn3.Render();                                                         // Draw Quick Stop button
    
                        Button btn4(lcd_, ts_, 620, 160, 160, 70,
                                     LCD_COLOR_BROWN, LCD_COLOR_GRAY, 1, "Clear Fault", Font20);  // Define Clear Fault button                   
                        btn4.Render();                                                             // Draw Clear Fault button
                        
                        lcd_.SetTextColor(LCD_COLOR_RED); 
                        lcd_.SetFont(&Font24);                                                                      // Font size 24
                        lcd_.DisplayStringAt(10, 250, (uint8_t *)" Step Control ", LEFT_MODE);            // Display main header text  
                    
                        
                        Button button3D1(lcd_, ts_, 20, 300, 160, 70,            
                                     LCD_COLOR_BLUE, LCD_COLOR_YELLOW, 2, "Stand", Font20);    // Define Stand button            
                        button3D1.Render(); 
    
                        Button button3D2(lcd_, ts_, 220, 300, 160, 70,            
                                     LCD_COLOR_BLUE, LCD_COLOR_YELLOW, 2, "Start", Font20);    // Define Start button            
                        button3D2.Render();  
                           
                        Button button3D3(lcd_, ts_, 420, 300, 160, 70,            
                                     LCD_COLOR_BLUE, LCD_COLOR_YELLOW, 2, "Stepping", Font20);    // Define Stepping button            
                        button3D3.Render();   
                        Button button3D4(lcd_, ts_, 620, 300, 160, 70,            
                                     LCD_COLOR_BLUE, LCD_COLOR_YELLOW, 2, "EndStep", Font20);    // Define EndStep button            
                        button3D4.Render();     
                        
                        lcd_.SetTextColor(LCD_COLOR_RED);   
                        lcd_.SetFont(&Font24);                                                                      // Font size 24
                        lcd_.DisplayStringAt(280, 440, (uint8_t *)" MOTION PROJECT ", LEFT_MODE);            // Display main header text
                        
                        Button btn5(lcd_, ts_, 660, 410, 120, 60,
                                     LCD_COLOR_ORANGE, LCD_COLOR_GRAY, 1, "Next", Font20);  // Define Next button                   
                        btn5.Render();  
                        
                        wait(0.2); 
                        } 
            wait(0.02f);           
            }   
        }                                                          // End test button instructions                                                                // End 3D button instructions

        wait(0.02f);   
           
            Millis = millis();                                  //
    if (Millis - PreviousCycle >= 10)                   // each 10 mS Send Data to SpeedGoat 
    {                                                   // 
      PreviousCycle = Millis;                           //
    
      EASYCAT.MainTask();                               // execute the EasyCAT task
      
      
      
      EASYCAT.BufferIn.Cust.Standing_Time_T= Standing_Time;
      
      EASYCAT.BufferIn.Cust.Step_Time_T= Step_Time;
      
      EASYCAT.BufferIn.Cust.Wait_COM_Tr_Time_T= Wait_COM_Tr_Time;
      
      EASYCAT.BufferIn.Cust.COM_Tr_Threshold_T= (COM_Tr_Threshold/100);    
      
      
      
      EASYCAT.BufferIn.Cust.Stand= stand;
      
      EASYCAT.BufferIn.Cust.Start = start;
      
      EASYCAT.BufferIn.Cust.Stepping = stepping;

      EASYCAT.BufferIn.Cust.EndStep = endStep;
      
      EASYCAT.BufferIn.Cust.Enable= enable;

      EASYCAT.BufferIn.Cust.EnableLateral = enable_Lateral;

      EASYCAT.BufferIn.Cust.QuickStop = quick_Stop;
      
      EASYCAT.BufferIn.Cust.ClearFault = clear_Fault;
      
      Ethercat = EASYCAT.BufferOut.Cust.EtherCAT;
      
      Running_Time = EASYCAT.BufferOut.Cust.Running_Time_T ;
      
      State_Step = EASYCAT.BufferOut.Cust.State_Step_T ;
      
      Status_Driver = EASYCAT.BufferOut.Cust.Status_Driver_T ;
      
      END = EASYCAT.BufferOut.Cust.END_T ;      
                                                           
    }   
        sprintf(Ethercat_S, "%d", Ethercat);
        lcd_.SetFont(&Font24);
        lcd_.SetTextColor(LCD_COLOR_BLACK);
        lcd_.DisplayStringAt(320, 20, (uint8_t *)Ethercat_S, LEFT_MODE);            // Display main header text
        
        
        sprintf(Running_Time_S, "%0.1f", Running_Time);
        lcd_.SetFont(&Font24);
        lcd_.SetTextColor(LCD_COLOR_BLACK);
        lcd_.DisplayStringAt(680, 20, (uint8_t *)Running_Time_S, LEFT_MODE);            // Display main header text
        
        sprintf(State_Step_S, "%d", State_Step);
        lcd_.SetFont(&Font24);
        lcd_.SetTextColor(LCD_COLOR_BLACK);
        lcd_.DisplayStringAt(320, 60, (uint8_t *)State_Step_S, LEFT_MODE);            // Display main header text
        
        sprintf(Status_Driver_S, "%d", Status_Driver);
        lcd_.SetFont(&Font24);
        lcd_.SetTextColor(LCD_COLOR_BLACK);
        lcd_.DisplayStringAt(680, 60, (uint8_t *)Status_Driver_S, LEFT_MODE);            // Display main header text
        
        sprintf(END_S, "%d", END);
        lcd_.SetFont(&Font24);
        lcd_.SetTextColor(LCD_COLOR_BLACK);
        lcd_.DisplayStringAt(150, 440, (uint8_t *)END_S, LEFT_MODE);            // Display main header text       
    }                                                               // End Main program loop
}                                                                   // End Main program 


//--- functions "millis()" emulation -------------------------------------


void InitMillis(void) 
{
  uS_Tick.attach (&mS_Tick, 0.001);        
}

void mS_Tick(void)
{
  MillisVal++;
}
void Menu0(void)
{

    }