/*
Gyroscope Interfacing
After recieving 16bit from Gyro if 15th bit is zero, the instruction is accepted
*/

#include "mbed.h"
SPI spi(p5, p6, p7); // mosi, miso, sclk
DigitalOut csGyro(p8);
Serial pc(USBTX, USBRX); // tx, rx

void activateADC()
{
    unsigned int data1, data2;
    csGyro=0;
    spi.write(0x93); // 0b10010100
    /*Check if instruction recieved i.e  */
    //Send 2 dymmy byte of any combination
    data1 = spi.write(0x00);
    data2 = spi.write(0x00);
    wait_us(200);
    csGyro=1;
    
    if(data1 & 0x80) /*0b10000000*/
    {
        pc.printf("\nInstruction not recieved %d %d", &data1, &data2);
    }
    else
        pc.printf("\n ADC activated  ");
}

void sleepADC()
{
	unsigned int data1, data2;
	csGyro=0;
    spi.write(0x90); // 0b10010000
    /*Check if instruction recieved i.e  */
    //Send 2 dymmy byte of any combination
    data1 = spi.write(0x00);
    data2 = spi.write(0x00);
    wait_us(200);
    csGyro=1;
    
    if(data1 & 0x80) /*0b10000000*/
    {
        pc.printf("\nInstruction not recieved %d %d", &data1, &data2);
    }
    else
        pc.printf("\n ADC in sleep ");
}

unsigned int getAngularRate()
{
    unsigned int result=0, data1, data2;
    csGyro=0;
    spi.write(0x94); /* 0b10010100 Send SPI ADCC for Angular Rate (CHAN bit = 0)*/
    /*Check if instruction recieved*/
    //Send 2 dymmy byte of any combination
    data1 = spi.write(0x00);
    data2 = spi.write(0x00);
    wait_us(200);
    csGyro=1;
    
    if(data1 & 0x80 ) /*0b10000000*/
    {
        pc.printf("\nInstruction not recieved");
    }

    csGyro=0;
    spi.write(0x80); /* 0b10000000 Send SPI ADCR Instruction*/
    /*Send 2 dymmy byte*/
    data1 = spi.write(0x00);
    data2 = spi.write(0x00);
    wait_us(200);
    csGyro=1;
    
    /*Check if instruction recieved*/
    if(!(data1 & 0x80))
    {
        while(!(data1 & 0x20)); // Wait while EOC is 0
        result = ((data1 & 0x0F) << 7) + (data2>>1);
    }
    return result;
   
}

unsigned int getTemperature()
{
    unsigned int result=0, data1, data2;
    csGyro=0;
    spi.write(0x9C); /* 0b10011100 Send SPI ADCC for Temperature (CHAN bit = 1)*/
    /*Check if instruction recieved*/
    //Send 2 dymmy byte of any combination
    data1 = spi.write(0x00);
    data2 = spi.write(0x00);
    wait_us(200);
    csGyro=1;
    
    if(data1 & 0x80 ) /*0b10000000*/
    {
        pc.printf("\nInstruction not recieved");
    }

    csGyro=0;
    spi.write(0x80); /* 0b10000000 Send SPI ADCR Instruction*/
    /*Send 2 dymmy byte*/
    data1 = spi.write(0x00);
    data2 = spi.write(0x00);
    wait_us(200);
    csGyro=1;
    
    /*Check if instruction accepted*/
    if(!(data1 & 0x80))
    {
        while(!(data1 & 0x20)); // Wait while EOC is 0
        result = ((data1 & 0x0F) << 7) + (data2>>1);
    }
    return result;
}

int adcToAngularRate(unsigned int result)
{
    int conversion = (result * 25/12)+400;
    signed int offset = 2500;
    return (conversion - offset)/6.67; /*from the data sheet, R2 version is 6.67 E2 is 13.33 and N2 is 26.67 mV/deg change accordingly.*/
}

int adcToTemperature(unsigned int result)
{
    
    int conversion = (result * 25/16)+300;
    signed int offset = 2500;
    return 25 + ((conversion - offset)/10); /* from the data sheet factor is 10mV/K */
}

int main()
{
    unsigned int angle, temper;
    spi.format(8,3);
    spi.frequency(1000000);
    while(1){
    activateADC();
    
    angle=getAngularRate();
    temper=getTemperature();
    pc.printf("\nAngular Rate %d",adcToAngularRate(angle));
    pc.printf("\nTemperature %d",adcToTemperature(temper));
    sleepADC();
    wait(1);
    }
}