  #include "mbed.h"
  #include "Keypad.h"
#include "TextLCD.h"
 Keypad kpad(PTC8, PTC1, PTB19, PTB18, PTC5, PTC7, PTC0, PTC9);
 Serial pc(USBTX, USBRX);
 TextLCD lcd(PTA1, PTB23, PTA2, PTC2, PTC3, PTC12, TextLCD::LCD16x2); 
/*
col1, col2, col3, col4,
row1, row2, row3, row4
*/

const int number_of_chars = 4;
const char pass_user1[number_of_chars] = {'1','2','3','A'};  //HA
const char pass_user2[number_of_chars] = {'2','2','3','A'};  //FA
const char pass_user3[number_of_chars] = {'5','2','3','A'};  //AA
const char pass_user4[number_of_chars] = {'6','2','3','A'};  //MA
const char pass_user5[number_of_chars] = {'7','2','3','A'};  //FF

char enterd_pass[number_of_chars] = {' ', ' ',' ',' '};

DigitalOut led_red(LED_RED);
DigitalOut led_green(LED_GREEN);
DigitalOut active_buzzer(PTC4);  //Buzzer on pin PTC4=D9

PwmOut beep(PTC4); // buzzer

//Serial pc(USBTX, USBRX);

int main()
{
    char key;
    int i;
   int user_index1=0;
    int user_index2=0;
    int user_index3=0;
    int user_index4=0;
    int user_index5=0;
 
    int released =1;;
    

    led_green = 0;
    led_red = 0;
    active_buzzer = 0;

    beep.period(0.001);

    lcd.cls();
    wait(0.001);

    

    while(true) {
        
        lcd.locate(0,0); // col, row 
        lcd.printf("Enter Password:");

        // Reading the password characters
        for(i=0; i<number_of_chars; i++) {
            key = kpad.ReadKey();
        
    if(key == '\0')
             released = 1;                       //set the flag when all keys are released
           if((key != '\0') && (released == 1)) {  //if a key is pressed AND previous key was released
        enterd_pass[i]=key; 
        lcd.locate(i,1); // col, row             
        lcd.printf("*"); 
                    
              released = 0;                       //clear the flag to indicate that key is still pressed
              }
else
i--;
          

           
        }
        
        wait(0.5);
        
        lcd.locate(0,1); // col, row             
        lcd.printf("    " ); 
        
        // comparing passwords

      /////////    user 1    ///////////////
        for(i=0; i<number_of_chars; i++) {
            if( enterd_pass[i] == pass_user1[i] ) {
                user_index1 = 1;
            } else {
                user_index1 = 0;
                break;
            }
        }
        
        

        /////////    user 2    ///////////////
        for(i=0; i<number_of_chars; i++) {
            if( enterd_pass[i] == pass_user2[i] ) {
                user_index2 = 2;
            } else {
                user_index2 = 0;
                break;
            }
        }
        /////////    user 3    ///////////////
        for(i=0; i<number_of_chars; i++) {
            if( enterd_pass[i] == pass_user3[i] ) {
                user_index3 = 3;
            } else {
                user_index3 = 0;
                break;
            }
        }
        /////////    user 4    ///////////////
        for(i=0; i<number_of_chars; i++) {
            if( enterd_pass[i] == pass_user4[i] ) {
                user_index4 = 4;
            } else {
                user_index4 = 0;
                break;
            }
        }
        /////////    user 5    ///////////////
        for(i=0; i<number_of_chars; i++) {
            if( enterd_pass[i] == pass_user5[i] ) {
                user_index5 = 5;
            } else {
                user_index5 = 0;
                break;
            }
        }
//////////////////////////////////////////////////
        if( (1 == user_index1)||(2 == user_index2)||(3 == user_index3)||(4 == user_index4)||(5 == user_index5) ) {
            pc.printf("Access granted    ");
            led_red = 1;
            active_buzzer = 1;
            lcd.locate(0,1); // col, row
            lcd.printf("User: ");

            if(1 == user_index1) {
                lcd.locate(6,1); // col, row
                lcd.printf("HA");
            }
            if(2 == user_index2) {
                lcd.locate(6,1); // col, row
                lcd.printf("FA");
            }
            if(3 == user_index3) {
                lcd.locate(6,1); // col, row
                lcd.printf("AA");
            }
            if(4 == user_index4) {
                lcd.locate(6,1); // col, row
                lcd.printf("MA");
            }
            if(5 == user_index5) {
                lcd.locate(6,1); // col, row
                lcd.printf("FF");
            }

            wait(1);
            active_buzzer = 1;
            beep = 80.3/100.0;
            led_red = 0;
            wait(1);
       lcd.cls();


        }

        else {
            lcd.locate(0,0); // col, row  
            lcd.printf("Access denied     ");
            led_green = 1;
            wait(1);
            led_green = 0;
            active_buzzer = 0;
            beep = 0.0/100.0;
        }
        
        beep = 0.0/100.0;

    }
}

