#include "mbed.h"
#include "rtos.h"
#include "TS_DISCO_F746NG.h"
#include "LCD_DISCO_F746NG.h"
#include <string>
using namespace std;
 
 
#define BUTTON_DEPRESS_TIME_MIN 0.01000f

 
LCD_DISCO_F746NG lcd;
TS_DISCO_F746NG ts;
TS_StateTypeDef TS_State;
 
typedef struct{
     uint16_t x;
     uint16_t y;
     uint16_t width;
     uint16_t height;
}rectData_t;

typedef struct{
    rectData_t rectObj;
    uint16_t value;
    bool update_flag;
}hFeeder_t;

typedef struct{
    rectData_t rectObj;
    bool isPressed;
    bool update_flag;
    Timer depressTime;
}button_t;
 


rectData_t but1pos = {48, 68, 96, 60};
rectData_t but2pos = {192, 68, 96, 60};
rectData_t but3pos = {338, 68, 96, 60};
rectData_t hFeed1pos = {48, 152, 384, 30};
rectData_t hFeed2pos = {48, 212, 384, 30};

button_t   button1 = {but1pos,0,0};
button_t   button2 = {but2pos,0,0};
button_t   button3 = {but3pos,0,0};
hFeeder_t  hFeed1 = {hFeed1pos,0, 0};
hFeeder_t  hFeed2 = {hFeed2pos,0, 0};

void button(button_t *buttonObj, TS_StateTypeDef *TS_State){
    bool x_is_in =0;
    bool y_is_in =0; 
    
    uint16_t dyn_x = TS_State->touchX[0];
    uint16_t dyn_y = TS_State->touchY[0];

    if( (dyn_x>buttonObj->rectObj.x) && (dyn_x<(buttonObj->rectObj.x+buttonObj->rectObj.width)))  x_is_in = 1;
    if( (dyn_y>buttonObj->rectObj.y) && (dyn_y<(buttonObj->rectObj.y+buttonObj->rectObj.height)))  y_is_in = 1;  
    
    if(x_is_in && y_is_in){
        if(!(buttonObj->isPressed)){
            buttonObj->depressTime.start();
            buttonObj->isPressed = 1;
            lcd.SetTextColor(LCD_COLOR_GREEN);
            lcd.FillRect(buttonObj->rectObj.x, buttonObj->rectObj.y, buttonObj->rectObj.width, buttonObj->rectObj.height);
        }
    }
    
    
    else{
        if(buttonObj->isPressed){
            buttonObj->depressTime.stop();
            buttonObj->isPressed = 0;
            if(buttonObj->depressTime.read()>BUTTON_DEPRESS_TIME_MIN){
                buttonObj->update_flag=1;

            }
            buttonObj->depressTime.reset();
            lcd.SetTextColor(LCD_COLOR_RED);
            lcd.FillRect(buttonObj->rectObj.x, buttonObj->rectObj.y, buttonObj->rectObj.width, buttonObj->rectObj.height);
        }
    }   
}


void h_feeder(hFeeder_t *feederObj, TS_StateTypeDef *TS_State){
    bool x_is_in =0;
    bool y_is_in =0;
    
    uint16_t dyn_x = TS_State->touchX[0];
    uint16_t dyn_y = TS_State->touchY[0];
    
    if( (dyn_x>feederObj->rectObj.x) && (dyn_x<(feederObj->rectObj.x+feederObj->rectObj.width)))  x_is_in = 1;
    if( (dyn_y>feederObj->rectObj.y) && (dyn_y<(feederObj->rectObj.y+feederObj->rectObj.height)))  y_is_in = 1;
    

    if(x_is_in && y_is_in){
           uint16_t newFeedValue;
           newFeedValue = dyn_x - feederObj->rectObj.x;
           if(newFeedValue != feederObj->value){
                feederObj->update_flag = 1;
                feederObj->value = newFeedValue; 
                            
                lcd.SetTextColor(LCD_COLOR_RED);
                lcd.FillRect(feederObj->rectObj.x, feederObj->rectObj.y, feederObj->rectObj.width, feederObj->rectObj.height);
                lcd.SetTextColor(LCD_COLOR_GREEN);
                lcd.FillRect(feederObj->rectObj.x, feederObj->rectObj.y, feederObj->value, feederObj->rectObj.height);  
            }
    }
}   

int b1cnt=0, b2cnt=0,b3cnt=0;


//below are the callback functions for the buttons and feeders

//callback when button1 is pressed
void button1_callback(){
    b1cnt++;//keeps count of number of presses
    button1.update_flag = 0;
}

//callback when button2 is pressed
void button2_callback(){
    b2cnt++;//keeps count of number of presses
    button2.update_flag = 0;
}

//callback when button3 is pressed
void button3_callback(){
    b3cnt++;//keeps count of number of presses
    button3.update_flag = 0;
}

//callback on feeder1 update
void hFeeder1_callback(){

    hFeed1.update_flag = 0;
}

//callback on feeder2 update
void hFeeder2_callback(){


    hFeed2.update_flag = 0;     
}




int main(){

    uint8_t status;
    
    lcd.DisplayStringAt(0, LINE(5), (uint8_t *)"WOLLONGONG UNIVERSITY", CENTER_MODE);
    Thread::wait(1000);

    status = ts.Init(lcd.GetXSize(), lcd.GetYSize());
    if (status != TS_OK) {
        lcd.Clear(LCD_COLOR_RED);
        lcd.SetBackColor(LCD_COLOR_RED);
        lcd.SetTextColor(LCD_COLOR_WHITE);
        lcd.DisplayStringAt(0, LINE(5), (uint8_t *)"TOUCHSCREEN INIT FAIL", CENTER_MODE);
    } else {
        lcd.Clear(LCD_COLOR_BLUE);
        lcd.SetBackColor(LCD_COLOR_BLUE);
        lcd.SetTextColor(LCD_COLOR_WHITE);
        lcd.DisplayStringAt(0, LINE(5), (uint8_t *)"TOUCHSCREEN INIT OK", CENTER_MODE);
    }
    
    lcd.SetBackColor(LCD_COLOR_YELLOW);
    lcd.SetTextColor(LCD_COLOR_RED);
    
    lcd.Clear(LCD_COLOR_WHITE);
    
    
    lcd.SetTextColor(LCD_COLOR_RED);
    lcd.FillRect(but1pos.x, but1pos.y, but1pos.width, but1pos.height);
    lcd.FillRect(but2pos.x, but2pos.y, but2pos.width, but2pos.height);
    lcd.FillRect(but3pos.x, but3pos.y, but3pos.width, but3pos.height);
    
    lcd.FillRect(hFeed1pos.x, hFeed1pos.y, hFeed1pos.width, hFeed1pos.height);
    lcd.FillRect(hFeed2pos.x, hFeed2pos.y, hFeed2pos.width, hFeed2pos.height);
    
    Thread::wait(1000);


    while(1){
        
        ts.ResetTouchData(&TS_State);
        ts.GetState(&TS_State);
        //if (TS_State.touchDetected) 
        {
            h_feeder(&hFeed1, &TS_State);
            h_feeder(&hFeed2, &TS_State);
            button(&button1, &TS_State);
            button(&button2, &TS_State);
            button(&button3, &TS_State);
            
        }
        
        if(hFeed1.update_flag)hFeeder1_callback();
        if(hFeed2.update_flag)hFeeder2_callback();
        if(button1.update_flag) button1_callback();
        if(button2.update_flag) button2_callback();
        if(button3.update_flag) button3_callback();
        
        printf("GUI values are \t\t%d,%d,%d\t%d,%d\t(%d,%d)\r\n", b1cnt, b2cnt,b3cnt,hFeed1.value, hFeed2.value,TS_State.touchX[0],TS_State.touchY[0]);
        //printf("feeder values are (%d,%d) %f,%f,%f  %d,%d\r\n", TS_State.touchX[0],TS_State.touchY[0],button1.depressTime.read(), button2.depressTime.read(),button3.depressTime.read(),hFeed1.value, hFeed2.value);
        
    }
}



/////////////////////////////////////////////////////////////////////
//ACCELEROMETER TEST

#include "ADXL345.h"
 
ADXL345 accelerometer(D11,D12,D13,D10);
Serial pc(USBTX, USBRX);

int main2() {
 
    int readings[3] = {0, 0, 0};
    
    pc.printf("Starting ADXL345 test...\n");
    pc.printf("Device ID is: 0x%02x\n", accelerometer.getDevId());
 
    //Go into standby mode to configure the device.
    accelerometer.setPowerControl(0x00);
 
    //Full resolution, +/-16g, 4mg/LSB.
    accelerometer.setDataFormatControl(0x0B);
    
    //3.2kHz data rate.
    accelerometer.setDataRate(ADXL345_3200HZ);
 
    //Measurement mode.
    accelerometer.setPowerControl(0x08);
 
    while (1) {
    
        wait(0.1);
        
        accelerometer.getOutput(readings);
        
        //13-bit, sign extended values.
        pc.printf("%i, %i, %i\n", (int16_t)readings[0], (int16_t)readings[1], (int16_t)readings[2]);
 
    }
 
}




 