/* HCSR04 - MBED library for Ultrasonic Ranging Module HC - SR04
 * Copyright (C) 2016 Haakon Sporsheim <haakon.sporsheim@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3.0 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library.
 * See the COPYING file at the root of the source repository.
 */

#ifndef __HCSR04_H__
#define __HCSR04_H__

#include <mbed.h>

class HCSR04
{
    public:
        HCSR04(PinName pinTrig, PinName pinEcho);

        void start(void (*cb)(uint32_t), float interval);
        void stop(void);

    private:
        DigitalOut      trig;
        InterruptIn     echo;
        Ticker          ticker;
        Timer           timer;
        int             timeEcho;
        
        void            (*cbUpdate)(uint32_t);

        void update(void);
        void echoRise(void);
        void echoFall(void);
};

#endif /* __HCSR04_H__ */
