/* HCSR04 - MBED library for Ultrasonic Ranging Module HC - SR04
 * Copyright (C) 2016 Haakon Sporsheim <haakon.sporsheim@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3.0 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library.
 * See the COPYING file at the root of the source repository.
 */

#include "hcsr04.h"

HCSR04::HCSR04(PinName pinTrig, PinName pinEcho)
    : trig(pinTrig), echo(pinEcho)
{
    echo.rise(this, &HCSR04::echoRise);   
    echo.fall(this, &HCSR04::echoFall);
    trig = 0;
}

void HCSR04::echoRise(void)
{
    timeEcho = timer.read_us();
}

void HCSR04::echoFall(void)
{
    int dur = timer.read_us() - timeEcho;
    // sound travels 343.2m/s in dry air @ 20C
    // ==> 0.3432 mm/us
    uint32_t dist = (float)dur * 0.3432 / 2;
    
    cbUpdate(dist);
}

void HCSR04::update(void)
{
    trig = 1;
    wait_us(10);
    trig = 0;
}

void HCSR04::start(void (*cb)(uint32_t), float interval)
{
    stop();
    cbUpdate = cb;
    timer.start();
    ticker.attach(this, &HCSR04::update, interval);
    update();
}
    
void HCSR04::stop(void)
{
    timer.stop();
    ticker.detach();
}
