#include "mbed.h"
#include "SDFileSystem.h"
#include "AitendoTFT.h"
#include "TinyJpgDec.h"

AitendoTFT tft;
SDFileSystem sd(SPI_MOSI, SPI_MISO, SPI_SCK, SPI_CS, "sd"); // the pinout on the mbed Cool Components workshop board

JDEC jdec;
WORD work[3100/sizeof(WORD)];
FileHandle *fh;

UINT jpeg_input_func(JDEC *jd, BYTE *buff, UINT ndata)
{
    if(buff) {
        size_t n = fh->read(buff, ndata);
        return n == (size_t)-1 ? 0 : n;
    } else {
        off_t t = fh->lseek( ndata, SEEK_CUR);
        return t == (off_t)-1 ? 0 : ndata;
    }
}

UINT jpeg_output_func(JDEC *jd, void *bitmap, JRECT *rect)
{
    WORD *src = (WORD *)bitmap;
    int x0 = rect->left;
    int x1 = rect->right;
    int y0 = rect->top;
    int y1 = rect->bottom;
    int w = x1 - x0 + 1;

    if(y0 >= AitendoTFT::TFT_HEIGHT ||x0 >= AitendoTFT::TFT_WIDTH)
        return 1;

    if(x1 > AitendoTFT::TFT_WIDTH-1) x1 = AitendoTFT::TFT_WIDTH - 1;
    if(y1 > AitendoTFT::TFT_HEIGHT-1) y1 = AitendoTFT::TFT_HEIGHT - 1;

    if(x0 == 0)
        printf("\r %d", y0);

    for(int y= y0; y <= y1; y++) {
        tft.setPos(x0, y);
        WORD *p = src + w * (y - y0);
        for(int x=x0; x <= x1; x++)
            tft.put(*p++);
    }
    return 1;
}

int main()
{
    JRESULT r;
    int cFile;
    char path[80];


    printf("Nucleo Picture Viewer\n");

    while(1) {
        cFile = 0;
        DirHandle *dh = sd.opendir("/images");
        if(dh == NULL)
            error("/images not found.\n");
        else {
            while(1) {
                struct dirent *de = dh->readdir();
                if(de == NULL) break;
                char *ext = strrchr(de->d_name,'.');
                if(ext == NULL || strcmp(ext,".jpg")!=0) continue;
                cFile++;
                snprintf(path, sizeof path, "images/%s", de->d_name);
                printf("\nshow %s\n", path);
                fh = sd.open(path, 0);
                if(fh == NULL) error("%s not found.",path);

                r = jd_prepare(&jdec, jpeg_input_func, work, sizeof work, fh);
                if(r != JDR_OK) error("jd_prepare error:%d", r);
                r = jd_decomp(&jdec, jpeg_output_func, 0);
                fh->close();
                if( r != JDR_OK) error("jd_decomp error:%d", r);
                wait(10);
            }
            dh->closedir();
        }
        if(cFile == 0) error("no .jpg file found in /images");
    }
}
