#ifndef _aitendo_tft_h
#define _aitendo_tft_h

#include "mbed.h"

class AitendoTFT
{
public:
    AitendoTFT();
    enum {TFT_WIDTH = 240, TFT_HEIGHT = 320,
          BLACK = 0x0000, BLUE = 0x001F, RED = 0xf800, GREEN = 0x07e0, WHITE = 0xffff
         };
    void fillArea(int x0, int y0, int x1, int y1, int color);
    void fill(int color) {
        fillArea(0, 0, TFT_WIDTH, TFT_HEIGHT, color);
    };
    void pset(int x, int y, int color);
    void setPos(int x, int y) {
        _pos_set(x, y);
    };
    void put(int color) {
        _write(1, color);
    }
private:
    DigitalOut _rst, _cs, _rs, _wr, _rd;
    BusInOut _d;

    void _init(void);
    void _reset(void);
    void _write(int rs, int d);
    void _data_write(int data) {
        _write(1, data);
    };
    void _cmd_write(int cmd) {
        _write(0, cmd);
    };
    void _reg_write(int addr, int data);
    void _pos_set(int x, int y);
};

#endif /* _aitendo_tft_h */