#include "AitendoTFT.h"
#include "mbed_debug.h"


#define TFTLCD_GRAM_HOR_AD          0x20
#define TFTLCD_GRAM_VER_AD          0x21
#define TFTLCD_RW_GRAM              0x22
#define TFTLCD_DELAYCMD             0xFF

static const unsigned short _regValues[] = {
  0x0001,0x0100,    
  0x0002,0x0700,    
  0x0003,0x1030,    
  0x0008,0x0302,    
  0x0009,0x0000,   
  0x000A,0x0008,    
  //*******POWER CONTROL REGISTER INITIAL*******//    
  0x0010,0x0790,    
  0x0011,0x0005,    
  0x0012,0x0000,   
  0x0013,0x0000,
  TFTLCD_DELAYCMD, 50,      //delayms(50, 
  //********POWER SUPPPLY STARTUP 1 SETTING*******//    
  0x0010,0x12B0,    
  TFTLCD_DELAYCMD, 50,      // delayms(50,  
  0x0011,0x0007,    
  //delayms(50,  
  //********POWER SUPPLY STARTUP 2 SETTING******//    
  0x0012,0x008C,    
  0x0013,0x1700,    
  0x0029,0x0022,    
  TFTLCD_DELAYCMD, 50,      // delayms(50,   
  //******GAMMA CLUSTER SETTING******//    
  0x0030,0x0000,    
  0x0031,0x0505,    
  0x0032,0x0205,    
  0x0035,0x0206,    
  0x0036,0x0408,    
  0x0037,0x0000,    
  0x0038,0x0504,
  0x0039,0x0206,    
  0x003C,0x0206,    
  0x003D,0x0408,    
  // -----------DISPLAY WINDOWS 240*320-------------//    
  0x0050,0x0000,
  0x0051,0x00EF,   
  0x0052,0x0000,   
  0x0053,0x013F,   
  //-----FRAME RATE SETTING-------//    
  0x0060,0xA700,   
  0x0061,0x0001,   
  0x0090,0x0033, //RTNI setting
  //-------DISPLAY ON------//    
  0x0007,0x0133,    0x0001,0x0100,    
  0x0002,0x0700,    
  0x0003,0x1030,    
  0x0008,0x0302,    
  0x0009,0x0000,   
  0x000A,0x0008,    
  //*******POWER CONTROL REGISTER INITIAL*******//    
  0x0010,0x0790,    
  0x0011,0x0005,    
  0x0012,0x0000,   
  0x0013,0x0000,    
  //delayms(50, 
  //********POWER SUPPPLY STARTUP 1 SETTING*******//    
  0x0010,0x12B0,    
  TFTLCD_DELAYCMD, 50,      // delayms(50,  
  0x0011,0x0007,    
  TFTLCD_DELAYCMD, 50,      // delayms(50,  
  //********POWER SUPPLY STARTUP 2 SETTING******//    
  0x0012,0x008C,    
  0x0013,0x1700,    
  0x0029,0x0022,    
  TFTLCD_DELAYCMD, 50,      // delayms(50,   
  //******GAMMA CLUSTER SETTING******//    
  0x0030,0x0000,    
  0x0031,0x0505,    
  0x0032,0x0205,    
  0x0035,0x0206,    
  0x0036,0x0408,    
  0x0037,0x0000,    
  0x0038,0x0504,
  0x0039,0x0206,    
  0x003C,0x0206,    
  0x003D,0x0408,    
  // -----------DISPLAY WINDOWS 240*320-------------//    
  0x0050,0x0000,
  0x0051,0x00EF,   
  0x0052,0x0000,   
  0x0053,0x013F,   
  //-----FRAME RATE SETTING-------//    
  0x0060,0xA700,   
  0x0061,0x0001,   
  0x0090,0x0033, //RTNI setting
  //-------DISPLAY ON------//    
  0x0007,0x0133,   
};


AitendoTFT::AitendoTFT(void) :
    _rst(A4), _cs(A3), _rs(A2), _wr(A1), _rd(A0),_d( D8, D9, D2, D3, D4, D5, D6, D7)
{
    _init();
}

void AitendoTFT::_init(void)
{
    _rst = 1;
    _cs = 1;
    _wr = 1;
    _rd = 1;
    _d.input();

    _reset();

    for(int i=0; i < sizeof(_regValues)/sizeof(_regValues[0]); i+= 2) {
        int a = _regValues[i];
        int d = _regValues[i+1];
        if(a == TFTLCD_DELAYCMD)
            wait_ms(d);
        else
            _reg_write(a, d);
    }
}

void AitendoTFT::_reset(void)
{
    _rst = 0;
    wait_ms(2);    
    _rst = 1;
    
    _data_write(0);
    _data_write(0);
    _data_write(0);
    _data_write(0);
}

void AitendoTFT::_write(int rs, int d)
{
    _cs = 0;
    _rs = rs;
    _rd = 1;
    _wr = 1;
    _d.output();
    
    _d = d >> 8;
    _wr = 0;
    wait_us(1);     // 1us
    _wr = 1;
    
    _d = d;
    _wr = 0;
    wait_us(1);     // 1us
    _wr = 1;
    
    _cs = 1;
}

void AitendoTFT::_reg_write(int addr, int data)
{
    _cmd_write(addr);
    _data_write(data);
}

void AitendoTFT::_pos_set(int x, int y)
{
    _reg_write(TFTLCD_GRAM_HOR_AD, x);
    _reg_write(TFTLCD_GRAM_VER_AD, y);
    _cmd_write(TFTLCD_RW_GRAM);
}

void AitendoTFT::fillArea(int x0, int y0, int x1, int y1, int color)
{
    for(int y=y0; y<y1; y++){
        _pos_set(x0, y);
        for(int x = x0; x < x1; x++)
            _data_write(color);
    }
}

void AitendoTFT::pset(int x, int y, int color)
{
    if(x >= 0 && x < TFT_WIDTH && y > 0 && y < TFT_HEIGHT){
        _pos_set(x, y);
        _data_write(color);
    }
}



    
    

