#include "mbed.h"

PwmOut led(D5);
InterruptIn button_up(A2);
InterruptIn button_center(D4);
InterruptIn button_down(A3);
Serial pc(SERIAL_TX, SERIAL_RX);

double brightness = 1.0;
double brightness_inc = 0.1;

void press_up()
{
    brightness -= brightness_inc;
}

void press_down()
{
    brightness += brightness_inc;
}

void press_center()
{
    brightness = (brightness>0.5)?1.0:0.0;
}

void serial_in()
{
    char ch = getc(pc);
    if(ch < '0' || ch > '9')
        pc.printf("Please input a number between 0 to 9.\r\n");
    else
        brightness = 1 - (ch - '0') / 10.0;
}

int main()
{
    pc.baud(9600);
    pc.attach(&serial_in);
    pc.printf("Hello PWM!\r\n");
    pc.printf("Please input a number between 0 to 9.\r\n");
    // Set PWM
    led.write(brightness);
    
    button_up.fall(&press_up);
    button_down.fall(&press_down);
    button_center.fall(&press_center);

    while (1) {
        brightness = (brightness>1.0)?0.0:brightness;
        brightness = (brightness<0.0)?1.0:brightness;
        led.write(brightness);
    }
}
