#include "mbed.h"

PwmOut led(D5);
DigitalIn button_up(A2);
DigitalIn button_center(D4);
DigitalIn button_down(A3);
Serial pc(SERIAL_TX, SERIAL_RX);

double brightness = 1.0;
double brightness_inc = 0.1;

int main()
{
    int bt_flag = 0;
    pc.baud(9600);
    pc.printf("Hello PWM!\r\n");
    // Set PWM
    led.write(brightness);

    while (1) {
        bt_flag = 1;
        if(button_up==1)
            brightness -= brightness_inc;
        else if(button_down==1)
            brightness += brightness_inc;
        else if(button_center==1)
            brightness = (brightness>0.5)?1.0:0.0;
        else
            bt_flag = 0;
        if(bt_flag==1)
        {
            brightness = (brightness>1.0)?0.0:brightness;
            brightness = (brightness<0.0)?1.0:brightness;
            led.write(brightness);
            pc.printf("Brightness = %.1f\r\n", 1.0-brightness);
        }
        wait(0.2); // 200 ms
    }
}
